% This demo script runs our calibration engine on Hynek Bakstein's data (2D rigs)
% available at: http://terezka.ufa.cas.cz/hynek/toolbox.html
% This code loads the data from the format available on his web site, converts
% in my data format, runs the main calibration engine, displays the results and saves
% the results into a file called Calib_Results.mat

% (c) Jean-Yves Bouguet - Dec 25th, 1999


% Preparing the data:

clear;

load realcds;

n_ima = 6;

x_1 = shot2(:,4:5)';
X_1 = shot2(:,1:3)';
x_2 = shot3(:,4:5)';
X_2 = shot3(:,1:3)';
x_3 = shot5(:,4:5)';
X_3 = shot5(:,1:3)';
x_4 = shot7(:,4:5)';
X_4 = shot7(:,1:3)';
x_5 = shot9(:,4:5)';
X_5 = shot9(:,1:3)';
x_6 = shot11(:,4:5)';
X_6 = shot11(:,1:3)';

% Image size: (may or may not be available)

nx = 768;
ny = 576;

% No calibration image is available (only the corner coordinates)

no_image = 1;

% Set the toolbox not to prompt the user (choose default values)

dont_ask = 1;

% Run the main calibration routine:

go_calib_optim;

% Shows the extrinsic parameters:

ext_calib;

% Reprojection on the original images:

reproject_calib;

% Set the toolbox to normal mode of operation again:

dont_ask =  0;

