/*
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

*/

#ifndef ARDOCKINTERFACE_H
#define ARDOCKINTERFACE_H

#include "Aria.h"
#include "ArNetworking.h"

/// Interface for objects that provide information about a robot's docking status. 
/**
 *  ArDockInterface defines the methods that enable the AramScheduler to 
 *  determine the docking status of a robot.  For a local robot, these methods are
 *  implemented by ArServerModeDock.  With the central server and remote robots, 
 *  these methods are implemented by AramCentralDockProxy.  
**/
class ArDockInterface  
{
public:
	enum State {
    UNDOCKED,
    DOCKING,
    DOCKED,
    UNDOCKING
  };

	AREXPORT static const char *toString(State s) {
    switch (s) {
		case UNDOCKED:
			return "UNDOCKED";
		case DOCKING:
			return "DOCKING";
		case DOCKED:
			return "DOCKED";
		case UNDOCKING:
			return "UNDOCKING";
		} // end switch state

		return "unknown";

	} // end method toString


  /// Constructor
  AREXPORT ArDockInterface() {}
  /// Destructor
  AREXPORT virtual ~ArDockInterface() {}


  /// Gets the docking state we're in
  AREXPORT virtual State getState() const = 0;

	/// Gets whether our docking is forced or not
  AREXPORT virtual bool getForcedDock() = 0;

}; // end class ArDockInterface


#endif // ARDOCKINTERFACE_H
