/*
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

*/
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.mobilerobots.Arnl;

  import com.mobilerobots.Aria.*;
  import com.mobilerobots.ArNetworking.*;
  import com.mobilerobots.BaseArnl.*;

public class ArLocalizationTask extends ArBaseLocalizationTask {
  private long swigCPtr;

  /* for internal use by swig only */
  public ArLocalizationTask(long cPtr, boolean cMemoryOwn) {
    super(ArnlJavaJNI.SWIGArLocalizationTaskUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  /* for internal use by swig only */
  public static long getCPtr(ArLocalizationTask obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      ArnlJavaJNI.delete_ArLocalizationTask(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  public ArLocalizationTask(ArRobot robot, ArRangeDevice laser, String mapName) {
    this(ArnlJavaJNI.new_ArLocalizationTask__SWIG_0(ArRobot.getCPtr(robot), ArRangeDevice.getCPtr(laser), mapName), true);
  }

  public ArLocalizationTask(ArRobot robot, ArRangeDevice laser, ArMapInterface ariaMap, boolean noReflectors) {
    this(ArnlJavaJNI.new_ArLocalizationTask__SWIG_1(ArRobot.getCPtr(robot), ArRangeDevice.getCPtr(laser), ArMapInterface.getCPtr(ariaMap), noReflectors), true);
  }

  public ArLocalizationTask(ArRobot robot, ArRangeDevice laser, ArMapInterface ariaMap) {
    this(ArnlJavaJNI.new_ArLocalizationTask__SWIG_2(ArRobot.getCPtr(robot), ArRangeDevice.getCPtr(laser), ArMapInterface.getCPtr(ariaMap)), true);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor, boolean warn, boolean setInitializedToFalse, boolean rayTrace) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotInMapInit__SWIG_0(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor, warn, setInitializedToFalse, rayTrace);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor, boolean warn, boolean setInitializedToFalse) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotInMapInit__SWIG_1(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor, warn, setInitializedToFalse);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor, boolean warn) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotInMapInit__SWIG_2(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor, warn);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotInMapInit__SWIG_3(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor);
  }

  public boolean localizeRobotInMapMoved(int numSamples, double distFactor, double angFactor, double thresFactor) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotInMapMoved(swigCPtr, numSamples, distFactor, angFactor, thresFactor);
  }

  public boolean localizeRobotAtHomeBlocking(double distSpread, double angleSpread, double probThreshold) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotAtHomeBlocking__SWIG_0(swigCPtr, distSpread, angleSpread, probThreshold);
  }

  public boolean localizeRobotAtHomeBlocking(double spreadX, double spreadY, double angleSpread, double probThreshold) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotAtHomeBlocking__SWIG_1(swigCPtr, spreadX, spreadY, angleSpread, probThreshold);
  }

  public boolean localizeRobotAtHomeBlocking(double distSpread, double angleSpread) {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotAtHomeBlocking__SWIG_2(swigCPtr, distSpread, angleSpread);
  }

  public boolean localizeRobotAtHomeBlocking() {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotAtHomeBlocking__SWIG_3(swigCPtr);
  }

  public boolean localizeRobotAtHomeNonBlocking() {
    return ArnlJavaJNI.ArLocalizationTask_localizeRobotAtHomeNonBlocking(swigCPtr);
  }

  public ArPose getRobotHome() {
    return new ArPose(ArnlJavaJNI.ArLocalizationTask_getRobotHome(swigCPtr), true);
  }

  public void setForceUpdateParams(int numSamples, double xStd, double yStd, double tStd) {
    ArnlJavaJNI.ArLocalizationTask_setForceUpdateParams(swigCPtr, numSamples, xStd, yStd, tStd);
  }

  public void forceUpdatePose(ArPose forcePose, boolean rayTrace) {
    ArnlJavaJNI.ArLocalizationTask_forceUpdatePose__SWIG_0(swigCPtr, ArPose.getCPtr(forcePose), rayTrace);
  }

  public void forceUpdatePose(ArPose forcePose) {
    ArnlJavaJNI.ArLocalizationTask_forceUpdatePose__SWIG_1(swigCPtr, ArPose.getCPtr(forcePose));
  }

  public void addFailedLocalizationCB(ArFunctor1_Int functor) {
    ArnlJavaJNI.ArLocalizationTask_addFailedLocalizationCB(swigCPtr, ArFunctor1_Int.getCPtr(functor));
  }

  public void remFailedLocalizationCB(ArFunctor1_Int functor) {
    ArnlJavaJNI.ArLocalizationTask_remFailedLocalizationCB(swigCPtr, ArFunctor1_Int.getCPtr(functor));
  }

  public boolean setGridResolution(double res, ArMapInterface ariaMap) {
    return ArnlJavaJNI.ArLocalizationTask_setGridResolution(swigCPtr, res, ArMapInterface.getCPtr(ariaMap));
  }

  public void setFailedCallBack(ArFunctor1_Int fcb) {
    ArnlJavaJNI.ArLocalizationTask_setFailedCallBack(swigCPtr, ArFunctor1_Int.getCPtr(fcb));
  }

  public void setTriggerDelR(double tr) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerDelR(swigCPtr, tr);
  }

  public void setTriggerDelT(double tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerDelT(swigCPtr, tt);
  }

  public void setTriggerTimeFlag(boolean tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerTimeFlag(swigCPtr, tt);
  }

  public void setTriggerTime(double tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerTime(swigCPtr, tt);
  }

  public void setTriggerTimeX(double tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerTimeX(swigCPtr, tt);
  }

  public void setTriggerTimeY(double tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerTimeY(swigCPtr, tt);
  }

  public void setTriggerTimeTh(double tt) {
    ArnlJavaJNI.ArLocalizationTask_setTriggerTimeTh(swigCPtr, tt);
  }

  public void setNumSamples(int n) {
    ArnlJavaJNI.ArLocalizationTask_setNumSamples(swigCPtr, n);
  }

  public void setNumSamplesAtInit(int n) {
    ArnlJavaJNI.ArLocalizationTask_setNumSamplesAtInit(swigCPtr, n);
  }

  public void setRayTraceAtInit(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setRayTraceAtInit(swigCPtr, f);
  }

  public void setCurrentNumSamples(int n) {
    ArnlJavaJNI.ArLocalizationTask_setCurrentNumSamples(swigCPtr, n);
  }

  public void setPassThreshold(double f) {
    ArnlJavaJNI.ArLocalizationTask_setPassThreshold(swigCPtr, f);
  }

  public void setSensorBelief(double sensorBelief) {
    ArnlJavaJNI.ArLocalizationTask_setSensorBelief(swigCPtr, sensorBelief);
  }

  public void setCurrentLocaPose(double x, double y, double th) {
    ArnlJavaJNI.ArLocalizationTask_setCurrentLocaPose__SWIG_0(swigCPtr, x, y, th);
  }

  public void setCurrentLocaPose(ArPose p) {
    ArnlJavaJNI.ArLocalizationTask_setCurrentLocaPose__SWIG_1(swigCPtr, ArPose.getCPtr(p));
  }

  public void setVerboseFlag(boolean a) {
    ArnlJavaJNI.ArLocalizationTask_setVerboseFlag(swigCPtr, a);
  }

  public void setAngleIncrement(double f) {
    ArnlJavaJNI.ArLocalizationTask_setAngleIncrement(swigCPtr, f);
  }

  public void setKillThreshold(double f) {
    ArnlJavaJNI.ArLocalizationTask_setKillThreshold(swigCPtr, f);
  }

  public void setRecoverOnFailedFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setRecoverOnFailedFlag(swigCPtr, f);
  }

  public void setIdleFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setIdleFlag(swigCPtr, f);
  }

  public void setReloadingMapFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setReloadingMapFlag(swigCPtr, f);
  }

  public void setEnableReflectorLocalizationFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setEnableReflectorLocalizationFlag(swigCPtr, f);
  }

  public void setReflectorVar(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorVar(swigCPtr, f);
  }

  public void setReflectorMatchDist(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorMatchDist(swigCPtr, f);
  }

  public void setReflectorMatchAngle(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorMatchAngle(swigCPtr, f);
  }

  public void setReflectorMaxRange(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorMaxRange(swigCPtr, f);
  }

  public void setReflectorMaxAngle(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorMaxAngle(swigCPtr, f);
  }

  public void setReflectorSize(double f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectorSize(swigCPtr, f);
  }

  public void setReflectanceThreshold(int f) {
    ArnlJavaJNI.ArLocalizationTask_setReflectanceThreshold(swigCPtr, f);
  }

  public void setBypassMCLFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setBypassMCLFlag(swigCPtr, f);
  }

  public void getForceUpdateParams(ArPose forcePose, SWIGTYPE_p_int numSamples, SWIGTYPE_p_double xStd, SWIGTYPE_p_double yStd, SWIGTYPE_p_double tStd) {
    ArnlJavaJNI.ArLocalizationTask_getForceUpdateParams(swigCPtr, ArPose.getCPtr(forcePose), SWIGTYPE_p_int.getCPtr(numSamples), SWIGTYPE_p_double.getCPtr(xStd), SWIGTYPE_p_double.getCPtr(yStd), SWIGTYPE_p_double.getCPtr(tStd));
  }

  public boolean getVerboseFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getVerboseFlag(swigCPtr);
  }

  public boolean getInitializedFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getInitializedFlag(swigCPtr);
  }

  public int getNumSamples() {
    return ArnlJavaJNI.ArLocalizationTask_getNumSamples(swigCPtr);
  }

  public int getNumSamplesAtInit() {
    return ArnlJavaJNI.ArLocalizationTask_getNumSamplesAtInit(swigCPtr);
  }

  public boolean getRayTraceAtInit() {
    return ArnlJavaJNI.ArLocalizationTask_getRayTraceAtInit(swigCPtr);
  }

  public int getCurrentNumSamples() {
    return ArnlJavaJNI.ArLocalizationTask_getCurrentNumSamples(swigCPtr);
  }

  public ArPose getRobotMaxProbPose() {
    return new ArPose(ArnlJavaJNI.ArLocalizationTask_getRobotMaxProbPose(swigCPtr), true);
  }

  public double getTriggerDelR() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerDelR(swigCPtr);
  }

  public double getTriggerDelT() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerDelT(swigCPtr);
  }

  public boolean getTriggerTimeFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerTimeFlag(swigCPtr);
  }

  public double getTriggerTime() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerTime(swigCPtr);
  }

  public double getTriggerTimeX() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerTimeX(swigCPtr);
  }

  public double getTriggerTimeY() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerTimeY(swigCPtr);
  }

  public double getTriggerTimeTh() {
    return ArnlJavaJNI.ArLocalizationTask_getTriggerTimeTh(swigCPtr);
  }

  public double getPassThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getPassThreshold(swigCPtr);
  }

  public double getUsingPassThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getUsingPassThreshold(swigCPtr);
  }

  public void setTempPassThreshold(double passThreshold) {
    ArnlJavaJNI.ArLocalizationTask_setTempPassThreshold(swigCPtr, passThreshold);
  }

  public double getTempPassThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getTempPassThreshold(swigCPtr);
  }

  public void clearTempPassThreshold() {
    ArnlJavaJNI.ArLocalizationTask_clearTempPassThreshold(swigCPtr);
  }

  public double getLocalizationScore() {
    return ArnlJavaJNI.ArLocalizationTask_getLocalizationScore(swigCPtr);
  }

  public double getLocalizationThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getLocalizationThreshold(swigCPtr);
  }

  public double getMCLocalizationScore() {
    return ArnlJavaJNI.ArLocalizationTask_getMCLocalizationScore(swigCPtr);
  }

  public double getRefLocalizationScore() {
    return ArnlJavaJNI.ArLocalizationTask_getRefLocalizationScore(swigCPtr);
  }

  public double getSensorBelief() {
    return ArnlJavaJNI.ArLocalizationTask_getSensorBelief__SWIG_0(swigCPtr);
  }

  public ArPose getCurrentLocaPose() {
    return new ArPose(ArnlJavaJNI.ArLocalizationTask_getCurrentLocaPose(swigCPtr), true);
  }

  public double getStdX() {
    return ArnlJavaJNI.ArLocalizationTask_getStdX(swigCPtr);
  }

  public double getStdY() {
    return ArnlJavaJNI.ArLocalizationTask_getStdY(swigCPtr);
  }

  public double getStdTh() {
    return ArnlJavaJNI.ArLocalizationTask_getStdTh(swigCPtr);
  }

  public double getErrorMmPerMm() {
    return ArnlJavaJNI.ArLocalizationTask_getErrorMmPerMm(swigCPtr);
  }

  public double getErrorDegPerDeg() {
    return ArnlJavaJNI.ArLocalizationTask_getErrorDegPerDeg(swigCPtr);
  }

  public double getErrorDegPerMm() {
    return ArnlJavaJNI.ArLocalizationTask_getErrorDegPerMm(swigCPtr);
  }

  public double getPeakFactor() {
    return ArnlJavaJNI.ArLocalizationTask_getPeakFactor(swigCPtr);
  }

  public double getOccThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getOccThreshold(swigCPtr);
  }

  public double getGridRes() {
    return ArnlJavaJNI.ArLocalizationTask_getGridRes(swigCPtr);
  }

  public String getMapName() {
    return ArnlJavaJNI.ArLocalizationTask_getMapName(swigCPtr);
  }

  public double getPeturbRangeX() {
    return ArnlJavaJNI.ArLocalizationTask_getPeturbRangeX(swigCPtr);
  }

  public double getPeturbRangeY() {
    return ArnlJavaJNI.ArLocalizationTask_getPeturbRangeY(swigCPtr);
  }

  public double getPeturbRangeTh() {
    return ArnlJavaJNI.ArLocalizationTask_getPeturbRangeTh(swigCPtr);
  }

  public double getFailedRangeX() {
    return ArnlJavaJNI.ArLocalizationTask_getFailedRangeX(swigCPtr);
  }

  public double getFailedRangeY() {
    return ArnlJavaJNI.ArLocalizationTask_getFailedRangeY(swigCPtr);
  }

  public double getFailedRangeTh() {
    return ArnlJavaJNI.ArLocalizationTask_getFailedRangeTh(swigCPtr);
  }

  public double getPeakStdX() {
    return ArnlJavaJNI.ArLocalizationTask_getPeakStdX(swigCPtr);
  }

  public double getPeakStdY() {
    return ArnlJavaJNI.ArLocalizationTask_getPeakStdY(swigCPtr);
  }

  public double getPeakStdTh() {
    return ArnlJavaJNI.ArLocalizationTask_getPeakStdTh(swigCPtr);
  }

  public double getAngleIncrement() {
    return ArnlJavaJNI.ArLocalizationTask_getAngleIncrement(swigCPtr);
  }

  public double getKillThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getKillThreshold(swigCPtr);
  }

  public ArMapInterface getAriaMap() {
    long cPtr = ArnlJavaJNI.ArLocalizationTask_getAriaMap(swigCPtr);
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public int getBufferSize() {
    return ArnlJavaJNI.ArLocalizationTask_getBufferSize(swigCPtr);
  }

  public SWIGTYPE_p_std__vectorTArPose_t getXYBuffer() {
    return new SWIGTYPE_p_std__vectorTArPose_t(ArnlJavaJNI.ArLocalizationTask_getXYBuffer(swigCPtr), true);
  }

  public ArPose getBufferPose() {
    return new ArPose(ArnlJavaJNI.ArLocalizationTask_getBufferPose(swigCPtr), true);
  }

  public SWIGTYPE_p_ArOccGrid getOccGridPtr() {
    long cPtr = ArnlJavaJNI.ArLocalizationTask_getOccGridPtr(swigCPtr);
    return (cPtr == 0) ? null : new SWIGTYPE_p_ArOccGrid(cPtr, false);
  }

  public ArPoseList getCurrentSamplePoses() {
    return new ArPoseList(ArnlJavaJNI.ArLocalizationTask_getCurrentSamplePoses(swigCPtr), true);
  }

  public boolean getRecoverOnFailedFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getRecoverOnFailedFlag(swigCPtr);
  }

  public boolean getIgnoreIllegalPoseFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getIgnoreIllegalPoseFlag(swigCPtr);
  }

  public boolean getAdjustNumSamplesFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getAdjustNumSamplesFlag(swigCPtr);
  }

  public int getMinNumSamples() {
    return ArnlJavaJNI.ArLocalizationTask_getMinNumSamples(swigCPtr);
  }

  public double getNumSamplesAngleFactor() {
    return ArnlJavaJNI.ArLocalizationTask_getNumSamplesAngleFactor(swigCPtr);
  }

  public boolean getSensorSetFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getSensorSetFlag(swigCPtr);
  }

  public boolean getEnableReflectorLocalizationFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getEnableReflectorLocalizationFlag(swigCPtr);
  }

  public double getReflectorVar() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorVar(swigCPtr);
  }

  public double getReflectorMatchDist() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorMatchDist(swigCPtr);
  }

  public double getReflectorMatchAngle() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorMatchAngle(swigCPtr);
  }

  public double getReflectorMaxRange() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorMaxRange(swigCPtr);
  }

  public double getReflectorMaxAngle() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorMaxAngle(swigCPtr);
  }

  public double getReflectorSize() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorSize(swigCPtr);
  }

  public int getReflectanceThreshold() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectanceThreshold(swigCPtr);
  }

  public boolean getBypassMCLFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getBypassMCLFlag(swigCPtr);
  }

  public double getReflectorTriDistLimit() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorTriDistLimit(swigCPtr);
  }

  public double getReflectorTriAngLimit() {
    return ArnlJavaJNI.ArLocalizationTask_getReflectorTriAngLimit(swigCPtr);
  }

  public double getBadReflectorFactor() {
    return ArnlJavaJNI.ArLocalizationTask_getBadReflectorFactor(swigCPtr);
  }

  public SWIGTYPE_p_ArMatrix getQParams() {
    return new SWIGTYPE_p_ArMatrix(ArnlJavaJNI.ArLocalizationTask_getQParams(swigCPtr), true);
  }

  public ArBaseLocalizationTask.LocalizationState getState() {
    return ArBaseLocalizationTask.LocalizationState.swigToEnum(ArnlJavaJNI.ArLocalizationTask_getState(swigCPtr));
  }

  public boolean getIdleFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getIdleFlag(swigCPtr);
  }

  public boolean getReloadingMapFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getReloadingMapFlag(swigCPtr);
  }

  public ArMapInterface readMapFromFile(String mapName) {
    long cPtr = ArnlJavaJNI.ArLocalizationTask_readMapFromFile(swigCPtr, mapName);
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public ArMapInterface readAriaMap(ArMapInterface ariaMap) {
    long cPtr = ArnlJavaJNI.ArLocalizationTask_readAriaMap(swigCPtr, ArMapInterface.getCPtr(ariaMap));
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public boolean loadParamFile(String file) {
    return ArnlJavaJNI.ArLocalizationTask_loadParamFile(swigCPtr, file);
  }

  public boolean saveParams(String filename) {
    return ArnlJavaJNI.ArLocalizationTask_saveParams(swigCPtr, filename);
  }

  public boolean fillHistogram(SWIGTYPE_p_double hist, SWIGTYPE_p_double cumSum, SWIGTYPE_p_int numSamples) {
    return ArnlJavaJNI.ArLocalizationTask_fillHistogram(swigCPtr, SWIGTYPE_p_double.getCPtr(hist), SWIGTYPE_p_double.getCPtr(cumSum), SWIGTYPE_p_int.getCPtr(numSamples));
  }

  public boolean scanToGlobalCoords(ArPose robPose, SWIGTYPE_p_std__vectorTArPose_t xyLrf) {
    return ArnlJavaJNI.ArLocalizationTask_scanToGlobalCoords(swigCPtr, ArPose.getCPtr(robPose), SWIGTYPE_p_std__vectorTArPose_t.getCPtr(xyLrf));
  }

  public ArTime getLastLocaTime() {
    return new ArTime(ArnlJavaJNI.ArLocalizationTask_getLastLocaTime(swigCPtr), true);
  }

  public boolean setLocaParams(double xStd, double yStd, double tStd, double kMmPerMm, double kDegPerDeg, double kDegPerMm, double sensorBelief) {
    return ArnlJavaJNI.ArLocalizationTask_setLocaParams(swigCPtr, xStd, yStd, tStd, kMmPerMm, kDegPerDeg, kDegPerMm, sensorBelief);
  }

  public void setIgnoreIllegalPoseFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setIgnoreIllegalPoseFlag(swigCPtr, f);
  }

  public void setAdjustNumSamplesFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setAdjustNumSamplesFlag(swigCPtr, f);
  }

  public void setMinNumSamples(int n) {
    ArnlJavaJNI.ArLocalizationTask_setMinNumSamples(swigCPtr, n);
  }

  public void setNumSamplesAngleFactor(double f) {
    ArnlJavaJNI.ArLocalizationTask_setNumSamplesAngleFactor(swigCPtr, f);
  }

  public void setLastLocaTimeToNow() {
    ArnlJavaJNI.ArLocalizationTask_setLastLocaTimeToNow(swigCPtr);
  }

  public void setSensorSetFlag(boolean p) {
    ArnlJavaJNI.ArLocalizationTask_setSensorSetFlag(swigCPtr, p);
  }

  public boolean computeLastLocaMeanVar(ArPose mean, SWIGTYPE_p_ArMatrix Var) {
    return ArnlJavaJNI.ArLocalizationTask_computeLastLocaMeanVar(swigCPtr, ArPose.getCPtr(mean), SWIGTYPE_p_ArMatrix.getCPtr(Var));
  }

  public boolean findMCLMeanVar(ArPose mean, SWIGTYPE_p_ArMatrix Var) {
    return ArnlJavaJNI.ArLocalizationTask_findMCLMeanVar(swigCPtr, ArPose.getCPtr(mean), SWIGTYPE_p_ArMatrix.getCPtr(Var));
  }

  public boolean findLocalizationMeanVar(ArPose mean, SWIGTYPE_p_ArMatrix Var) {
    return ArnlJavaJNI.ArLocalizationTask_findLocalizationMeanVar(swigCPtr, ArPose.getCPtr(mean), SWIGTYPE_p_ArMatrix.getCPtr(Var));
  }

  public void setCorrectRobotFlag(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setCorrectRobotFlag(swigCPtr, f);
  }

  public void setRobotPose(ArPose pose, ArPose spread, int nSam) {
    ArnlJavaJNI.ArLocalizationTask_setRobotPose__SWIG_0(swigCPtr, ArPose.getCPtr(pose), ArPose.getCPtr(spread), nSam);
  }

  public void setRobotPose(ArPose pose, ArPose spread) {
    ArnlJavaJNI.ArLocalizationTask_setRobotPose__SWIG_1(swigCPtr, ArPose.getCPtr(pose), ArPose.getCPtr(spread));
  }

  public void setRobotPose(ArPose pose) {
    ArnlJavaJNI.ArLocalizationTask_setRobotPose__SWIG_2(swigCPtr, ArPose.getCPtr(pose));
  }

  public boolean getRobotIsLostFlag() {
    return ArnlJavaJNI.ArLocalizationTask_getRobotIsLostFlag(swigCPtr);
  }

  public void setLocalizationIdle(boolean f) {
    ArnlJavaJNI.ArLocalizationTask_setLocalizationIdle(swigCPtr, f);
  }

  public ArTransform getEncoderToLocalizationTransform() {
    return new ArTransform(ArnlJavaJNI.ArLocalizationTask_getEncoderToLocalizationTransform(swigCPtr), true);
  }

  public void drawRangePoints(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawRangePoints(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawReflectorRays(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawReflectorRays(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawSamplePoses(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawSamplePoses(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawSampleBounds(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawSampleBounds(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawKalmanVariance(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawKalmanVariance(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawMCLVariance(ArServerClient client, ArNetPacket packet) {
    ArnlJavaJNI.ArLocalizationTask_drawMCLVariance(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public int getPoseInterpPosition(ArTime timeStamp, ArPose position) {
    return ArnlJavaJNI.ArLocalizationTask_getPoseInterpPosition(swigCPtr, ArTime.getCPtr(timeStamp), ArPose.getCPtr(position));
  }

  public void setMultiRobotCallback(SWIGTYPE_p_ArRetFunctorTstd__listTArMultiRobotPoseAndRadius_t_t func) {
    ArnlJavaJNI.ArLocalizationTask_setMultiRobotCallback(swigCPtr, SWIGTYPE_p_ArRetFunctorTstd__listTArMultiRobotPoseAndRadius_t_t.getCPtr(func));
  }

}
