"""
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

"""
# This file was created automatically by SWIG 1.3.29.
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.

"""
Python wrapper library for ARNL
"""

import _ArnlPy
import new
new_instancemethod = new.instancemethod
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


try:
    import weakref
    weakref_proxy = weakref.proxy
except:
    weakref_proxy = lambda x: x


ARNL = _ArnlPy.ARNL
class PySwigIterator(_object):
    """Proxy of C++ PySwigIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PySwigIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PySwigIterator, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _ArnlPy.delete_PySwigIterator
    __del__ = lambda self : None;
    def value(*args):
        """value(self) -> PyObject"""
        return _ArnlPy.PySwigIterator_value(*args)

    def incr(*args):
        """
        incr(self, size_t n=1) -> PySwigIterator
        incr(self) -> PySwigIterator
        """
        return _ArnlPy.PySwigIterator_incr(*args)

    def decr(*args):
        """
        decr(self, size_t n=1) -> PySwigIterator
        decr(self) -> PySwigIterator
        """
        return _ArnlPy.PySwigIterator_decr(*args)

    def distance(*args):
        """distance(self, PySwigIterator x) -> ptrdiff_t"""
        return _ArnlPy.PySwigIterator_distance(*args)

    def equal(*args):
        """equal(self, PySwigIterator x) -> bool"""
        return _ArnlPy.PySwigIterator_equal(*args)

    def copy(*args):
        """copy(self) -> PySwigIterator"""
        return _ArnlPy.PySwigIterator_copy(*args)

    def next(*args):
        """next(self) -> PyObject"""
        return _ArnlPy.PySwigIterator_next(*args)

    def previous(*args):
        """previous(self) -> PyObject"""
        return _ArnlPy.PySwigIterator_previous(*args)

    def advance(*args):
        """advance(self, ptrdiff_t n) -> PySwigIterator"""
        return _ArnlPy.PySwigIterator_advance(*args)

    def __eq__(*args):
        """__eq__(self, PySwigIterator x) -> bool"""
        return _ArnlPy.PySwigIterator___eq__(*args)

    def __ne__(*args):
        """__ne__(self, PySwigIterator x) -> bool"""
        return _ArnlPy.PySwigIterator___ne__(*args)

    def __iadd__(*args):
        """__iadd__(self, ptrdiff_t n) -> PySwigIterator"""
        return _ArnlPy.PySwigIterator___iadd__(*args)

    def __isub__(*args):
        """__isub__(self, ptrdiff_t n) -> PySwigIterator"""
        return _ArnlPy.PySwigIterator___isub__(*args)

    def __add__(*args):
        """__add__(self, ptrdiff_t n) -> PySwigIterator"""
        return _ArnlPy.PySwigIterator___add__(*args)

    def __sub__(*args):
        """
        __sub__(self, ptrdiff_t n) -> PySwigIterator
        __sub__(self, PySwigIterator x) -> ptrdiff_t
        """
        return _ArnlPy.PySwigIterator___sub__(*args)

    def __iter__(self): return self
PySwigIterator_swigregister = _ArnlPy.PySwigIterator_swigregister
PySwigIterator_swigregister(PySwigIterator)

import AriaPy
SWIG_IMPORTED_ARIA = _ArnlPy.SWIG_IMPORTED_ARIA
import ArNetworkingPy
SWIG_IMPORTED_ARNETWORKING = _ArnlPy.SWIG_IMPORTED_ARNETWORKING
import BaseArnlPy
SWIG_IMPORTED_ARNL_BASE = _ArnlPy.SWIG_IMPORTED_ARNL_BASE
class ArLocalizationTask(BaseArnlPy.ArBaseLocalizationTask):
    """Proxy of C++ ArLocalizationTask class"""
    __swig_setmethods__ = {}
    for _s in [BaseArnlPy.ArBaseLocalizationTask]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArLocalizationTask, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseArnlPy.ArBaseLocalizationTask]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArLocalizationTask, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArRobot robot, ArRangeDevice laser, char mapName) -> ArLocalizationTask
        __init__(self, ArRobot robot, ArRangeDevice laser, ArMapInterface ariaMap, 
            bool noReflectors=False) -> ArLocalizationTask
        __init__(self, ArRobot robot, ArRangeDevice laser, ArMapInterface ariaMap) -> ArLocalizationTask
        """
        this = _ArnlPy.new_ArLocalizationTask(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _ArnlPy.delete_ArLocalizationTask
    __del__ = lambda self : None;
    def localizeRobotInMapInit(*args):
        """
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor, bool warn=True, 
            bool setInitializedToFalse=True, bool rayTrace=True) -> bool
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor, bool warn=True, 
            bool setInitializedToFalse=True) -> bool
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor, bool warn=True) -> bool
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor) -> bool
        """
        return _ArnlPy.ArLocalizationTask_localizeRobotInMapInit(*args)

    def localizeRobotInMapMoved(*args):
        """
        localizeRobotInMapMoved(self, int numSamples, double distFactor, double angFactor, 
            double thresFactor) -> bool
        """
        return _ArnlPy.ArLocalizationTask_localizeRobotInMapMoved(*args)

    def localizeRobotAtHomeBlocking(*args):
        """
        localizeRobotAtHomeBlocking(self, double distSpread, double angleSpread, double probThreshold) -> bool
        localizeRobotAtHomeBlocking(self, double spreadX, double spreadY, double angleSpread, 
            double probThreshold) -> bool
        localizeRobotAtHomeBlocking(self, double distSpread, double angleSpread) -> bool
        localizeRobotAtHomeBlocking(self) -> bool
        """
        return _ArnlPy.ArLocalizationTask_localizeRobotAtHomeBlocking(*args)

    def localizeRobotAtHomeNonBlocking(*args):
        """localizeRobotAtHomeNonBlocking(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_localizeRobotAtHomeNonBlocking(*args)

    def getRobotHome(*args):
        """getRobotHome(self) -> ArPose"""
        return _ArnlPy.ArLocalizationTask_getRobotHome(*args)

    def setForceUpdateParams(*args):
        """setForceUpdateParams(self, int numSamples, double xStd, double yStd, double tStd)"""
        return _ArnlPy.ArLocalizationTask_setForceUpdateParams(*args)

    def forceUpdatePose(*args):
        """
        forceUpdatePose(self, ArPose forcePose, bool rayTrace=True)
        forceUpdatePose(self, ArPose forcePose)
        """
        return _ArnlPy.ArLocalizationTask_forceUpdatePose(*args)

    def addFailedLocalizationCB(*args):
        """addFailedLocalizationCB(self, ArFunctor1_Int functor)"""
        return _ArnlPy.ArLocalizationTask_addFailedLocalizationCB(*args)

    def remFailedLocalizationCB(*args):
        """remFailedLocalizationCB(self, ArFunctor1_Int functor)"""
        return _ArnlPy.ArLocalizationTask_remFailedLocalizationCB(*args)

    def setGridResolution(*args):
        """setGridResolution(self, double res, ArMapInterface ariaMap) -> bool"""
        return _ArnlPy.ArLocalizationTask_setGridResolution(*args)

    def setFailedCallBack(*args):
        """setFailedCallBack(self, ArFunctor1_Int fcb)"""
        return _ArnlPy.ArLocalizationTask_setFailedCallBack(*args)

    def setTriggerDelR(*args):
        """setTriggerDelR(self, double tr)"""
        return _ArnlPy.ArLocalizationTask_setTriggerDelR(*args)

    def setTriggerDelT(*args):
        """setTriggerDelT(self, double tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerDelT(*args)

    def setTriggerTimeFlag(*args):
        """setTriggerTimeFlag(self, bool tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerTimeFlag(*args)

    def setTriggerTime(*args):
        """setTriggerTime(self, double tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerTime(*args)

    def setTriggerTimeX(*args):
        """setTriggerTimeX(self, double tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerTimeX(*args)

    def setTriggerTimeY(*args):
        """setTriggerTimeY(self, double tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerTimeY(*args)

    def setTriggerTimeTh(*args):
        """setTriggerTimeTh(self, double tt)"""
        return _ArnlPy.ArLocalizationTask_setTriggerTimeTh(*args)

    def setNumSamples(*args):
        """setNumSamples(self, int n)"""
        return _ArnlPy.ArLocalizationTask_setNumSamples(*args)

    def setNumSamplesAtInit(*args):
        """setNumSamplesAtInit(self, int n)"""
        return _ArnlPy.ArLocalizationTask_setNumSamplesAtInit(*args)

    def setRayTraceAtInit(*args):
        """setRayTraceAtInit(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setRayTraceAtInit(*args)

    def setCurrentNumSamples(*args):
        """setCurrentNumSamples(self, int n)"""
        return _ArnlPy.ArLocalizationTask_setCurrentNumSamples(*args)

    def setPassThreshold(*args):
        """setPassThreshold(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setPassThreshold(*args)

    def setSensorBelief(*args):
        """setSensorBelief(self, double sensorBelief)"""
        return _ArnlPy.ArLocalizationTask_setSensorBelief(*args)

    def setCurrentLocaPose(*args):
        """
        setCurrentLocaPose(self, double x, double y, double th)
        setCurrentLocaPose(self, ArPose p)
        """
        return _ArnlPy.ArLocalizationTask_setCurrentLocaPose(*args)

    def setVerboseFlag(*args):
        """setVerboseFlag(self, bool a)"""
        return _ArnlPy.ArLocalizationTask_setVerboseFlag(*args)

    def setAngleIncrement(*args):
        """setAngleIncrement(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setAngleIncrement(*args)

    def setKillThreshold(*args):
        """setKillThreshold(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setKillThreshold(*args)

    def setRecoverOnFailedFlag(*args):
        """setRecoverOnFailedFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setRecoverOnFailedFlag(*args)

    def setIdleFlag(*args):
        """setIdleFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setIdleFlag(*args)

    def setReloadingMapFlag(*args):
        """setReloadingMapFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setReloadingMapFlag(*args)

    def setEnableReflectorLocalizationFlag(*args):
        """setEnableReflectorLocalizationFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setEnableReflectorLocalizationFlag(*args)

    def setReflectorVar(*args):
        """setReflectorVar(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorVar(*args)

    def setReflectorMatchDist(*args):
        """setReflectorMatchDist(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorMatchDist(*args)

    def setReflectorMatchAngle(*args):
        """setReflectorMatchAngle(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorMatchAngle(*args)

    def setReflectorMaxRange(*args):
        """setReflectorMaxRange(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorMaxRange(*args)

    def setReflectorMaxAngle(*args):
        """setReflectorMaxAngle(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorMaxAngle(*args)

    def setReflectorSize(*args):
        """setReflectorSize(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setReflectorSize(*args)

    def setReflectanceThreshold(*args):
        """setReflectanceThreshold(self, int f)"""
        return _ArnlPy.ArLocalizationTask_setReflectanceThreshold(*args)

    def setBypassMCLFlag(*args):
        """setBypassMCLFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setBypassMCLFlag(*args)

    def getForceUpdateParams(*args):
        """
        getForceUpdateParams(self, ArPose forcePose, int numSamples, double xStd, double yStd, 
            double tStd)
        """
        return _ArnlPy.ArLocalizationTask_getForceUpdateParams(*args)

    def getVerboseFlag(*args):
        """getVerboseFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getVerboseFlag(*args)

    def getInitializedFlag(*args):
        """getInitializedFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getInitializedFlag(*args)

    def getNumSamples(*args):
        """getNumSamples(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getNumSamples(*args)

    def getNumSamplesAtInit(*args):
        """getNumSamplesAtInit(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getNumSamplesAtInit(*args)

    def getRayTraceAtInit(*args):
        """getRayTraceAtInit(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getRayTraceAtInit(*args)

    def getCurrentNumSamples(*args):
        """getCurrentNumSamples(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getCurrentNumSamples(*args)

    def getRobotMaxProbPose(*args):
        """getRobotMaxProbPose(self) -> ArPose"""
        return _ArnlPy.ArLocalizationTask_getRobotMaxProbPose(*args)

    def getTriggerDelR(*args):
        """getTriggerDelR(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerDelR(*args)

    def getTriggerDelT(*args):
        """getTriggerDelT(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerDelT(*args)

    def getTriggerTimeFlag(*args):
        """getTriggerTimeFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getTriggerTimeFlag(*args)

    def getTriggerTime(*args):
        """getTriggerTime(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerTime(*args)

    def getTriggerTimeX(*args):
        """getTriggerTimeX(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerTimeX(*args)

    def getTriggerTimeY(*args):
        """getTriggerTimeY(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerTimeY(*args)

    def getTriggerTimeTh(*args):
        """getTriggerTimeTh(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTriggerTimeTh(*args)

    def getPassThreshold(*args):
        """getPassThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPassThreshold(*args)

    def getUsingPassThreshold(*args):
        """getUsingPassThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getUsingPassThreshold(*args)

    def setTempPassThreshold(*args):
        """setTempPassThreshold(self, double passThreshold)"""
        return _ArnlPy.ArLocalizationTask_setTempPassThreshold(*args)

    def getTempPassThreshold(*args):
        """getTempPassThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getTempPassThreshold(*args)

    def clearTempPassThreshold(*args):
        """clearTempPassThreshold(self)"""
        return _ArnlPy.ArLocalizationTask_clearTempPassThreshold(*args)

    def getLocalizationScore(*args):
        """getLocalizationScore(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getLocalizationScore(*args)

    def getLocalizationThreshold(*args):
        """getLocalizationThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getLocalizationThreshold(*args)

    def getMCLocalizationScore(*args):
        """getMCLocalizationScore(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getMCLocalizationScore(*args)

    def getRefLocalizationScore(*args):
        """getRefLocalizationScore(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getRefLocalizationScore(*args)

    def getCurrentLocaPose(*args):
        """getCurrentLocaPose(self) -> ArPose"""
        return _ArnlPy.ArLocalizationTask_getCurrentLocaPose(*args)

    def getStdX(*args):
        """getStdX(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getStdX(*args)

    def getStdY(*args):
        """getStdY(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getStdY(*args)

    def getStdTh(*args):
        """getStdTh(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getStdTh(*args)

    def getErrorMmPerMm(*args):
        """getErrorMmPerMm(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getErrorMmPerMm(*args)

    def getErrorDegPerDeg(*args):
        """getErrorDegPerDeg(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getErrorDegPerDeg(*args)

    def getErrorDegPerMm(*args):
        """getErrorDegPerMm(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getErrorDegPerMm(*args)

    def getSensorBelief(*args):
        """
        getSensorBelief(self) -> double
        getSensorBelief(self) -> double
        """
        return _ArnlPy.ArLocalizationTask_getSensorBelief(*args)

    def getPeakFactor(*args):
        """getPeakFactor(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeakFactor(*args)

    def getOccThreshold(*args):
        """getOccThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getOccThreshold(*args)

    def getGridRes(*args):
        """getGridRes(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getGridRes(*args)

    def getMapName(*args):
        """getMapName(self) -> char"""
        return _ArnlPy.ArLocalizationTask_getMapName(*args)

    def getPeturbRangeX(*args):
        """getPeturbRangeX(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeturbRangeX(*args)

    def getPeturbRangeY(*args):
        """getPeturbRangeY(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeturbRangeY(*args)

    def getPeturbRangeTh(*args):
        """getPeturbRangeTh(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeturbRangeTh(*args)

    def getFailedRangeX(*args):
        """getFailedRangeX(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getFailedRangeX(*args)

    def getFailedRangeY(*args):
        """getFailedRangeY(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getFailedRangeY(*args)

    def getFailedRangeTh(*args):
        """getFailedRangeTh(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getFailedRangeTh(*args)

    def getPeakStdX(*args):
        """getPeakStdX(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeakStdX(*args)

    def getPeakStdY(*args):
        """getPeakStdY(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeakStdY(*args)

    def getPeakStdTh(*args):
        """getPeakStdTh(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getPeakStdTh(*args)

    def getAngleIncrement(*args):
        """getAngleIncrement(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getAngleIncrement(*args)

    def getKillThreshold(*args):
        """getKillThreshold(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getKillThreshold(*args)

    def getAriaMap(*args):
        """getAriaMap(self) -> ArMapInterface"""
        return _ArnlPy.ArLocalizationTask_getAriaMap(*args)

    def getBufferSize(*args):
        """getBufferSize(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getBufferSize(*args)

    def getXYBuffer(*args):
        """getXYBuffer(self) -> std::vector<(ArPose,std::allocator<(ArPose)>)>"""
        return _ArnlPy.ArLocalizationTask_getXYBuffer(*args)

    def getBufferPose(*args):
        """getBufferPose(self) -> ArPose"""
        return _ArnlPy.ArLocalizationTask_getBufferPose(*args)

    def getOccGridPtr(*args):
        """getOccGridPtr(self) -> ArOccGrid"""
        return _ArnlPy.ArLocalizationTask_getOccGridPtr(*args)

    def getCurrentSamplePoses(*args):
        """getCurrentSamplePoses(self) -> ArPoseList"""
        return _ArnlPy.ArLocalizationTask_getCurrentSamplePoses(*args)

    def getRecoverOnFailedFlag(*args):
        """getRecoverOnFailedFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getRecoverOnFailedFlag(*args)

    def getIgnoreIllegalPoseFlag(*args):
        """getIgnoreIllegalPoseFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getIgnoreIllegalPoseFlag(*args)

    def getAdjustNumSamplesFlag(*args):
        """getAdjustNumSamplesFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getAdjustNumSamplesFlag(*args)

    def getMinNumSamples(*args):
        """getMinNumSamples(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getMinNumSamples(*args)

    def getNumSamplesAngleFactor(*args):
        """getNumSamplesAngleFactor(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getNumSamplesAngleFactor(*args)

    def getSensorSetFlag(*args):
        """getSensorSetFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getSensorSetFlag(*args)

    def getEnableReflectorLocalizationFlag(*args):
        """getEnableReflectorLocalizationFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getEnableReflectorLocalizationFlag(*args)

    def getReflectorVar(*args):
        """getReflectorVar(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorVar(*args)

    def getReflectorMatchDist(*args):
        """getReflectorMatchDist(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorMatchDist(*args)

    def getReflectorMatchAngle(*args):
        """getReflectorMatchAngle(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorMatchAngle(*args)

    def getReflectorMaxRange(*args):
        """getReflectorMaxRange(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorMaxRange(*args)

    def getReflectorMaxAngle(*args):
        """getReflectorMaxAngle(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorMaxAngle(*args)

    def getReflectorSize(*args):
        """getReflectorSize(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorSize(*args)

    def getReflectanceThreshold(*args):
        """getReflectanceThreshold(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getReflectanceThreshold(*args)

    def getBypassMCLFlag(*args):
        """getBypassMCLFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getBypassMCLFlag(*args)

    def getReflectorTriDistLimit(*args):
        """getReflectorTriDistLimit(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorTriDistLimit(*args)

    def getReflectorTriAngLimit(*args):
        """getReflectorTriAngLimit(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getReflectorTriAngLimit(*args)

    def getBadReflectorFactor(*args):
        """getBadReflectorFactor(self) -> double"""
        return _ArnlPy.ArLocalizationTask_getBadReflectorFactor(*args)

    def getQParams(*args):
        """getQParams(self) -> ArMatrix"""
        return _ArnlPy.ArLocalizationTask_getQParams(*args)

    def getState(*args):
        """getState(self) -> int"""
        return _ArnlPy.ArLocalizationTask_getState(*args)

    def getIdleFlag(*args):
        """getIdleFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getIdleFlag(*args)

    def getReloadingMapFlag(*args):
        """getReloadingMapFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getReloadingMapFlag(*args)

    def readMapFromFile(*args):
        """readMapFromFile(self, char mapName) -> ArMapInterface"""
        return _ArnlPy.ArLocalizationTask_readMapFromFile(*args)

    def readAriaMap(*args):
        """readAriaMap(self, ArMapInterface ariaMap) -> ArMapInterface"""
        return _ArnlPy.ArLocalizationTask_readAriaMap(*args)

    def loadParamFile(*args):
        """loadParamFile(self, char file) -> bool"""
        return _ArnlPy.ArLocalizationTask_loadParamFile(*args)

    def saveParams(*args):
        """saveParams(self, char filename) -> bool"""
        return _ArnlPy.ArLocalizationTask_saveParams(*args)

    def fillHistogram(*args):
        """fillHistogram(self, double hist, double cumSum, int numSamples) -> bool"""
        return _ArnlPy.ArLocalizationTask_fillHistogram(*args)

    def scanToGlobalCoords(*args):
        """scanToGlobalCoords(self, ArPose robPose, std::vector<(ArPose,std::allocator<(ArPose)>)> xyLrf) -> bool"""
        return _ArnlPy.ArLocalizationTask_scanToGlobalCoords(*args)

    def getLastLocaTime(*args):
        """getLastLocaTime(self) -> ArTime"""
        return _ArnlPy.ArLocalizationTask_getLastLocaTime(*args)

    def setLocaParams(*args):
        """
        setLocaParams(self, double xStd, double yStd, double tStd, double kMmPerMm, 
            double kDegPerDeg, double kDegPerMm, double sensorBelief) -> bool
        """
        return _ArnlPy.ArLocalizationTask_setLocaParams(*args)

    def setIgnoreIllegalPoseFlag(*args):
        """setIgnoreIllegalPoseFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setIgnoreIllegalPoseFlag(*args)

    def setAdjustNumSamplesFlag(*args):
        """setAdjustNumSamplesFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setAdjustNumSamplesFlag(*args)

    def setMinNumSamples(*args):
        """setMinNumSamples(self, int n)"""
        return _ArnlPy.ArLocalizationTask_setMinNumSamples(*args)

    def setNumSamplesAngleFactor(*args):
        """setNumSamplesAngleFactor(self, double f)"""
        return _ArnlPy.ArLocalizationTask_setNumSamplesAngleFactor(*args)

    def setLastLocaTimeToNow(*args):
        """setLastLocaTimeToNow(self)"""
        return _ArnlPy.ArLocalizationTask_setLastLocaTimeToNow(*args)

    def setSensorSetFlag(*args):
        """setSensorSetFlag(self, bool p)"""
        return _ArnlPy.ArLocalizationTask_setSensorSetFlag(*args)

    def computeLastLocaMeanVar(*args):
        """computeLastLocaMeanVar(self, ArPose mean, ArMatrix Var) -> bool"""
        return _ArnlPy.ArLocalizationTask_computeLastLocaMeanVar(*args)

    def findMCLMeanVar(*args):
        """findMCLMeanVar(self, ArPose mean, ArMatrix Var) -> bool"""
        return _ArnlPy.ArLocalizationTask_findMCLMeanVar(*args)

    def findLocalizationMeanVar(*args):
        """findLocalizationMeanVar(self, ArPose mean, ArMatrix Var) -> bool"""
        return _ArnlPy.ArLocalizationTask_findLocalizationMeanVar(*args)

    def setCorrectRobotFlag(*args):
        """setCorrectRobotFlag(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setCorrectRobotFlag(*args)

    def setRobotPose(*args):
        """
        setRobotPose(self, ArPose pose, ArPose spread=ArPose(0, 0, 0), int nSam=0)
        setRobotPose(self, ArPose pose, ArPose spread=ArPose(0, 0, 0))
        setRobotPose(self, ArPose pose)
        """
        return _ArnlPy.ArLocalizationTask_setRobotPose(*args)

    def getRobotIsLostFlag(*args):
        """getRobotIsLostFlag(self) -> bool"""
        return _ArnlPy.ArLocalizationTask_getRobotIsLostFlag(*args)

    def setLocalizationIdle(*args):
        """setLocalizationIdle(self, bool f)"""
        return _ArnlPy.ArLocalizationTask_setLocalizationIdle(*args)

    def getEncoderToLocalizationTransform(*args):
        """getEncoderToLocalizationTransform(self) -> ArTransform"""
        return _ArnlPy.ArLocalizationTask_getEncoderToLocalizationTransform(*args)

    def drawRangePoints(*args):
        """drawRangePoints(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawRangePoints(*args)

    def drawReflectorRays(*args):
        """drawReflectorRays(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawReflectorRays(*args)

    def drawSamplePoses(*args):
        """drawSamplePoses(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawSamplePoses(*args)

    def drawSampleBounds(*args):
        """drawSampleBounds(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawSampleBounds(*args)

    def drawKalmanVariance(*args):
        """drawKalmanVariance(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawKalmanVariance(*args)

    def drawMCLVariance(*args):
        """drawMCLVariance(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArLocalizationTask_drawMCLVariance(*args)

    def getPoseInterpPosition(*args):
        """getPoseInterpPosition(self, ArTime timeStamp, ArPose position) -> int"""
        return _ArnlPy.ArLocalizationTask_getPoseInterpPosition(*args)

    def setMultiRobotCallback(*args):
        """setMultiRobotCallback(self, ArRetFunctor<(std::list<(ArMultiRobotPoseAndRadius,std::allocator<(ArMultiRobotPoseAndRadius)>)>)> func)"""
        return _ArnlPy.ArLocalizationTask_setMultiRobotCallback(*args)

ArLocalizationTask_swigregister = _ArnlPy.ArLocalizationTask_swigregister
ArLocalizationTask_swigregister(ArLocalizationTask)

class ArDockInterface(_object):
    """Proxy of C++ ArDockInterface class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArDockInterface, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ArDockInterface, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    UNDOCKED = _ArnlPy.ArDockInterface_UNDOCKED
    DOCKING = _ArnlPy.ArDockInterface_DOCKING
    DOCKED = _ArnlPy.ArDockInterface_DOCKED
    UNDOCKING = _ArnlPy.ArDockInterface_UNDOCKING
    def toString(*args):
        """toString(State s) -> char"""
        return _ArnlPy.ArDockInterface_toString(*args)

    if _newclass:toString = staticmethod(toString)
    __swig_getmethods__["toString"] = lambda x: toString
    __swig_destroy__ = _ArnlPy.delete_ArDockInterface
    __del__ = lambda self : None;
    def getState(*args):
        """getState(self) -> int"""
        return _ArnlPy.ArDockInterface_getState(*args)

    def getForcedDock(*args):
        """getForcedDock(self) -> bool"""
        return _ArnlPy.ArDockInterface_getForcedDock(*args)

ArDockInterface_swigregister = _ArnlPy.ArDockInterface_swigregister
ArDockInterface_swigregister(ArDockInterface)

def ArDockInterface_toString(*args):
  """ArDockInterface_toString(State s) -> char"""
  return _ArnlPy.ArDockInterface_toString(*args)

class ArServerModeDock(ArNetworkingPy.ArServerMode,ArDockInterface):
    """Proxy of C++ ArServerModeDock class"""
    __swig_setmethods__ = {}
    for _s in [ArNetworkingPy.ArServerMode,ArDockInterface]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDock, name, value)
    __swig_getmethods__ = {}
    for _s in [ArNetworkingPy.ArServerMode,ArDockInterface]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDock, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDock
    __del__ = lambda self : None;
    def createDock(*args):
        """
        createDock(ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            ArFunctor shutdownFunctor=None) -> ArServerModeDock
        createDock(ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask) -> ArServerModeDock
        """
        return _ArnlPy.ArServerModeDock_createDock(*args)

    if _newclass:createDock = staticmethod(createDock)
    __swig_getmethods__["createDock"] = lambda x: createDock
    def getState(*args):
        """getState(self) -> int"""
        return _ArnlPy.ArServerModeDock_getState(*args)

    def dock(*args):
        """dock(self)"""
        return _ArnlPy.ArServerModeDock_dock(*args)

    def undock(*args):
        """undock(self)"""
        return _ArnlPy.ArServerModeDock_undock(*args)

    def checkDock(*args):
        """checkDock(self)"""
        return _ArnlPy.ArServerModeDock_checkDock(*args)

    def activateAsDocked(*args):
        """activateAsDocked(self)"""
        return _ArnlPy.ArServerModeDock_activateAsDocked(*args)

    def checkDefault(*args):
        """checkDefault(self)"""
        return _ArnlPy.ArServerModeDock_checkDefault(*args)

    def activate(*args):
        """activate(self)"""
        return _ArnlPy.ArServerModeDock_activate(*args)

    def deactivate(*args):
        """deactivate(self)"""
        return _ArnlPy.ArServerModeDock_deactivate(*args)

    def requestUnlock(*args):
        """requestUnlock(self)"""
        return _ArnlPy.ArServerModeDock_requestUnlock(*args)

    def getForcedDock(*args):
        """getForcedDock(self) -> bool"""
        return _ArnlPy.ArServerModeDock_getForcedDock(*args)

    def requestForcedDock(*args):
        """requestForcedDock(self)"""
        return _ArnlPy.ArServerModeDock_requestForcedDock(*args)

    def forceUnlock(*args):
        """forceUnlock(self)"""
        return _ArnlPy.ArServerModeDock_forceUnlock(*args)

    def getDockName(*args):
        """getDockName(self) -> char"""
        return _ArnlPy.ArServerModeDock_getDockName(*args)

    def setDockingVoltage(*args):
        """setDockingVoltage(self, double dockingVoltage)"""
        return _ArnlPy.ArServerModeDock_setDockingVoltage(*args)

    def getDockingVoltage(*args):
        """getDockingVoltage(self) -> double"""
        return _ArnlPy.ArServerModeDock_getDockingVoltage(*args)

    def setDoneChargingVoltage(*args):
        """setDoneChargingVoltage(self, double doneChargingVoltage)"""
        return _ArnlPy.ArServerModeDock_setDoneChargingVoltage(*args)

    def getDoneChargingVoltage(*args):
        """getDoneChargingVoltage(self) -> double"""
        return _ArnlPy.ArServerModeDock_getDoneChargingVoltage(*args)

    def setDoneChargingMinutes(*args):
        """setDoneChargingMinutes(self, int doneChargingMinutes)"""
        return _ArnlPy.ArServerModeDock_setDoneChargingMinutes(*args)

    def getDoneChargingMinutes(*args):
        """getDoneChargingMinutes(self) -> int"""
        return _ArnlPy.ArServerModeDock_getDoneChargingMinutes(*args)

    def getUseChargeState(*args):
        """getUseChargeState(self) -> bool"""
        return _ArnlPy.ArServerModeDock_getUseChargeState(*args)

    def setDoneChargingAtFloat(*args):
        """setDoneChargingAtFloat(self, bool doneChargingAtFloat)"""
        return _ArnlPy.ArServerModeDock_setDoneChargingAtFloat(*args)

    def getDoneChargingAtFloat(*args):
        """getDoneChargingAtFloat(self) -> bool"""
        return _ArnlPy.ArServerModeDock_getDoneChargingAtFloat(*args)

    def setMinimumMinutesBetweenAutoDock(*args):
        """setMinimumMinutesBetweenAutoDock(self, int minutesBetween)"""
        return _ArnlPy.ArServerModeDock_setMinimumMinutesBetweenAutoDock(*args)

    def getMinimumMinutesBetweenAutoDock(*args):
        """getMinimumMinutesBetweenAutoDock(self) -> int"""
        return _ArnlPy.ArServerModeDock_getMinimumMinutesBetweenAutoDock(*args)

    def setAutoDock(*args):
        """setAutoDock(self, bool autoDocking)"""
        return _ArnlPy.ArServerModeDock_setAutoDock(*args)

    def getAutoDock(*args):
        """getAutoDock(self) -> bool"""
        return _ArnlPy.ArServerModeDock_getAutoDock(*args)

    def addToConfig(*args):
        """addToConfig(self, ArConfig config)"""
        return _ArnlPy.ArServerModeDock_addToConfig(*args)

    def addControlCommands(*args):
        """addControlCommands(self, ArServerHandlerCommands handlerCommands)"""
        return _ArnlPy.ArServerModeDock_addControlCommands(*args)

    def serverDock(*args):
        """serverDock(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArServerModeDock_serverDock(*args)

    def serverUndock(*args):
        """serverUndock(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArServerModeDock_serverUndock(*args)

    def serverDockInfo(*args):
        """serverDockInfo(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArServerModeDock_serverDockInfo(*args)

    def serverGetAutoDock(*args):
        """serverGetAutoDock(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArServerModeDock_serverGetAutoDock(*args)

    def serverSetAutoDock(*args):
        """serverSetAutoDock(self, ArServerClient client, ArNetPacket packet)"""
        return _ArnlPy.ArServerModeDock_serverSetAutoDock(*args)

    def addStateChangedCB(*args):
        """
        addStateChangedCB(self, ArFunctor functor, Pos position=LAST)
        addStateChangedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addStateChangedCB(*args)

    def remStateChangedCB(*args):
        """remStateChangedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remStateChangedCB(*args)

    def getFailedGotoNum(*args):
        """getFailedGotoNum(self) -> unsigned int"""
        return _ArnlPy.ArServerModeDock_getFailedGotoNum(*args)

    def addForcedDockCB(*args):
        """
        addForcedDockCB(self, ArFunctor functor, int position=50)
        addForcedDockCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addForcedDockCB(*args)

    def remForcedDockCB(*args):
        """remForcedDockCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remForcedDockCB(*args)

    def addIdleDockCB(*args):
        """
        addIdleDockCB(self, ArFunctor functor, int position=50)
        addIdleDockCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addIdleDockCB(*args)

    def remIdleDockCB(*args):
        """remIdleDockCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remIdleDockCB(*args)

    def addRequestedDockCB(*args):
        """
        addRequestedDockCB(self, ArFunctor functor, int position=50)
        addRequestedDockCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addRequestedDockCB(*args)

    def remRequestedDockCB(*args):
        """remRequestedDockCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remRequestedDockCB(*args)

    def addDrivingToDockCB(*args):
        """
        addDrivingToDockCB(self, ArFunctor functor, int position=50)
        addDrivingToDockCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addDrivingToDockCB(*args)

    def remDrivingToDockCB(*args):
        """remDrivingToDockCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remDrivingToDockCB(*args)

    def addDrivingIntoDockCB(*args):
        """
        addDrivingIntoDockCB(self, ArFunctor functor, int position=50)
        addDrivingIntoDockCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addDrivingIntoDockCB(*args)

    def remDrivingIntoDockCB(*args):
        """remDrivingIntoDockCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remDrivingIntoDockCB(*args)

    def addDockedCB(*args):
        """
        addDockedCB(self, ArFunctor functor, int position=50)
        addDockedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addDockedCB(*args)

    def remDockedCB(*args):
        """remDockedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remDockedCB(*args)

    def addSingleShotDockedCB(*args):
        """
        addSingleShotDockedCB(self, ArFunctor functor, int position=50)
        addSingleShotDockedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addSingleShotDockedCB(*args)

    def remSingleShotDockedCB(*args):
        """remSingleShotDockedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remSingleShotDockedCB(*args)

    def addDockNowUnforcedCB(*args):
        """
        addDockNowUnforcedCB(self, ArFunctor functor, int position=50)
        addDockNowUnforcedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addDockNowUnforcedCB(*args)

    def remDockNowUnforcedCB(*args):
        """remDockNowUnforcedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remDockNowUnforcedCB(*args)

    def addDockNowForcedCB(*args):
        """
        addDockNowForcedCB(self, ArFunctor functor, int position=50)
        addDockNowForcedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addDockNowForcedCB(*args)

    def remDockNowForcedCB(*args):
        """remDockNowForcedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remDockNowForcedCB(*args)

    def addUndockingCB(*args):
        """
        addUndockingCB(self, ArFunctor functor, int position=50)
        addUndockingCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addUndockingCB(*args)

    def remUndockingCB(*args):
        """remUndockingCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remUndockingCB(*args)

    def addUndockedCB(*args):
        """
        addUndockedCB(self, ArFunctor functor, int position=50)
        addUndockedCB(self, ArFunctor functor)
        """
        return _ArnlPy.ArServerModeDock_addUndockedCB(*args)

    def remUndockedCB(*args):
        """remUndockedCB(self, ArFunctor functor)"""
        return _ArnlPy.ArServerModeDock_remUndockedCB(*args)

ArServerModeDock_swigregister = _ArnlPy.ArServerModeDock_swigregister
ArServerModeDock_swigregister(ArServerModeDock)

def ArServerModeDock_createDock(*args):
  """
    createDock(ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
        ArPathPlanningTask pathTask, 
        ArFunctor shutdownFunctor=None) -> ArServerModeDock
    ArServerModeDock_createDock(ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
        ArPathPlanningTask pathTask) -> ArServerModeDock
    """
  return _ArnlPy.ArServerModeDock_createDock(*args)

class ArServerModeDockPioneer(ArServerModeDock):
    """Proxy of C++ ArServerModeDockPioneer class"""
    __swig_setmethods__ = {}
    for _s in [ArServerModeDock]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDockPioneer, name, value)
    __swig_getmethods__ = {}
    for _s in [ArServerModeDock]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDockPioneer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            ArFunctor shutdownFunctor=None) -> ArServerModeDockPioneer
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask) -> ArServerModeDockPioneer
        """
        this = _ArnlPy.new_ArServerModeDockPioneer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDockPioneer
    __del__ = lambda self : None;
    def dock(*args):
        """dock(self)"""
        return _ArnlPy.ArServerModeDockPioneer_dock(*args)

    def undock(*args):
        """undock(self)"""
        return _ArnlPy.ArServerModeDockPioneer_undock(*args)

    def checkDock(*args):
        """checkDock(self)"""
        return _ArnlPy.ArServerModeDockPioneer_checkDock(*args)

    def forceUnlock(*args):
        """forceUnlock(self)"""
        return _ArnlPy.ArServerModeDockPioneer_forceUnlock(*args)

    def deactivate(*args):
        """deactivate(self)"""
        return _ArnlPy.ArServerModeDockPioneer_deactivate(*args)

ArServerModeDockPioneer_swigregister = _ArnlPy.ArServerModeDockPioneer_swigregister
ArServerModeDockPioneer_swigregister(ArServerModeDockPioneer)

class ArServerModeDockTriangleBump(ArServerModeDock):
    """Proxy of C++ ArServerModeDockTriangleBump class"""
    __swig_setmethods__ = {}
    for _s in [ArServerModeDock]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDockTriangleBump, name, value)
    __swig_getmethods__ = {}
    for _s in [ArServerModeDock]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDockTriangleBump, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDockTriangleBump
    __del__ = lambda self : None;
    def dock(*args):
        """dock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_dock(*args)

    def undock(*args):
        """undock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_undock(*args)

    def checkDock(*args):
        """checkDock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_checkDock(*args)

    def forceUnlock(*args):
        """forceUnlock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_forceUnlock(*args)

    def deactivate(*args):
        """deactivate(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_deactivate(*args)

    def isDocked(*args):
        """isDocked(self) -> bool"""
        return _ArnlPy.ArServerModeDockTriangleBump_isDocked(*args)

    def enableDock(*args):
        """enableDock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_enableDock(*args)

    def disableDock(*args):
        """disableDock(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_disableDock(*args)

    def beforeDriveInCallback(*args):
        """beforeDriveInCallback(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_beforeDriveInCallback(*args)

    def afterDriveOutCallback(*args):
        """afterDriveOutCallback(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_afterDriveOutCallback(*args)

    def backoutCallback(*args):
        """backoutCallback(self)"""
        return _ArnlPy.ArServerModeDockTriangleBump_backoutCallback(*args)

    def setStallsAsBumps(*args):
        """setStallsAsBumps(self, bool stallsAsBumps)"""
        return _ArnlPy.ArServerModeDockTriangleBump_setStallsAsBumps(*args)

    def getStallsAsBumps(*args):
        """getStallsAsBumps(self) -> bool"""
        return _ArnlPy.ArServerModeDockTriangleBump_getStallsAsBumps(*args)

ArServerModeDockTriangleBump_swigregister = _ArnlPy.ArServerModeDockTriangleBump_swigregister
ArServerModeDockTriangleBump_swigregister(ArServerModeDockTriangleBump)

class ArServerModeDockPatrolBot(ArServerModeDockTriangleBump):
    """Proxy of C++ ArServerModeDockPatrolBot class"""
    __swig_setmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDockPatrolBot, name, value)
    __swig_getmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDockPatrolBot, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            ArFunctor shutdownFunctor=None) -> ArServerModeDockPatrolBot
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask) -> ArServerModeDockPatrolBot
        """
        this = _ArnlPy.new_ArServerModeDockPatrolBot(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDockPatrolBot
    __del__ = lambda self : None;
    def isDocked(*args):
        """isDocked(self) -> bool"""
        return _ArnlPy.ArServerModeDockPatrolBot_isDocked(*args)

    def enableDock(*args):
        """enableDock(self)"""
        return _ArnlPy.ArServerModeDockPatrolBot_enableDock(*args)

    def disableDock(*args):
        """disableDock(self)"""
        return _ArnlPy.ArServerModeDockPatrolBot_disableDock(*args)

    def checkDock(*args):
        """checkDock(self)"""
        return _ArnlPy.ArServerModeDockPatrolBot_checkDock(*args)

    def beforeDriveInCallback(*args):
        """beforeDriveInCallback(self)"""
        return _ArnlPy.ArServerModeDockPatrolBot_beforeDriveInCallback(*args)

    def afterDriveOutCallback(*args):
        """afterDriveOutCallback(self)"""
        return _ArnlPy.ArServerModeDockPatrolBot_afterDriveOutCallback(*args)

ArServerModeDockPatrolBot_swigregister = _ArnlPy.ArServerModeDockPatrolBot_swigregister
ArServerModeDockPatrolBot_swigregister(ArServerModeDockPatrolBot)

class ArServerModeDockSimulator(ArServerModeDockTriangleBump):
    """Proxy of C++ ArServerModeDockSimulator class"""
    __swig_setmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDockSimulator, name, value)
    __swig_getmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDockSimulator, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            ArFunctor shutdownFunctor=None) -> ArServerModeDockSimulator
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask) -> ArServerModeDockSimulator
        """
        this = _ArnlPy.new_ArServerModeDockSimulator(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDockSimulator
    __del__ = lambda self : None;
    def isDocked(*args):
        """isDocked(self) -> bool"""
        return _ArnlPy.ArServerModeDockSimulator_isDocked(*args)

    def enableDock(*args):
        """enableDock(self)"""
        return _ArnlPy.ArServerModeDockSimulator_enableDock(*args)

    def disableDock(*args):
        """disableDock(self)"""
        return _ArnlPy.ArServerModeDockSimulator_disableDock(*args)

    def checkDock(*args):
        """checkDock(self)"""
        return _ArnlPy.ArServerModeDockSimulator_checkDock(*args)

ArServerModeDockSimulator_swigregister = _ArnlPy.ArServerModeDockSimulator_swigregister
ArServerModeDockSimulator_swigregister(ArServerModeDockSimulator)

class ArServerModeDockPowerBot(ArServerModeDockTriangleBump):
    """Proxy of C++ ArServerModeDockPowerBot class"""
    __swig_setmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArServerModeDockPowerBot, name, value)
    __swig_getmethods__ = {}
    for _s in [ArServerModeDockTriangleBump]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArServerModeDockPowerBot, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            bool isOldDock, ArFunctor shutdownFunctor=None, 
            bool useChargeState=False, int oldDockAnalogPort=0) -> ArServerModeDockPowerBot
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            bool isOldDock, ArFunctor shutdownFunctor=None, 
            bool useChargeState=False) -> ArServerModeDockPowerBot
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            bool isOldDock, ArFunctor shutdownFunctor=None) -> ArServerModeDockPowerBot
        __init__(self, ArServerBase serverBase, ArRobot robot, ArLocalizationTask locTask, 
            ArPathPlanningTask pathTask, 
            bool isOldDock) -> ArServerModeDockPowerBot
        """
        this = _ArnlPy.new_ArServerModeDockPowerBot(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _ArnlPy.delete_ArServerModeDockPowerBot
    __del__ = lambda self : None;
    def isDocked(*args):
        """isDocked(self) -> bool"""
        return _ArnlPy.ArServerModeDockPowerBot_isDocked(*args)

    def enableDock(*args):
        """enableDock(self)"""
        return _ArnlPy.ArServerModeDockPowerBot_enableDock(*args)

    def disableDock(*args):
        """disableDock(self)"""
        return _ArnlPy.ArServerModeDockPowerBot_disableDock(*args)

    def backoutCallback(*args):
        """backoutCallback(self)"""
        return _ArnlPy.ArServerModeDockPowerBot_backoutCallback(*args)

    def addToConfig(*args):
        """addToConfig(self, ArConfig config)"""
        return _ArnlPy.ArServerModeDockPowerBot_addToConfig(*args)

ArServerModeDockPowerBot_swigregister = _ArnlPy.ArServerModeDockPowerBot_swigregister
ArServerModeDockPowerBot_swigregister(ArServerModeDockPowerBot)



