/*
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

*/
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.mobilerobots.SonArnl;

  import com.mobilerobots.Aria.*;
  import com.mobilerobots.ArNetworking.*;
  import com.mobilerobots.BaseArnl.*;

public class ArSonarLocalizationTask extends ArBaseLocalizationTask {
  private long swigCPtr;

  /* for internal use by swig only */
  public ArSonarLocalizationTask(long cPtr, boolean cMemoryOwn) {
    super(SonArnlJavaJNI.SWIGArSonarLocalizationTaskUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  /* for internal use by swig only */
  public static long getCPtr(ArSonarLocalizationTask obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      SonArnlJavaJNI.delete_ArSonarLocalizationTask(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  public ArSonarLocalizationTask(ArRobot robot, ArSonarDevice sonar, String mapName) {
    this(SonArnlJavaJNI.new_ArSonarLocalizationTask__SWIG_0(ArRobot.getCPtr(robot), ArSonarDevice.getCPtr(sonar), mapName), true);
  }

  public ArSonarLocalizationTask(ArRobot robot, ArSonarDevice sonar, ArMapInterface ariaMap) {
    this(SonArnlJavaJNI.new_ArSonarLocalizationTask__SWIG_1(ArRobot.getCPtr(robot), ArSonarDevice.getCPtr(sonar), ArMapInterface.getCPtr(ariaMap)), true);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor, boolean warn, boolean setInitializedToFalse) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotInMapInit__SWIG_0(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor, warn, setInitializedToFalse);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor, boolean warn) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotInMapInit__SWIG_1(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor, warn);
  }

  public boolean localizeRobotInMapInit(ArPose given, int numSamples, double stdX, double stdY, double stdT, double thresFactor) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotInMapInit__SWIG_2(swigCPtr, ArPose.getCPtr(given), numSamples, stdX, stdY, stdT, thresFactor);
  }

  public boolean localizeRobotInMapMoved(int numSamples, double distFactor, double angFactor, double thresFactor) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotInMapMoved(swigCPtr, numSamples, distFactor, angFactor, thresFactor);
  }

  public boolean localizeRobotAtHomeBlocking(double distSpread, double angleSpread, double probThreshold) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotAtHomeBlocking__SWIG_0(swigCPtr, distSpread, angleSpread, probThreshold);
  }

  public boolean localizeRobotAtHomeBlocking(double spreadX, double spreadY, double angleSpread, double probThreshold) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotAtHomeBlocking__SWIG_1(swigCPtr, spreadX, spreadY, angleSpread, probThreshold);
  }

  public boolean localizeRobotAtHomeBlocking() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotAtHomeBlocking__SWIG_2(swigCPtr);
  }

  public boolean localizeRobotAtHomeNonBlocking() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotAtHomeNonBlocking(swigCPtr);
  }

  public ArPose getRobotHome() {
    return new ArPose(SonArnlJavaJNI.ArSonarLocalizationTask_getRobotHome(swigCPtr), true);
  }

  public void setForceUpdateParams(int numSamples, double xStd, double yStd, double tStd) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setForceUpdateParams(swigCPtr, numSamples, xStd, yStd, tStd);
  }

  public void forceUpdatePose(ArPose forcePose) {
    SonArnlJavaJNI.ArSonarLocalizationTask_forceUpdatePose(swigCPtr, ArPose.getCPtr(forcePose));
  }

  public void addFailedLocalizationCB(ArFunctor1_Int functor) {
    SonArnlJavaJNI.ArSonarLocalizationTask_addFailedLocalizationCB(swigCPtr, ArFunctor1_Int.getCPtr(functor));
  }

  public void remFailedLocalizationCB(ArFunctor1_Int functor) {
    SonArnlJavaJNI.ArSonarLocalizationTask_remFailedLocalizationCB(swigCPtr, ArFunctor1_Int.getCPtr(functor));
  }

  public void setFailedCallBack(ArFunctor1_Int fcb) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setFailedCallBack(swigCPtr, ArFunctor1_Int.getCPtr(fcb));
  }

  public void setTriggerDelR(double tr) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerDelR(swigCPtr, tr);
  }

  public void setTriggerDelT(double tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerDelT(swigCPtr, tt);
  }

  public void setTriggerTimeFlag(boolean tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerTimeFlag(swigCPtr, tt);
  }

  public void setTriggerTime(double tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerTime(swigCPtr, tt);
  }

  public void setTriggerTimeX(double tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerTimeX(swigCPtr, tt);
  }

  public void setTriggerTimeY(double tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerTimeY(swigCPtr, tt);
  }

  public void setTriggerTimeTh(double tt) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTriggerTimeTh(swigCPtr, tt);
  }

  public void setNumSamples(int n) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setNumSamples(swigCPtr, n);
  }

  public void setNumSamplesAtInit(int n) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setNumSamplesAtInit(swigCPtr, n);
  }

  public void setCurrentNumSamples(int n) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setCurrentNumSamples(swigCPtr, n);
  }

  public void setNumSamplesAngleFactor(double f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setNumSamplesAngleFactor(swigCPtr, f);
  }

  public void setPassThreshold(double f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setPassThreshold(swigCPtr, f);
  }

  public void setSensorBelief(double sensorBelief) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setSensorBelief(swigCPtr, sensorBelief);
  }

  public void setCurrentLocaPose(double x, double y, double th) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setCurrentLocaPose__SWIG_0(swigCPtr, x, y, th);
  }

  public void setCurrentLocaPose(ArPose p) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setCurrentLocaPose__SWIG_1(swigCPtr, ArPose.getCPtr(p));
  }

  public void setVerboseFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setVerboseFlag(swigCPtr, f);
  }

  public void setRecoverOnFailedFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setRecoverOnFailedFlag(swigCPtr, f);
  }

  public void setIdleFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setIdleFlag(swigCPtr, f);
  }

  public void setReloadingMapFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setReloadingMapFlag(swigCPtr, f);
  }

  public void setSonarMaxRange(double f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setSonarMaxRange(swigCPtr, f);
  }

  public void getForceUpdateParams(ArPose forcePose, SWIGTYPE_p_int numSamples, SWIGTYPE_p_double xStd, SWIGTYPE_p_double yStd, SWIGTYPE_p_double tStd) {
    SonArnlJavaJNI.ArSonarLocalizationTask_getForceUpdateParams(swigCPtr, ArPose.getCPtr(forcePose), SWIGTYPE_p_int.getCPtr(numSamples), SWIGTYPE_p_double.getCPtr(xStd), SWIGTYPE_p_double.getCPtr(yStd), SWIGTYPE_p_double.getCPtr(tStd));
  }

  public boolean getVerboseFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getVerboseFlag(swigCPtr);
  }

  public boolean getInitializedFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getInitializedFlag(swigCPtr);
  }

  public int getNumSamples() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getNumSamples(swigCPtr);
  }

  public int getNumSamplesAtInit() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getNumSamplesAtInit(swigCPtr);
  }

  public int getCurrentNumSamples() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getCurrentNumSamples(swigCPtr);
  }

  public ArPose getRobotMaxProbPose() {
    return new ArPose(SonArnlJavaJNI.ArSonarLocalizationTask_getRobotMaxProbPose(swigCPtr), true);
  }

  public double getTriggerDelR() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerDelR(swigCPtr);
  }

  public double getTriggerDelT() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerDelT(swigCPtr);
  }

  public boolean getTriggerTimeFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerTimeFlag(swigCPtr);
  }

  public double getTriggerTime() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerTime(swigCPtr);
  }

  public double getTriggerTimeX() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerTimeX(swigCPtr);
  }

  public double getTriggerTimeY() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerTimeY(swigCPtr);
  }

  public double getTriggerTimeTh() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTriggerTimeTh(swigCPtr);
  }

  public double getPassThreshold() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPassThreshold(swigCPtr);
  }

  public double getUsingPassThreshold() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getUsingPassThreshold(swigCPtr);
  }

  public void setTempPassThreshold(double passThreshold) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setTempPassThreshold(swigCPtr, passThreshold);
  }

  public double getTempPassThreshold() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getTempPassThreshold(swigCPtr);
  }

  public void clearTempPassThreshold() {
    SonArnlJavaJNI.ArSonarLocalizationTask_clearTempPassThreshold(swigCPtr);
  }

  public double getLocalizationScore() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getLocalizationScore(swigCPtr);
  }

  public double getSensorBelief() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getSensorBelief(swigCPtr);
  }

  public ArPose getCurrentLocaPose() {
    return new ArPose(SonArnlJavaJNI.ArSonarLocalizationTask_getCurrentLocaPose(swigCPtr), true);
  }

  public double getStdX() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getStdX(swigCPtr);
  }

  public double getStdY() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getStdY(swigCPtr);
  }

  public double getStdTh() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getStdTh(swigCPtr);
  }

  public double getErrorMmPerMm() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getErrorMmPerMm(swigCPtr);
  }

  public double getErrorDegPerDeg() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getErrorDegPerDeg(swigCPtr);
  }

  public double getErrorDegPerMm() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getErrorDegPerMm(swigCPtr);
  }

  public double getPeakFactor() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeakFactor(swigCPtr);
  }

  public String getMapName() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getMapName(swigCPtr);
  }

  public double getPeturbRangeX() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeturbRangeX(swigCPtr);
  }

  public double getPeturbRangeY() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeturbRangeY(swigCPtr);
  }

  public double getPeturbRangeTh() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeturbRangeTh(swigCPtr);
  }

  public double getFailedRangeX() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getFailedRangeX(swigCPtr);
  }

  public double getFailedRangeY() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getFailedRangeY(swigCPtr);
  }

  public double getFailedRangeTh() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getFailedRangeTh(swigCPtr);
  }

  public double getPeakStdX() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeakStdX(swigCPtr);
  }

  public double getPeakStdY() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeakStdY(swigCPtr);
  }

  public double getPeakStdTh() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getPeakStdTh(swigCPtr);
  }

  public ArMapInterface getAriaMap() {
    long cPtr = SonArnlJavaJNI.ArSonarLocalizationTask_getAriaMap(swigCPtr);
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public int getBufferSize() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getBufferSize(swigCPtr);
  }

  public SWIGTYPE_p_std__vectorTArPose_t getXYBuffer() {
    return new SWIGTYPE_p_std__vectorTArPose_t(SonArnlJavaJNI.ArSonarLocalizationTask_getXYBuffer(swigCPtr), true);
  }

  public ArPose getBufferPose() {
    return new ArPose(SonArnlJavaJNI.ArSonarLocalizationTask_getBufferPose(swigCPtr), true);
  }

  public ArPoseList getCurrentSamplePoses() {
    return new ArPoseList(SonArnlJavaJNI.ArSonarLocalizationTask_getCurrentSamplePoses(swigCPtr), true);
  }

  public boolean getRecoverOnFailedFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getRecoverOnFailedFlag(swigCPtr);
  }

  public double getNumSamplesAngleFactor() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getNumSamplesAngleFactor(swigCPtr);
  }

  public double getSonarMaxRange() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getSonarMaxRange(swigCPtr);
  }

  public double getSonarMinLineSize() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getSonarMinLineSize(swigCPtr);
  }

  public boolean getAdjustNumSamplesFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getAdjustNumSamplesFlag(swigCPtr);
  }

  public int getMinNumSamples() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getMinNumSamples(swigCPtr);
  }

  public ArBaseLocalizationTask.LocalizationState getState() {
    return ArBaseLocalizationTask.LocalizationState.swigToEnum(SonArnlJavaJNI.ArSonarLocalizationTask_getState(swigCPtr));
  }

  public boolean getIdleFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getIdleFlag(swigCPtr);
  }

  public boolean getReloadingMapFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getReloadingMapFlag(swigCPtr);
  }

  public ArMapInterface readMapFromFile(String mapName) {
    long cPtr = SonArnlJavaJNI.ArSonarLocalizationTask_readMapFromFile(swigCPtr, mapName);
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public ArMapInterface readAriaMap(ArMapInterface ariaMap) {
    long cPtr = SonArnlJavaJNI.ArSonarLocalizationTask_readAriaMap(swigCPtr, ArMapInterface.getCPtr(ariaMap));
    return (cPtr == 0) ? null : new ArMapInterface(cPtr, false);
  }

  public boolean loadParamFile(String file) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_loadParamFile(swigCPtr, file);
  }

  public boolean saveParams(String filename) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_saveParams(swigCPtr, filename);
  }

  public boolean fillHistogram(SWIGTYPE_p_double hist, SWIGTYPE_p_double cumSum, SWIGTYPE_p_int numSamples) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_fillHistogram(swigCPtr, SWIGTYPE_p_double.getCPtr(hist), SWIGTYPE_p_double.getCPtr(cumSum), SWIGTYPE_p_int.getCPtr(numSamples));
  }

  public boolean scanToGlobalCoords(ArPose robPose, SWIGTYPE_p_std__vectorTArPose_t xyLrf) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_scanToGlobalCoords(swigCPtr, ArPose.getCPtr(robPose), SWIGTYPE_p_std__vectorTArPose_t.getCPtr(xyLrf));
  }

  public boolean setLocaParams(double xStd, double yStd, double tStd, double kMmPerMm, double kDegPerDeg, double kDegPerMm, double sensorBelief) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_setLocaParams(swigCPtr, xStd, yStd, tStd, kMmPerMm, kDegPerDeg, kDegPerMm, sensorBelief);
  }

  public void setAdjustNumSamplesFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setAdjustNumSamplesFlag(swigCPtr, f);
  }

  public void setMinNumSamples(int f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setMinNumSamples(swigCPtr, f);
  }

  public void setLastLocaTimeToNow() {
    SonArnlJavaJNI.ArSonarLocalizationTask_setLastLocaTimeToNow(swigCPtr);
  }

  public ArTime getLastLocaTime() {
    return new ArTime(SonArnlJavaJNI.ArSonarLocalizationTask_getLastLocaTime(swigCPtr), true);
  }

  public boolean findMCLMeanVar(ArPose mean, SWIGTYPE_p_ArMatrix Var) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_findMCLMeanVar(swigCPtr, ArPose.getCPtr(mean), SWIGTYPE_p_ArMatrix.getCPtr(Var));
  }

  public boolean findLocalizationMeanVar(ArPose mean, SWIGTYPE_p_ArMatrix Var) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_findLocalizationMeanVar(swigCPtr, ArPose.getCPtr(mean), SWIGTYPE_p_ArMatrix.getCPtr(Var));
  }

  public void setCorrectRobotFlag(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setCorrectRobotFlag(swigCPtr, f);
  }

  public void setRobotPose(ArPose pose, ArPose spread, int nSam) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setRobotPose__SWIG_0(swigCPtr, ArPose.getCPtr(pose), ArPose.getCPtr(spread), nSam);
  }

  public void setRobotPose(ArPose pose, ArPose spread) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setRobotPose__SWIG_1(swigCPtr, ArPose.getCPtr(pose), ArPose.getCPtr(spread));
  }

  public void setRobotPose(ArPose pose) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setRobotPose__SWIG_2(swigCPtr, ArPose.getCPtr(pose));
  }

  public boolean getRobotIsLostFlag() {
    return SonArnlJavaJNI.ArSonarLocalizationTask_getRobotIsLostFlag(swigCPtr);
  }

  public boolean localizeRobotAtHomeBlocking(double distSpread, double angleSpread) {
    return SonArnlJavaJNI.ArSonarLocalizationTask_localizeRobotAtHomeBlocking__SWIG_3(swigCPtr, distSpread, angleSpread);
  }

  public void setLocalizationIdle(boolean f) {
    SonArnlJavaJNI.ArSonarLocalizationTask_setLocalizationIdle(swigCPtr, f);
  }

  public void drawRangePoints(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawRangePoints(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawClosestLines(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawClosestLines(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawBestRays(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawBestRays(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawSampleRays(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawSampleRays(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawSonarRays(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawSonarRays(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawIntersections(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawIntersections(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawHistogram(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawHistogram(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawBestPoses(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawBestPoses(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawSamplePoses(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawSamplePoses(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

  public void drawMCLVariance(ArServerClient client, ArNetPacket packet) {
    SonArnlJavaJNI.ArSonarLocalizationTask_drawMCLVariance(swigCPtr, ArServerClient.getCPtr(client), ArNetPacket.getCPtr(packet));
  }

}
