"""
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

"""
# This file was created automatically by SWIG 1.3.29.
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.

"""
Python wrapper library for SONARNL
"""

import _SonArnlPy
import new
new_instancemethod = new.instancemethod
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


try:
    import weakref
    weakref_proxy = weakref.proxy
except:
    weakref_proxy = lambda x: x


SONARNL = _SonArnlPy.SONARNL
class PySwigIterator(_object):
    """Proxy of C++ PySwigIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PySwigIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PySwigIterator, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _SonArnlPy.delete_PySwigIterator
    __del__ = lambda self : None;
    def value(*args):
        """value(self) -> PyObject"""
        return _SonArnlPy.PySwigIterator_value(*args)

    def incr(*args):
        """
        incr(self, size_t n=1) -> PySwigIterator
        incr(self) -> PySwigIterator
        """
        return _SonArnlPy.PySwigIterator_incr(*args)

    def decr(*args):
        """
        decr(self, size_t n=1) -> PySwigIterator
        decr(self) -> PySwigIterator
        """
        return _SonArnlPy.PySwigIterator_decr(*args)

    def distance(*args):
        """distance(self, PySwigIterator x) -> ptrdiff_t"""
        return _SonArnlPy.PySwigIterator_distance(*args)

    def equal(*args):
        """equal(self, PySwigIterator x) -> bool"""
        return _SonArnlPy.PySwigIterator_equal(*args)

    def copy(*args):
        """copy(self) -> PySwigIterator"""
        return _SonArnlPy.PySwigIterator_copy(*args)

    def next(*args):
        """next(self) -> PyObject"""
        return _SonArnlPy.PySwigIterator_next(*args)

    def previous(*args):
        """previous(self) -> PyObject"""
        return _SonArnlPy.PySwigIterator_previous(*args)

    def advance(*args):
        """advance(self, ptrdiff_t n) -> PySwigIterator"""
        return _SonArnlPy.PySwigIterator_advance(*args)

    def __eq__(*args):
        """__eq__(self, PySwigIterator x) -> bool"""
        return _SonArnlPy.PySwigIterator___eq__(*args)

    def __ne__(*args):
        """__ne__(self, PySwigIterator x) -> bool"""
        return _SonArnlPy.PySwigIterator___ne__(*args)

    def __iadd__(*args):
        """__iadd__(self, ptrdiff_t n) -> PySwigIterator"""
        return _SonArnlPy.PySwigIterator___iadd__(*args)

    def __isub__(*args):
        """__isub__(self, ptrdiff_t n) -> PySwigIterator"""
        return _SonArnlPy.PySwigIterator___isub__(*args)

    def __add__(*args):
        """__add__(self, ptrdiff_t n) -> PySwigIterator"""
        return _SonArnlPy.PySwigIterator___add__(*args)

    def __sub__(*args):
        """
        __sub__(self, ptrdiff_t n) -> PySwigIterator
        __sub__(self, PySwigIterator x) -> ptrdiff_t
        """
        return _SonArnlPy.PySwigIterator___sub__(*args)

    def __iter__(self): return self
PySwigIterator_swigregister = _SonArnlPy.PySwigIterator_swigregister
PySwigIterator_swigregister(PySwigIterator)

import AriaPy
SWIG_IMPORTED_ARIA = _SonArnlPy.SWIG_IMPORTED_ARIA
import ArNetworkingPy
SWIG_IMPORTED_ARNETWORKING = _SonArnlPy.SWIG_IMPORTED_ARNETWORKING
import BaseArnlPy
SWIG_IMPORTED_ARNL_BASE = _SonArnlPy.SWIG_IMPORTED_ARNL_BASE
class ArSonarLocalizationTask(BaseArnlPy.ArBaseLocalizationTask):
    """Proxy of C++ ArSonarLocalizationTask class"""
    __swig_setmethods__ = {}
    for _s in [BaseArnlPy.ArBaseLocalizationTask]: __swig_setmethods__.update(_s.__swig_setmethods__)
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArSonarLocalizationTask, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseArnlPy.ArBaseLocalizationTask]: __swig_getmethods__.update(_s.__swig_getmethods__)
    __getattr__ = lambda self, name: _swig_getattr(self, ArSonarLocalizationTask, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, ArRobot robot, ArSonarDevice sonar, char mapName) -> ArSonarLocalizationTask
        __init__(self, ArRobot robot, ArSonarDevice sonar, ArMapInterface ariaMap) -> ArSonarLocalizationTask
        """
        this = _SonArnlPy.new_ArSonarLocalizationTask(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _SonArnlPy.delete_ArSonarLocalizationTask
    __del__ = lambda self : None;
    def localizeRobotInMapInit(*args):
        """
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor, bool warn=True, 
            bool setInitializedToFalse=True) -> bool
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor, bool warn=True) -> bool
        localizeRobotInMapInit(self, ArPose given, int numSamples, double stdX, double stdY, 
            double stdT, double thresFactor) -> bool
        """
        return _SonArnlPy.ArSonarLocalizationTask_localizeRobotInMapInit(*args)

    def localizeRobotInMapMoved(*args):
        """
        localizeRobotInMapMoved(self, int numSamples, double distFactor, double angFactor, 
            double thresFactor) -> bool
        """
        return _SonArnlPy.ArSonarLocalizationTask_localizeRobotInMapMoved(*args)

    def localizeRobotAtHomeNonBlocking(*args):
        """localizeRobotAtHomeNonBlocking(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_localizeRobotAtHomeNonBlocking(*args)

    def getRobotHome(*args):
        """getRobotHome(self) -> ArPose"""
        return _SonArnlPy.ArSonarLocalizationTask_getRobotHome(*args)

    def setForceUpdateParams(*args):
        """setForceUpdateParams(self, int numSamples, double xStd, double yStd, double tStd)"""
        return _SonArnlPy.ArSonarLocalizationTask_setForceUpdateParams(*args)

    def forceUpdatePose(*args):
        """forceUpdatePose(self, ArPose forcePose)"""
        return _SonArnlPy.ArSonarLocalizationTask_forceUpdatePose(*args)

    def addFailedLocalizationCB(*args):
        """addFailedLocalizationCB(self, ArFunctor1_Int functor)"""
        return _SonArnlPy.ArSonarLocalizationTask_addFailedLocalizationCB(*args)

    def remFailedLocalizationCB(*args):
        """remFailedLocalizationCB(self, ArFunctor1_Int functor)"""
        return _SonArnlPy.ArSonarLocalizationTask_remFailedLocalizationCB(*args)

    def setFailedCallBack(*args):
        """setFailedCallBack(self, ArFunctor1_Int fcb)"""
        return _SonArnlPy.ArSonarLocalizationTask_setFailedCallBack(*args)

    def setTriggerDelR(*args):
        """setTriggerDelR(self, double tr)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerDelR(*args)

    def setTriggerDelT(*args):
        """setTriggerDelT(self, double tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerDelT(*args)

    def setTriggerTimeFlag(*args):
        """setTriggerTimeFlag(self, bool tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerTimeFlag(*args)

    def setTriggerTime(*args):
        """setTriggerTime(self, double tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerTime(*args)

    def setTriggerTimeX(*args):
        """setTriggerTimeX(self, double tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerTimeX(*args)

    def setTriggerTimeY(*args):
        """setTriggerTimeY(self, double tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerTimeY(*args)

    def setTriggerTimeTh(*args):
        """setTriggerTimeTh(self, double tt)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTriggerTimeTh(*args)

    def setNumSamples(*args):
        """setNumSamples(self, int n)"""
        return _SonArnlPy.ArSonarLocalizationTask_setNumSamples(*args)

    def setNumSamplesAtInit(*args):
        """setNumSamplesAtInit(self, int n)"""
        return _SonArnlPy.ArSonarLocalizationTask_setNumSamplesAtInit(*args)

    def setCurrentNumSamples(*args):
        """setCurrentNumSamples(self, int n)"""
        return _SonArnlPy.ArSonarLocalizationTask_setCurrentNumSamples(*args)

    def setNumSamplesAngleFactor(*args):
        """setNumSamplesAngleFactor(self, double f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setNumSamplesAngleFactor(*args)

    def setPassThreshold(*args):
        """setPassThreshold(self, double f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setPassThreshold(*args)

    def setSensorBelief(*args):
        """setSensorBelief(self, double sensorBelief)"""
        return _SonArnlPy.ArSonarLocalizationTask_setSensorBelief(*args)

    def setCurrentLocaPose(*args):
        """
        setCurrentLocaPose(self, double x, double y, double th)
        setCurrentLocaPose(self, ArPose p)
        """
        return _SonArnlPy.ArSonarLocalizationTask_setCurrentLocaPose(*args)

    def setVerboseFlag(*args):
        """setVerboseFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setVerboseFlag(*args)

    def setRecoverOnFailedFlag(*args):
        """setRecoverOnFailedFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setRecoverOnFailedFlag(*args)

    def setIdleFlag(*args):
        """setIdleFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setIdleFlag(*args)

    def setReloadingMapFlag(*args):
        """setReloadingMapFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setReloadingMapFlag(*args)

    def setSonarMaxRange(*args):
        """setSonarMaxRange(self, double f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setSonarMaxRange(*args)

    def getForceUpdateParams(*args):
        """
        getForceUpdateParams(self, ArPose forcePose, int numSamples, double xStd, double yStd, 
            double tStd)
        """
        return _SonArnlPy.ArSonarLocalizationTask_getForceUpdateParams(*args)

    def getVerboseFlag(*args):
        """getVerboseFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getVerboseFlag(*args)

    def getInitializedFlag(*args):
        """getInitializedFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getInitializedFlag(*args)

    def getNumSamples(*args):
        """getNumSamples(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getNumSamples(*args)

    def getNumSamplesAtInit(*args):
        """getNumSamplesAtInit(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getNumSamplesAtInit(*args)

    def getCurrentNumSamples(*args):
        """getCurrentNumSamples(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getCurrentNumSamples(*args)

    def getRobotMaxProbPose(*args):
        """getRobotMaxProbPose(self) -> ArPose"""
        return _SonArnlPy.ArSonarLocalizationTask_getRobotMaxProbPose(*args)

    def getTriggerDelR(*args):
        """getTriggerDelR(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerDelR(*args)

    def getTriggerDelT(*args):
        """getTriggerDelT(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerDelT(*args)

    def getTriggerTimeFlag(*args):
        """getTriggerTimeFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerTimeFlag(*args)

    def getTriggerTime(*args):
        """getTriggerTime(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerTime(*args)

    def getTriggerTimeX(*args):
        """getTriggerTimeX(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerTimeX(*args)

    def getTriggerTimeY(*args):
        """getTriggerTimeY(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerTimeY(*args)

    def getTriggerTimeTh(*args):
        """getTriggerTimeTh(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTriggerTimeTh(*args)

    def getPassThreshold(*args):
        """getPassThreshold(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPassThreshold(*args)

    def getUsingPassThreshold(*args):
        """getUsingPassThreshold(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getUsingPassThreshold(*args)

    def setTempPassThreshold(*args):
        """setTempPassThreshold(self, double passThreshold)"""
        return _SonArnlPy.ArSonarLocalizationTask_setTempPassThreshold(*args)

    def getTempPassThreshold(*args):
        """getTempPassThreshold(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getTempPassThreshold(*args)

    def clearTempPassThreshold(*args):
        """clearTempPassThreshold(self)"""
        return _SonArnlPy.ArSonarLocalizationTask_clearTempPassThreshold(*args)

    def getLocalizationScore(*args):
        """getLocalizationScore(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getLocalizationScore(*args)

    def getSensorBelief(*args):
        """getSensorBelief(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getSensorBelief(*args)

    def getCurrentLocaPose(*args):
        """getCurrentLocaPose(self) -> ArPose"""
        return _SonArnlPy.ArSonarLocalizationTask_getCurrentLocaPose(*args)

    def getStdX(*args):
        """getStdX(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getStdX(*args)

    def getStdY(*args):
        """getStdY(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getStdY(*args)

    def getStdTh(*args):
        """getStdTh(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getStdTh(*args)

    def getErrorMmPerMm(*args):
        """getErrorMmPerMm(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getErrorMmPerMm(*args)

    def getErrorDegPerDeg(*args):
        """getErrorDegPerDeg(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getErrorDegPerDeg(*args)

    def getErrorDegPerMm(*args):
        """getErrorDegPerMm(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getErrorDegPerMm(*args)

    def getPeakFactor(*args):
        """getPeakFactor(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeakFactor(*args)

    def getMapName(*args):
        """getMapName(self) -> char"""
        return _SonArnlPy.ArSonarLocalizationTask_getMapName(*args)

    def getPeturbRangeX(*args):
        """getPeturbRangeX(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeturbRangeX(*args)

    def getPeturbRangeY(*args):
        """getPeturbRangeY(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeturbRangeY(*args)

    def getPeturbRangeTh(*args):
        """getPeturbRangeTh(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeturbRangeTh(*args)

    def getFailedRangeX(*args):
        """getFailedRangeX(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getFailedRangeX(*args)

    def getFailedRangeY(*args):
        """getFailedRangeY(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getFailedRangeY(*args)

    def getFailedRangeTh(*args):
        """getFailedRangeTh(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getFailedRangeTh(*args)

    def getPeakStdX(*args):
        """getPeakStdX(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeakStdX(*args)

    def getPeakStdY(*args):
        """getPeakStdY(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeakStdY(*args)

    def getPeakStdTh(*args):
        """getPeakStdTh(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getPeakStdTh(*args)

    def getAriaMap(*args):
        """getAriaMap(self) -> ArMapInterface"""
        return _SonArnlPy.ArSonarLocalizationTask_getAriaMap(*args)

    def getBufferSize(*args):
        """getBufferSize(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getBufferSize(*args)

    def getXYBuffer(*args):
        """getXYBuffer(self) -> std::vector<(ArPose,std::allocator<(ArPose)>)>"""
        return _SonArnlPy.ArSonarLocalizationTask_getXYBuffer(*args)

    def getBufferPose(*args):
        """getBufferPose(self) -> ArPose"""
        return _SonArnlPy.ArSonarLocalizationTask_getBufferPose(*args)

    def getCurrentSamplePoses(*args):
        """getCurrentSamplePoses(self) -> ArPoseList"""
        return _SonArnlPy.ArSonarLocalizationTask_getCurrentSamplePoses(*args)

    def getRecoverOnFailedFlag(*args):
        """getRecoverOnFailedFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getRecoverOnFailedFlag(*args)

    def getNumSamplesAngleFactor(*args):
        """getNumSamplesAngleFactor(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getNumSamplesAngleFactor(*args)

    def getSonarMaxRange(*args):
        """getSonarMaxRange(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getSonarMaxRange(*args)

    def getSonarMinLineSize(*args):
        """getSonarMinLineSize(self) -> double"""
        return _SonArnlPy.ArSonarLocalizationTask_getSonarMinLineSize(*args)

    def getAdjustNumSamplesFlag(*args):
        """getAdjustNumSamplesFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getAdjustNumSamplesFlag(*args)

    def getMinNumSamples(*args):
        """getMinNumSamples(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getMinNumSamples(*args)

    def getState(*args):
        """getState(self) -> int"""
        return _SonArnlPy.ArSonarLocalizationTask_getState(*args)

    def getIdleFlag(*args):
        """getIdleFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getIdleFlag(*args)

    def getReloadingMapFlag(*args):
        """getReloadingMapFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getReloadingMapFlag(*args)

    def readMapFromFile(*args):
        """readMapFromFile(self, char mapName) -> ArMapInterface"""
        return _SonArnlPy.ArSonarLocalizationTask_readMapFromFile(*args)

    def readAriaMap(*args):
        """readAriaMap(self, ArMapInterface ariaMap) -> ArMapInterface"""
        return _SonArnlPy.ArSonarLocalizationTask_readAriaMap(*args)

    def loadParamFile(*args):
        """loadParamFile(self, char file) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_loadParamFile(*args)

    def saveParams(*args):
        """saveParams(self, char filename) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_saveParams(*args)

    def fillHistogram(*args):
        """fillHistogram(self, double hist, double cumSum, int numSamples) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_fillHistogram(*args)

    def scanToGlobalCoords(*args):
        """scanToGlobalCoords(self, ArPose robPose, std::vector<(ArPose,std::allocator<(ArPose)>)> xyLrf) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_scanToGlobalCoords(*args)

    def setLocaParams(*args):
        """
        setLocaParams(self, double xStd, double yStd, double tStd, double kMmPerMm, 
            double kDegPerDeg, double kDegPerMm, double sensorBelief) -> bool
        """
        return _SonArnlPy.ArSonarLocalizationTask_setLocaParams(*args)

    def setAdjustNumSamplesFlag(*args):
        """setAdjustNumSamplesFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setAdjustNumSamplesFlag(*args)

    def setMinNumSamples(*args):
        """setMinNumSamples(self, int f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setMinNumSamples(*args)

    def setLastLocaTimeToNow(*args):
        """setLastLocaTimeToNow(self)"""
        return _SonArnlPy.ArSonarLocalizationTask_setLastLocaTimeToNow(*args)

    def getLastLocaTime(*args):
        """getLastLocaTime(self) -> ArTime"""
        return _SonArnlPy.ArSonarLocalizationTask_getLastLocaTime(*args)

    def findMCLMeanVar(*args):
        """findMCLMeanVar(self, ArPose mean, ArMatrix Var) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_findMCLMeanVar(*args)

    def findLocalizationMeanVar(*args):
        """findLocalizationMeanVar(self, ArPose mean, ArMatrix Var) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_findLocalizationMeanVar(*args)

    def setCorrectRobotFlag(*args):
        """setCorrectRobotFlag(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setCorrectRobotFlag(*args)

    def setRobotPose(*args):
        """
        setRobotPose(self, ArPose pose, ArPose spread=ArPose(0, 0, 0), int nSam=0)
        setRobotPose(self, ArPose pose, ArPose spread=ArPose(0, 0, 0))
        setRobotPose(self, ArPose pose)
        """
        return _SonArnlPy.ArSonarLocalizationTask_setRobotPose(*args)

    def getRobotIsLostFlag(*args):
        """getRobotIsLostFlag(self) -> bool"""
        return _SonArnlPy.ArSonarLocalizationTask_getRobotIsLostFlag(*args)

    def localizeRobotAtHomeBlocking(*args):
        """
        localizeRobotAtHomeBlocking(self, double distSpread, double angleSpread, double probThreshold) -> bool
        localizeRobotAtHomeBlocking(self, double spreadX, double spreadY, double angleSpread, 
            double probThreshold) -> bool
        localizeRobotAtHomeBlocking(self) -> bool
        localizeRobotAtHomeBlocking(self, double distSpread, double angleSpread) -> bool
        """
        return _SonArnlPy.ArSonarLocalizationTask_localizeRobotAtHomeBlocking(*args)

    def setLocalizationIdle(*args):
        """setLocalizationIdle(self, bool f)"""
        return _SonArnlPy.ArSonarLocalizationTask_setLocalizationIdle(*args)

    def drawRangePoints(*args):
        """drawRangePoints(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawRangePoints(*args)

    def drawClosestLines(*args):
        """drawClosestLines(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawClosestLines(*args)

    def drawBestRays(*args):
        """drawBestRays(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawBestRays(*args)

    def drawSampleRays(*args):
        """drawSampleRays(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawSampleRays(*args)

    def drawSonarRays(*args):
        """drawSonarRays(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawSonarRays(*args)

    def drawIntersections(*args):
        """drawIntersections(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawIntersections(*args)

    def drawHistogram(*args):
        """drawHistogram(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawHistogram(*args)

    def drawBestPoses(*args):
        """drawBestPoses(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawBestPoses(*args)

    def drawSamplePoses(*args):
        """drawSamplePoses(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawSamplePoses(*args)

    def drawMCLVariance(*args):
        """drawMCLVariance(self, ArServerClient client, ArNetPacket packet)"""
        return _SonArnlPy.ArSonarLocalizationTask_drawMCLVariance(*args)

ArSonarLocalizationTask_swigregister = _SonArnlPy.ArSonarLocalizationTask_swigregister
ArSonarLocalizationTask_swigregister(ArSonarLocalizationTask)



