"""
MobileRobots Advanced Robotics Navigation and Localization (ARNL)
Version 1.7.0

Copyright (C) 2004, 2005 ActivMedia Robotics LLC
Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.

All Rights Reserved.

MobileRobots Inc does not make any representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

The license for this software is distributed as LICENSE.txt in the top
level directory.

robots@mobilerobots.com
MobileRobots
10 Columbia Drive
Amherst, NH 03031
800-639-9481

"""



from AriaPy import *
from ArNetworkingPy import *
from BaseArnlPy import *
from SonArnlPy import *
import sys

# This is an example robot server written in Python, using SONARNL for
# path planning and localization (it is a slightly simplified version of
# guiServer.cpp written in Python):
# After it connects to the robot or simulator, connect with MobileEyes.

# Global library initialization, just like the C++ API:
Aria.init()
Arnl.init()

# Create robot and device objects:
robot = ArRobot()
gyro = ArAnalogGyro(robot)
sonar = ArSonarDevice()
robot.addRangeDevice(sonar);

# make the server for remote clients (e.g. MobileEyes)
server = ArServerBase()

# Create a "simple connector" object and connect to either the simulator
# or the robot. Unlike the C++ API which takes int and char* pointers, 
# the Python constructor just takes argv as a list.
print "Connecting..."
con = ArSimpleConnector(sys.argv)
if (not Aria.parseArgs()):
    Aria.logOptions()
    sys.exit(1)
if (not con.connectRobot(robot)):
    print "Could not connect to robot, exiting"
    sys.exit(1)

# Create map object, with "examples" as the default directory.
# You can change this to another directory containing
# maps. Don't forget the slash "/" on the end.
mapDir = Aria.getDirectory() + "examples/";
print "\n* Will look for maps in the directory: " + mapDir + " *\n"
map = ArMap(mapDir)


# Make the SONARNL localization task (using the sonar device, of course)
locTask = ArSonarLocalizationTask(robot, sonar, map)

# Make the path-planning task (using the Sonar's "current" (most recent)
# data for obstacle detection.
pathTask = ArPathPlanningTask(robot, sonar, map)

print "Opening server on port 7272..."
if (not server.open(7272)):
    print "Could not open server on port 7272, exiting"
    sys.exit(1)
print "Server is open on port 7272."


# Create services for remote clients (e.g. MobileEyes):

# Provides localization info:
serverInfoLocalization = ArServerInfoLocalization(server, robot, locTask)

# Allows client to manually trigger relocalization and a given point:
serverLocHandler = ArServerHandlerLocalization(server, robot, locTask)

# Provides the map:
serverMap = ArServerHandlerMap(server, map)

# Provides the planned path:
serverInfoPath = ArServerInfoPath(server, robot, pathTask)

# Information about the robot:
serverInfoRobot = ArServerInfoRobot(server, robot)

# Info from range sensors:
serverInfoSensor = ArServerInfoSensor(server, robot)

# Service to add new graphics on the map:
drawings = ArServerInfoDrawings(server)
drawings.addRobotsRangeDevices(robot)
serverInfoPath.addSearchRectangleDrawing(drawings)

# Modes for driving the robot:
modeGoto = ArServerModeGoto(server, robot, pathTask, map,
                            locTask.getHomePose())
modeStop = ArServerModeStop(server, robot, 0)
modeRatioDrive = ArServerModeRatioDrive(server, robot)
modeWander = ArServerModeWander(server, robot)
modeStop.addAsDefaultMode()
modeStop.activate()

# Simple text commands ("custom commands") in MobileEyes):
commands = ArServerHandlerCommands(server)
uCCommands = ArServerSimpleComUC(commands, robot)
loggingCommands = ArServerSimpleComMovementLogging(commands, robot)
gyroCommands = ArServerSimpleComGyro(commands, robot, gyro)
configCommands = ArServerSimpleComLogRobotConfig(commands, robot)
serverInfoPath.addControlCommands(commands)

# Service that allows client to read and change ArConfig parameters (used 
# throughout aria and arnl). Arnl.getTypicalDefaultParamFileName() returns
# "params/default-arnl.p".
configFileName = Arnl.getTypicalParamFileName();
print "Will use config file: ", configFileName
serverConfig = ArServerHandlerConfig(server, Aria.getConfig(), Arnl.getTypicalDefaultParamFileName(), Aria.getDirectory())

# Load the configuration
print "Loading config file..."
if (not Aria.getConfig().parseFile(configFileName)):
  print "Warning: Error loading configuration file \"%s\", exiting." % configFileName
    
# Run the robot and server threads in the background:
print "Running..."
robot.runAsync(1)
server.runAsync()
robot.enableMotors()
robot.waitForRunExit()
    
print "Goodbye."
