/*

  Copyright (C) 2004,2005, ActivMedia Robotics, LLC
  Copyright (C) 2006,2007,2008,2009 MobileRobots Inc.

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef ARARGUMENTPARSER_H
#define ARARGUMENTPARSER_H

#include "ariaTypedefs.h"
#include "ArArgumentBuilder.h"

/// Class for parsing arguments
/**
   This class is made for parsing arguments form an argc/argv
   set, an argument builder or just a string (for winmain)

   It will also load up some default arguments you call
   loadDefaultArguments.  You can add files or environmental variables
   to the list of default argument locations with
   addDefaultArgumentLocation.
**/
class ArArgumentParser
{
public:
  /// Constructor, takes the argc argv
  AREXPORT ArArgumentParser(int *argc, char **argv);
  /// Constructor, takes an argument builder
  AREXPORT ArArgumentParser(ArArgumentBuilder *builder);
  /// Destructor
  AREXPORT ~ArArgumentParser();
  /// Returns true if the argument was found
  AREXPORT bool checkArgument(const char *argument);
  /// Returns the word/argument after given argument 
  AREXPORT char *checkParameterArgument(const char *argument);
  /// Returns the word/argument after given argument 
  AREXPORT bool checkParameterArgumentString(const char *argument, 
					     const char **dest, 
					     bool *wasReallySet = NULL);
  /// Returns the integer after given argument 
  AREXPORT bool checkParameterArgumentInteger(const char *argument, int *dest,
					      bool *wasReallySet = NULL);
  /// Returns the word/argument after given argument 
  AREXPORT bool checkParameterArgumentBool(const char *argument, bool *dest,
					   bool *wasReallySet = NULL);
  /// Adds a string as a default argument
  AREXPORT void addDefaultArgument(const char *argument);
  /// Adds args from default files and environmental variables
  AREXPORT void loadDefaultArguments(void);
  /// Checks for the help strings and warns about unparsed arguments
  AREXPORT bool checkHelpAndWarnUnparsed(unsigned int numArgsOkay = 0);
  /// Gets how many arguments are left in this parser
  AREXPORT size_t getArgc(void) const;
  /// Gets the argv
  AREXPORT char** getArgv(void) const;
  /// Gets a specific argument
  AREXPORT const char* getArg(size_t whichArg) const;
  /// Prints out the arguments left in this parser
  AREXPORT void log(void) const;
  /// Internal function to remove an argument that was parsed
  AREXPORT void removeArg(size_t which);
  /// Adds another file or environmental variable to the list of defaults
  AREXPORT static void addDefaultArgumentFile(const char *file);
  /// Adds another file or environmental variable to the list of defaults
  AREXPORT static void addDefaultArgumentEnv(const char *env);
  /// Logs the default argument locations
  AREXPORT static void logDefaultArgumentLocations(void);
#ifndef SWIG
  /// Returns true if the argument was found
  AREXPORT bool checkArgumentVar(const char *argument, ...);
  /// Returns the word/argument after given argument 
  AREXPORT char *checkParameterArgumentVar(const char *argument, ...);
  /// Returns the word/argument after given argument 
  AREXPORT bool checkParameterArgumentStringVar(bool *wasReallySet, 
						const char **dest, 
						const char *argument, ...);
  /// Returns the word/argument after given argument 
  AREXPORT bool checkParameterArgumentBoolVar(bool *wasReallySet, bool *dest,
					      const char *argument, ...);
  /// Returns the integer after given argument 
  AREXPORT bool checkParameterArgumentIntegerVar(bool *wasReallySet, int *dest,
						 const char *argument, ...);
#endif
protected:
  static std::list<std::string> ourDefaultArgumentLocs;
  static std::list<bool> ourDefaultArgumentLocIsFile;
  bool myOwnBuilder;
  ArArgumentBuilder *myBuilder;
  bool myUsingBuilder;
  char **myArgv;
  int *myArgc;
  char myEmptyArg[1];
};


#endif // ARARGUMENTPARSER_H
