/*
  Copyright (C) 2008,2009 MobileRobots Inc.

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AR_SCOPED_TIMER_
#define AR_SCOPED_TIMER_

#include "ArFunctor.h"
#include "ariaUtil.h"

#include <stdio.h>

class ArScopedTimer
{
protected:
  ArTime myTimer;
  std::string myMsg;
  ArFunctor1<const char*> *myLogFunc;
  unsigned int myWarnThresh;
  bool myDeleteLogFunc;
public:
  ArScopedTimer(std::string msg, ArFunctor1<const char*> *logFunc, unsigned int warnThresh = 0, bool delLogFunc = false) : myMsg(msg), myLogFunc(logFunc), myWarnThresh(warnThresh), myDeleteLogFunc(delLogFunc)
  {
    myTimer.setToNow();
  }
  virtual ~ArScopedTimer() 
  {
    if((unsigned int)myTimer.mSecSince() >= myWarnThresh)
    {
      char time[32];
      snprintf(time, 32, ": %ld ms", myTimer.mSecSince());
      std::string msg = myMsg + time;
      if(myLogFunc)
      {
        myLogFunc->invoke(msg.c_str());
      }
      else
      {
        puts(myMsg.c_str());
      }
    }
    if(myLogFunc && myDeleteLogFunc)
      delete myLogFunc;
  }
};


#endif

