/*
 *  Copyright (C) 2006, 2007, 2008, 2009 MobileRobots Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _MOBILESIM_HH_
#define _MOBILESIM_HH_

#include "ariaUtil.h"
#include <set>

#define PATHSEPCH '/'
#define OTHER_PATHSEPCH '\\'


/* Program version */

#ifndef MOBILESIM_VERSION
#error MOBILESIM_VERSION not defined!
#endif

/* Size of buffers used to store file path names */
#define MAX_PATH_LEN 512

/* Error codes */
#define ERR_USAGE -1 // becomes 255
#define ERR_TEMPFILE -2 //becomes 254
#define ERR_MAPCONV -3 // becomes 253
#define ERR_MAPLOAD -3 // becomes 253
#define ERR_STAGELOAD -4 // becomes 252
#define ERR_STAGEINIT -4 // becomes 252
#define ERR_FORK -5   // becomes 251
#define ERR_PFILE -6 // becomes 250
#define ERR_ROBOT_INIT -7 // becomes 249
#define ERR_OPEN_PORT -8 // becomes 248
// Note: -10 through -19 are used by the EmulatePioneer module.
#define ERR_CRASH -20 // becomes 236

/* Global variables for some options */
extern bool NonInteractive;
extern bool RestartedAfterCrash;


/* Figure out what directory to use for our external resources */
extern const char* find_libdir();

/* Functions used as callbacks */
typedef void(mobilesim_get_bounds_cb_t)(double*, double*, double*, double*);
typedef void(mobilesim_get_pose_cb_t)(double*, double*, double*);

extern mobilesim_get_bounds_cb_t mobilesim_get_map_bounds;
extern void mobilesim_get_map_home(double *home_x, double *home_y, double *home_th);
extern mobilesim_get_pose_cb_t mobilesim_set_map_home;
extern void mobilesim_set_map_bounds(double min_x, double min_y, double max_x, double max_y);

/* How to decide where robots start */
typedef enum {
  mobilesim_start_fixedpos,
  mobilesim_start_home,
  mobilesim_start_outside,
  mobilesim_start_random
} mobilesim_start_place_t;

extern void mobilesim_crash_handler(int signal);
extern int mobilesim_rotate_log_files(const char *tag);
extern FILE* mobilesim_reopen_log_file();

extern int mobilesim_argc;
extern char **mobilesim_argv;

extern char *mobilesim_log_file;

class RobotFactory;
class RobotInterface;
class EmulatePioneer;

extern std::set<RobotInterface*> robotInterfaces;
extern std::set<EmulatePioneer*> emulators;
extern std::set<RobotFactory*> factories;

void storeEmulator(EmulatePioneer *em);
void removeStoredEmulator(EmulatePioneer *em);
void storeRobotInterface(RobotInterface *em);
void removeStoredRobotInterface(RobotInterface *em);

#endif
