
/*  
    (C) Copyright 2005, ActivMedia Robotics LLC <http://www.activmedia.com>
    (C) Copyright 2006, 2007, 2008, 2009 MobileRobots, Inc. <http://www.mobilerobots.com>

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ROBOT_FACTORY_HH_
#define ROBOT_FACTORY_HH_

#include <string>
#include <pthread.h>
#include <set>
#include "RobotInterface.hh"
#include "ArSocket.h"


/** Interface for a class to listen on a port, creating a new robot in the simulator with an attached
 *  EmulatePioneer object for each client that connects.
 */
class RobotFactory
{
public:
  RobotFactory(const std::string& modelName, bool verbose = false, const char *listenAddress = NULL);
  ArSocket *open(int port, const char *listenAddress = NULL); ///< Open port and return socket, or NULL on error.
  void listen(); ///< never returns. run in a thread.
  bool runListenThread();
  virtual ~RobotFactory();
  inline std::string getModelName() const { return myModelName; }
  void setCommandsToIgnore(std::set<int> ig) {
    myCommandsToIgnore = ig;
  }
  void setVerbose(bool v) {
    myVerbose = v;
  }
protected:
  virtual RobotInterface *createRobot(const std::string& modelName, const std::string& requestedRobotName = "") = 0;
  virtual void log(const char *msg) { fputs(msg, stderr); }
private:
  std::string myModelName;
  int myPort;
  pthread_t myThread;
  ArSocket mySocket;
  std::set<int> myCommandsToIgnore;
  bool myVerbose;
  const char *myListenAddress;
};



#endif
