
#include <stdio.h>
#include "stage.h"

FILE *fp;

void fullcb(FILE *fp, size_t sz, size_t max)
{
    FILE *newfp;
    printf("full callback called for fp 0x%x, current size %u, max %u\n", fp, sz, max);
    stg_print_msg("Message inside callback");
    fflush(stdout);
    newfp = fopen("test2.log", "w");
    fclose(fp);
    fp = newfp;
    stg_set_log_file(fp);
    printf("Opened new file 0x%x\n", fp);
    stg_print_msg("New file");
    fflush(stdout);
}

int main( int argc, char* argv[] )
{ 
    stg_print_msg("Message");
    stg_print_warning("Warning");
    stg_print_error("Error");
    stg_set_log_file(fp = fopen("test.log", "w"));
    printf("fp is 0x%x\n", fp);
    stg_print_msg("Message");
    stg_set_log_file_max_size(30, &fullcb);
    stg_print_msg("1234567");
    stg_print_msg("8901234");
    stg_print_msg("5678901");
    stg_print_msg("2345678");
}
