/*
 *  linux/arch/arm/mach-ep93xx/time.c
 *
 *  Copyright (C) 2000-2001 Deep Blue Solutions
 *
 * (c) Copyright 2001 LynuxWorks, Inc., San Jose, CA.  All rights reserved.
 *  Copyright (C) 2002-2003 Cirrus Logic, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/io.h>

extern int (*set_rtc)(void);

static int ep93xx_set_rtc(void)
{
	outl( xtime.tv_sec, RTCLR );
	return 1;
}

static int ep93xx_rtc_init(void)
{
	outl( 0, RTCCR);
	outl( 0, RTCEOI);

	outl( xtime.tv_sec, RTCDR );

	set_rtc = ep93xx_set_rtc;

	return 0;
}

__initcall(ep93xx_rtc_init);



