
/*
 *  linux/drivers/usb/usb-ohci-ep93xx.c
 *
 *  The outline of this code was taken from Brad Parkers <brad@heeltoe.com>
 *  original OHCI driver modifications, and reworked into a cleaner form
 *  by Russell King <rmk@arm.linux.org.uk>.
 */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/usb.h>
#include <linux/pci.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <asm/pci.h>

#include "usb-ohci.h"

int __devinit
hc_add_ohci(struct pci_dev *dev, int irq, void *membase, unsigned long flags,
        const char *name, const char *slot_name);

extern void hc_remove_ohci(ohci_t *ohci);

static ohci_t *ep93xx_ohci;

static void __init ep93xx_ohci_configure(void)
{
	unsigned int usb_rst = 0;
	 __u32                   temp;
	/*
	 * Configure the power sense and control lines.  Place the USB
	 * host controller in reset.
	 */

	/*
	 * Now, carefully enable the USB clock, and take
	 * the USB host controller out of reset.
	 */
        writel (readl ((void *)IO_ADDRESS(SYSCON_PWRCNT)) | (1<< 28),(void *)IO_ADDRESS(SYSCON_PWRCNT));

}

static int __init ep93xx_ohci_init(void)
{
	int ret;
	/*
	 * Request memory resources.
	 */
//	if (!request_mem_region(_USB_OHCI_OP_BASE, _USB_EXTENT, "usb-ohci"))
//		return -EBUSY;

	ep93xx_ohci_configure();

	/*
	 * Initialise the generic OHCI driver.
	 */
	ret = hc_add_ohci((struct pci_dev *)1, IRQ_USH,
			  (void *)IO_ADDRESS(USB_BASE), 0,  "usb-ohci", "ep93xx");

//	if (ret)
//		release_mem_region(_USB_OHCI_OP_BASE, _USB_EXTENT);

#ifdef CONFIG_SA1100_BADGE4
	if (machine_is_badge4() && (!ret)) {
		/* found the controller, so now power the bus */
		badge4_set_5V(BADGE4_5V_USB, 1);
	}
#endif
	return ret;
}

static void __exit ep93xx_ohci_exit(void)
{
	hc_remove_ohci(ep93xx_ohci);

	/*
	 * Put the USB host controller into reset.
	 */

	/*
	 * Stop the USB clock.
	 */

	/*
	 * Release memory resources.
	 */
//	release_mem_region(_USB_OHCI_OP_BASE, _USB_EXTENT);

#ifdef CONFIG_SA1100_BADGE4
	if (machine_is_badge4()) {
		badge4_set_5V(BADGE4_5V_USB, 0);
	}
#endif
}

module_init(ep93xx_ohci_init);
module_exit(ep93xx_ohci_exit);
MODULE_LICENSE ("GPL");
