/*
 *  linux/arch/arm/mach-ep93xx/arch.c
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 * (c) Copyright 2002-2003 Cirrus Logic, Inc., Austin, Tx 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/init.h>

#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/memory.h>
#include <asm/arch/platform.h>

#include <asm/mach/arch.h>

extern void ep93xx_map_io(void);
extern void ep93xx_init_irq(void);

extern void convert_to_tag_list(struct param_struct *params, int mem_init);

/* Machine Descriptor created by macros in asm-arm/mach/arch.h
    bootmem: phys ram base, phys io base, virt io base
    bootpara: phys param base  */

#ifdef CONFIG_ARCH_EP9301
MACHINE_START(EP9301, "ep9301")
    MAINTAINER("Cirrus Logic; Technologic Systems")
    BOOT_MEM( SDRAM_START, 0x80000000, 0x80000000 )
    BOOT_PARAMS( SDRAM_START + 0x00000100 )
    MAPIO(ep93xx_map_io)
    INITIRQ(ep93xx_init_irq)
MACHINE_END
#endif

#ifdef CONFIG_ARCH_EP9312
MACHINE_START(EP9312, "ep9312")
    MAINTAINER("Cirrus Logic")
    BOOT_MEM( SDRAM_START, 0x80000000, 0x80000000 )
    BOOT_PARAMS( SDRAM_START + 0x00000100 )
    MAPIO(ep93xx_map_io)
    INITIRQ(ep93xx_init_irq)
MACHINE_END
#endif

#ifdef CONFIG_ARCH_EP9315
MACHINE_START(EP9315, "ep9315")
    MAINTAINER("Cirrus Logic")
    BOOT_MEM( SDRAM_START, 0x80000000, 0x80000000 )
    BOOT_PARAMS( SDRAM_START + 0x00000100 )
    MAPIO(ep93xx_map_io)
    INITIRQ(ep93xx_init_irq)
MACHINE_END
#endif
