/******************************************************************************
 * 
 *  File:	linux/drivers/char/ep93xx_usb_kbd.c
 *
 *  Purpose: Support for USB Keyboard hack ;) for a Cirrus Logic EP93xx
 *
 *  History:	
 *
 *  Limitations:
 *  Break and Print Screen keys not handled yet!
 *
 *
 *  Copyright 2003 Cirrus Logic Inc.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *   
 ******************************************************************************/

#include <linux/config.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <asm/keyboard.h>

#define EXTENDED_KEY 0x80

//=============================================================================
// KeyboardTranslate
//=============================================================================
// Translate the raw scan code to the default keymap for linux keyboards.
//=============================================================================
int KeyboardTranslate(unsigned char scancode, unsigned char * keycode, 
    char rawmode)
{
	//
    // Was this an extended key, if so ignore it for now.  Is this the right
	// thing to do, well I don't know but for now this works.  This will likely 
	// mean that the console will not know the difference between certain keys.
    //
    if(scancode & EXTENDED_KEY)
    {
		*keycode = 0;
		return 0;
    }
    else
    {
	    *keycode = scancode;
    }

    //
    // Indicate that this is a valid keycode.
    //
	return 1;
}

//=============================================================================
//=============================================================================
char UnexpectedUp(unsigned char xx)
{
    return 200;
}

//=============================================================================
//=============================================================================
static int SetKeycode(unsigned int xx, unsigned int yy)
{
    return -EINVAL;
}

//=============================================================================
//=============================================================================
static int GetKeycode(unsigned int xx)
{
    return -EINVAL;
}

//=============================================================================
//=============================================================================
static void SetLEDs(unsigned char xx)
{
}

//=============================================================================
// EP93XXUSBKbdInit
//=============================================================================
void __init EP93XXUSBKbdInit(void)
{
	k_unexpected_up = UnexpectedUp;
	k_setkeycode    = SetKeycode;
	k_getkeycode    = GetKeycode;
	
	k_translate     = KeyboardTranslate;
	k_leds          = SetLEDs;
}
