/*
 * main.c
 *
 *  Created on: Nov 22, 2009
 *      Author: brian
 */

#include <stdio.h>
#include <mpi.h>
#include "constants.h"
#include "root.h"
#include "child.h"

int main(int argc, char *argv[]) {
    int rank;
    int size;
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if (rank == 0)
    {
    	root(size);
    }
    else
    {
    	child(rank, size);
    }


    MPI_Finalize();
    return 0;
}


