/*
 * atod.c
 *
 *      Created: Dec 2010
 *      Author: Emily Mixon
 */

#include <stdio.h>
#include <pthread.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <rtai.h>
#include <rtai_lxrt.h>

int main( void ){

	FILE *file_ptr;
	int mem_ptr;
	char *AD_init;
	char *check_install;
	char *complete;
	RTIME period;
	RT_TASK *task1;
	unsigned long name = nam2num("task1");
	int num_samples = 2500;
	int count = 0;
	float buffer[2500];
	int bit_mask_install = 0x01;
	int bit_mask_complete = 0x80;
	int AD_installed;
	int AD_complete;
	short *read_value;
	char value[10];


	file_ptr = fopen("EMG.txt", "w");
	mem_ptr = open("/dev/mem", O_RDWR | O_SYNC);
	AD_init = (char *)mmap(0, getpagesize(), PROT_READ | PROT_WRITE, MAP_SHARED, mem_ptr, 0x10f00000);
	check_install = (char *)mmap(0, getpagesize(), PROT_READ | PROT_WRITE, MAP_SHARED, mem_ptr, 0x22400000);
	complete = (char *)mmap(0, getpagesize(), PROT_READ | PROT_WRITE, MAP_SHARED, mem_ptr, 0x10800000);
	read_value = (short *)AD_init;

	task1 = rt_task_init( name, 0, 512, 256);
	period = start_rt_timer( nano2count( 30000 ) );
	rt_task_make_periodic( task1, rt_get_time(), period );

	AD_installed = *(check_install) & bit_mask_install;

	if( AD_installed == 0x01 ){

		printf("AD installed\n");

		for( count=0; count<num_samples; count++){

			/*initialize the variables*/
			*AD_init = 0x48;

			/*wait for a period*/
			rt_task_wait_period();
			AD_complete = bit_mask_complete & *complete;

			while( AD_complete != 0x00 ){

				rt_task_wait_period();
				AD_complete = bit_mask_complete & *complete;
			}

			printf("count: %d AD_complete - %x\n", count, AD_complete);

			/*check for completeness*/
//			if( AD_complete == 0x00 ){

				/*read value from register*/
				buffer[count]= (float)(*read_value);


				/*save values to file*/
//				sprintf( value, "%6.4f\n", buffer[count] );
//				fwrite( value, sizeof(char), 7, file_ptr );

//			}



		}

		for( count=0; count<num_samples; count++){

			/*save values to file*/
			buffer[count]= buffer[count]*5/2048;
			sprintf( value, "%6.4f\n", buffer[count] );
			fwrite( value, sizeof(char), 7, file_ptr );

		}

		fclose( file_ptr );


	}

	rt_task_delete( task1 );
	stop_rt_timer();
	return 0;
}