/*
 * window_detect.c
 *
 *      Created: Dec 2010
 *      Author: Emily Mixon
 */

#include <stdio.h>
#include <math.h>
#include <gsl/gsl_sort.h>
#include <gsl/gsl_wavelet.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#define TOTAL_DATAPTS 2048
#define SAMPLE_RATE 2500
#define SIGNAL_WIDTH 500
#define MAX_DEPTH 11
#define T_NOISE 20
#define GA 1.5
#define SEL_SIGNAL 1

int main(void){

	/*initialize all variables*/
	int adj_den = ceil( 0.025*TOTAL_DATAPTS );
	int total_time = 1000*TOTAL_DATAPTS/SAMPLE_RATE;
	int extracted_datapts = ceil( TOTAL_DATAPTS*SIGNAL_WIDTH/total_time);
	FILE *f_signal;
	FILE *f_extracted;
	int i;
	int j;
	int index;
	int npts_noise;
	double max_noise;
	double max_eta;
	int max_eta_index;
	double threshold;
	int count_ones;
	double min_density;
	int leftden;
	int rightden;
	double gaps_threshold;
	int sums_act_before;
	int sums_act_after;
	int first_one[] = { 0,0 };
	int last_one[] = { 0,0 };
	int interval_begin;
	int interval_end;
	double center;
	int a;
	int b;
	char delimitor[]="\n";
	char value[15];

	double *signal_vector = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *act_interval  = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *final_act_interval = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *det_signal = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *det_vector = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *coeffs = malloc( TOTAL_DATAPTS * sizeof( double ) );
	double *temp_act_interval = malloc ( (TOTAL_DATAPTS+(2*adj_den)) * sizeof( double) );
	double *eta = malloc( TOTAL_DATAPTS * sizeof( double ) );
	gsl_wavelet *wvlt;
	gsl_wavelet_workspace *work;

	/*initialize wavelet parameters*/
	wvlt = gsl_wavelet_alloc( gsl_wavelet_bspline, 103);
	work = gsl_wavelet_workspace_alloc( TOTAL_DATAPTS*MAX_DEPTH );

	/*open file containing data set*/
	f_signal = fopen("test_emg_signal.txt", "r" );

	/*fill in time and signal vectors*/
	for(i=0; i<TOTAL_DATAPTS; i++){

		fscanf (f_signal, "%lg", &signal_vector[i]);
		coeffs[i] = signal_vector[i];

	}
	fclose( f_signal );

	/*get the wavelet coefficients
	/int gsl_wavelet_transform_forward (const gsl_wavelet * w, double * data, size_t stride, size_t n, gsl_wavelet_workspace * work)*/
	gsl_wavelet_transform_forward( wvlt, coeffs, 1, TOTAL_DATAPTS, work);

	/*find the maximum of the coefficients for each data entry - fill in eta*/
	/*For the forward transform, the elements of the original array are replaced by the discrete wavelet transform f_i -> w_{j,k} in a packed triangular storage layout, where j is the index of the level j = 0 ... J-1 and k is the index of the coefficient within each level, k = 0 ... (2^j)-1. The total number of levels is J = \log_2(n). The output data has the following form,

          (s_{-1,0}, d_{0,0}, d_{1,0}, d_{1,1}, d_{2,0}, ...,
            d_{j,k}, ..., d_{J-1,2^{J-1}-1}) */
	/*want to use the most detailed coefficients on the last level*/
	index = pow( 2,( MAX_DEPTH-1 ) )-1;
	for(i=index; i<TOTAL_DATAPTS; i+=2 ){

		eta[i] = coeffs[i];

		/*have 1024 coefficients, but 2048 data points->skip every other one(malloc to 0?), or copy value?*/
		/*either way - should fix when grab those around each detection point*/
		//if( (i+1)<TOTAL_DATAPTS ){
		//	eta[i+1] = coeffs[i];
		//}


	}

	/*find threshold value using coefficients of known noise */
	npts_noise = ceil( TOTAL_DATAPTS*T_NOISE/total_time);
	max_noise = 0;

	for( i=0; i<npts_noise; i++){

		max_noise = fmax( eta[i], max_noise );

	}

	threshold = GA * max_noise;

	/*find the detection vector*/
	count_ones=0;
	for( i=0; i<TOTAL_DATAPTS; i++){

		if( eta[i] > threshold ){
			det_vector[i] = 1;
			count_ones++;
		}

		else{
			det_vector[i] = 0;
		}

	}


	/*fill in temp_act__interval*/
	for(i=0; i<adj_den; i++){

		temp_act_interval[i]=0;
	}

	for(i=adj_den; i<(adj_den+TOTAL_DATAPTS); i++){

		temp_act_interval[i]=det_vector[i];
	}

	for(i=(adj_den+TOTAL_DATAPTS); i<(2*adj_den+TOTAL_DATAPTS); i++){

		temp_act_interval[i]=0;
	}

	/*remove isolated peaks due to noise*/
	min_density = 0.02*count_ones;
	leftden = 0;
	rightden = 0;

	for( i=adj_den; i<(adj_den+TOTAL_DATAPTS); i++){

		for( j=(i-adj_den); j<i; j++){

			if( temp_act_interval[j] == 1 ){
				leftden++;
				break;
			}
		}

		for( j=(i+1); j<(i+adj_den); j++){

			if( temp_act_interval[j] == 1 ){
				leftden++;
				break;
			}
		}

		if( (leftden>0) && (rightden>0) ){

			if( (leftden+rightden)>= min_density ){
				act_interval[(i-adj_den)] = 1;
			}

		}

	}

	/*eliminate small gaps where activation interval is supposed to be*/
	gaps_threshold = ceil( 0.015*TOTAL_DATAPTS );
	sums_act_before=0;
	sums_act_after=0;
	for( i=gaps_threshold; i<(TOTAL_DATAPTS-gaps_threshold); i++){

		for( j=(i-gaps_threshold); j<i; j++){

			if( act_interval[j] == 1 ){
				sums_act_before++;
			}

		}

		for( j=(i+1); j<(i+gaps_threshold); j++){

			if( act_interval[j] == 1){
				sums_act_after++;
			}
		}

		if( (act_interval[i]==0) && (sums_act_before>0) && (sums_act_after>0) ){

			act_interval[i]=1;

		}

	}

	/*perform twice in case of extra gaps*/
	for( i=gaps_threshold; i<(TOTAL_DATAPTS-gaps_threshold); i++){

		for( j=(i-gaps_threshold); j<i; j++){

			if( act_interval[j] == 1 ){
				sums_act_before++;
			}

		}

		for( j=(i+1); j<(i+gaps_threshold); j++){

			if( act_interval[j] == 1){
				sums_act_after++;
			}
		}

		if( (act_interval[i]==0) && (sums_act_before>0) && (sums_act_after>0) ){

			act_interval[i]=1;

		}

	}

	/*handle condition where there are 2 main signals - increase activation interval*/
	i=0;
	j=0;
	while( i<TOTAL_DATAPTS ){

		if( first_one[j] == 0 ){
			if( act_interval[i] == 1){
				first_one[j] = i;
			}
		}
		else{
			if( act_interval[i] == 0 ){
				last_one[j] = i-1;
				if( (last_one[j]-first_one[j]) >= extracted_datapts/5){
					if( j==0 ){
						j =1;
					}
					else{
						i = TOTAL_DATAPTS;
					}
				}
				else{
					first_one[j] = 0;
					last_one[j]  = 0;
				}
			}
		}
		i = i+1;
	}

	/*if 2 main parts are close enough - considered one main part*/
	if( (first_one[1] - last_one[0] ) > extracted_datapts/5){
		first_one[1]=0;
		last_one[1]=0;
	}

	if( first_one[0] != 0 ){
		interval_begin = first_one[0];
		if( first_one[1] == 0 ){
			interval_end = last_one[0];
		}
		else{
			interval_end = last_one[1];
		}

		if( interval_begin > (TOTAL_DATAPTS - extracted_datapts) ){
			interval_begin = TOTAL_DATAPTS - extracted_datapts;
		}

		if( ( interval_end==0 ) || (interval_end < (interval_begin+extracted_datapts) ) ){
			i = interval_begin+extracted_datapts;
			while( i > interval_begin){
				if( act_interval[i] == 1 ){
					interval_end = i;
					i = interval_begin;
				}
				i = i-1;
			}
		}
	}

	else{
		interval_begin = 0;
		interval_end = 0;
	}

	/*calculate center between first and last element*/
	center = ceil( (interval_begin+interval_end) / 2 );

	/*if no signal detected*/
	max_eta = 0;
	max_eta_index = 0;
	if( center == 0 ){

		for( i=0; i<extracted_datapts; i++){

			if( eta[i] > max_eta ){
				max_eta_index = i;
			}

			max_eta = fmax( eta[i], max_eta );

		}

	center = max_eta_index;
	}

	/*find the valid interval*/
	if( (center - ceil(extracted_datapts/2) ) < 1  ){

		a = 1;
		b = a + extracted_datapts - 1;
	}
	else{
		if( (center+ceil(extracted_datapts/2) ) > TOTAL_DATAPTS ){
			b = TOTAL_DATAPTS;
			a = b - extracted_datapts + 1;
		}
		else{
			a = center - ceil(extracted_datapts/2);
			b = a + extracted_datapts - 1;
		}
	}

	for( i=0; i<a; i++){

		final_act_interval[i]=0;
	}

	for( i=a; i<(a+extracted_datapts); i++){

		final_act_interval[i]=1;
	}

	for( i=b; i<TOTAL_DATAPTS; i++){

		final_act_interval[i]=0;
	}

	for( i=0; i<TOTAL_DATAPTS; i++){

		det_signal[i] = signal_vector[i] * final_act_interval[i];

	}

	/*save final extracted signal to file*/
	f_extracted = fopen( "extracted.txt", "w" );

	for( i=0; i<TOTAL_DATAPTS; i++ ){

		sprintf( value, "%10.4f\n", det_signal[i] );
		fwrite( value, sizeof(char), 11, f_extracted );

	}

	fclose( f_extracted );



	/*free space*/
	gsl_wavelet_free( wvlt );
	gsl_wavelet_workspace_free( work );
	free( signal_vector );
	free( act_interval );
	free( final_act_interval );
	free( det_signal );
	free( det_vector );
	free( coeffs );
	free( temp_act_interval );
	free( eta );
	return 0;

}