/*
 * ProjectClient.c
 * Daniel Walton
 */

#include <sys/types.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>



unsigned int fsize(char* file) //Gets size of file
{
    FILE * f = fopen(file, "r");
    fseek(f, 0, SEEK_END);
    return (unsigned int)ftell(f);
}

int count_characters(char str[200], char character) //Counts number of occurences of character
{
    int i;
    int count = 0;
    for(i=0; i < 200; i++)
    {
    	if(str[i]==character)
    	{
    		count++;
    	}
    }
    return count;
}

void SendCommand(int sock, char *op) //Sends the command operator to Server
{
	char command[20];
	int commandLength;

	strcpy(command, op);
	commandLength = strlen(command);
	send(sock, &commandLength, sizeof(int), 0);
	send(sock, &command, commandLength, 0);
}

void ViewFiles(int sock) //Lists files on Server
{
	char fileList[200];
	int count;
	int i;

	recv(sock, &count, sizeof(int), 0);
	for(i = 0; i <= count; i++)
	{
		recv(sock, fileList, 199, 0);
		printf("%s", fileList);
	}

}

void DownloadFile(int sock) //Downloads file off of Server
{
	char fullLocRec[200];
	char fullLocSave[200];
	char recData[4096];
	FILE * fr;
	int fileSentSize;
	int fileNameSize;

	printf("Enter filename to receive: ");
	scanf("%s",fullLocRec);
	printf("Enter saved location: ");
	scanf("%s",fullLocSave);

	fileNameSize = strlen(fullLocRec);
	fileNameSize++;
	send(sock, &fileNameSize, sizeof(int),0);
	send(sock, fullLocRec, fileNameSize, 0);
	recv(sock, &fileSentSize,sizeof(int), 0);
	fr = fopen(fullLocSave,"w+");
	while(4096 < fileSentSize)
	{
		fileSentSize-=recv(sock, recData, 4096, 0);
		fwrite(recData, 1,4096,fr);

	}
	recv(sock, recData, fileSentSize, 0);
	fwrite(recData, 1,fileSentSize,fr);
	fclose(fr);
}

void UploadFile(int sock) //Uploads file to Server
{
	char fullLoc[200];
	char tempFullLoc[200];
	char *locName;
	FILE * fr;
	int slashCount;
	int nameSize;
	int fileSize;

	printf("Enter filename to send: ");
	scanf("%s",fullLoc);
	strcpy(tempFullLoc,fullLoc);
	slashCount = count_characters(tempFullLoc, '/');
	locName = strtok(tempFullLoc,"/");
	while(1)
	{
		char * temp = strtok(NULL,"/");
		if(temp == NULL){
			break;
		}
		locName = temp;
	}
	fileSize = fsize(fullLoc);
	send(sock, &fileSize, sizeof(int), 0);
	nameSize = strlen(locName);
	nameSize++;
	send(sock, &nameSize, sizeof(int),0);
	send(sock, locName, nameSize, 0);
	fr = fopen(fullLoc,"r");
	char dat[fileSize];
	int i = 0;
	while(!feof(fr))
	{
		dat[i]=fgetc(fr);
		i++;
	}
	fclose(fr);
	send(sock, dat, i-1, 0);
}

void DeleteFile(int sock) //Deletes file off of Server
{
	char locName[200];
	int nameSize;

	printf("Enter file to delete: ");
	scanf("%s", locName);
	strcpy(locName, locName);
	nameSize = strlen(locName);
	nameSize++;
	send(sock, &nameSize, sizeof(int),0);
	send(sock, locName, nameSize, 0);
}

int main(void)
{
	char operation[20];
	char cUp[20];
	char cDo[20];
	char cLi[20];
	char cDe[20];
	char cEx[20];
	int sock;
	int success;
	struct hostent *host;
	struct sockaddr_in serAdd;

	host = gethostbyname("10.3.52.2"); //IP of Server
	sock = socket(AF_INET, SOCK_STREAM, 0);
	serAdd.sin_family = AF_INET;
	serAdd.sin_port = htons(1948); //Port number
	serAdd.sin_addr = *((struct in_addr *)host->h_addr);
	bzero(&(serAdd.sin_zero),8);
	connect(sock, (struct sockaddr *)&serAdd, sizeof(struct sockaddr));

	strcpy(cUp, "UPLOAD"); //Command strings
	strcpy(cDo, "DOWNLOAD");
	strcpy(cLi, "LIST");
	strcpy(cDe, "DELETE");
	strcpy(cEx, "EXIT");

	recv(sock, &success, sizeof(int), 0); //Check number of clients on server
	if(success == 1)
	{
		printf("Client Limit Reached\n");
		return 1;
	}
	while(1) //Prompt user
	{
		printf("Enter command: ");
		scanf("%s", operation);
		if(strcmp(operation, cUp)==0)
		{
			SendCommand(sock, cUp);
			UploadFile(sock);
		}
		else if(strcmp(operation, cDo)==0)
		{
			SendCommand(sock, cDo);
			DownloadFile(sock);
		}
		else if(strcmp(operation, cLi)==0)
		{
			SendCommand(sock, cLi);
			ViewFiles(sock);
		}
		else if(strcmp(operation, cDe)==0)
		{
			SendCommand(sock, cDe);
			DeleteFile(sock);
		}
		else if(strcmp(operation, cEx)==0)
		{
			SendCommand(sock, cEx);
			break;
		}
	}
	close(sock);
	return 1;
}
