/*
 * ProjectServer.c
 * Daniel Walton
 */

#include <sys/types.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>

#define MAX_CLIENTS 10 //Maximum number of clients (arbitrary)

unsigned int fsize(char* file) //Find file size
{
    FILE * f = fopen(file, "r");
    fseek(f, 0, SEEK_END);
    return (unsigned int)ftell(f);
}

void WaitTurn(char file[200]) //Wait turn for file
{
	char tempFile[200];
	char com[200];
	int ret;
	strcpy(file, "LOCK");
	while(1)
	{
		sprintf(tempFile, "mkdir %s  >& /dev/null", file);
		ret = system(tempFile);
		if(ret == 0)
		{
			sprintf(com,"rmdir %s >& /dev/null",file);
			ret = system(com);
			break;
		}
		sprintf(com,"rmdir %s >& /dev/null",file);
		ret = system(com);
		break;
	}
}

void LockFile(char file[200]) //Create a lock file
{
	char com[200];
	int ret;
	strcpy(file, "LOCK");
	sprintf(com,"rmdir %s >& /dev/null",file);
			//sprintf(com, "rmdir %s &", file);
			ret = system(com);
	sprintf(com,"mkdir %s >& /dev/null",file);
	ret = system(com);
}

void UnlockFile(char file[200]) //Delete a lock file
{
	char com[200];
	int ret;
	strcpy(file, "LOCK");
	sprintf(com,"rmdir %s >& /dev/null",file);
	ret = system(com);
}

int AssignId(int idArr[MAX_CLIENTS]) //Assign a client id number
{
	int i;
	for(i = 0; i < MAX_CLIENTS; i++)
	{
		if(idArr[i]==0)
		{
			return i;
		}
	}
	return MAX_CLIENTS;
}

int compStrings(char strA[20], char strB[20], int length) //Compare strings
{
	int i;
	for(i = 0; i < length; i++)
	{
		if(strA[i] != strB[i])
			return 1;
	}
	return 0;
}

void TransferFileToServer(int connectFd, int size, char * location, int id) //Upload file to server
{
	char recData[4096];
	char fullLoc[200];
	char temp[200];
	FILE *fr;
	strcpy(fullLoc, "/home/ddwxtd/ServerFiles/");
	sprintf(fullLoc,"%s%s",fullLoc,location);
	strcpy(temp, fullLoc);
	WaitTurn(temp);
	LockFile(temp);
	fr = fopen(fullLoc,"w+");

	while(4096 < size)
	{
		size-=recv(connectFd, recData, 4096, 0);
		fwrite(recData, 1,4096,fr);

	}
	recv(connectFd, recData, size, 0);
	fwrite(recData, 1,size,fr);
	fclose(fr);
	UnlockFile(temp);
	printf("Client %d Uploaded %s\n", id, fullLoc);
}

void DeleteFile(int connectFd, int id) //Delete file from server
{
	char fullLoc[200];
	char tempLoc[200];
	char temp[200];
	char com[200];
	int ret;
	int nameSize;

	recv(connectFd, &nameSize, sizeof(int), 0);
	recv(connectFd, &tempLoc, nameSize, 0);
	sprintf(fullLoc, "/home/ddwxtd/ServerFiles/%s",tempLoc);
	strcpy(temp, fullLoc);
	WaitTurn(temp);
	LockFile(temp);
	sprintf(com,"rm -rf /home/ddwxtd/ServerFiles/%s", tempLoc);
	ret = system(com);
	UnlockFile(temp);
	printf("Client %d Deleted %s\n", id, fullLoc);
}

void ListFiles(int connectFd, int id) //List all files in server directory
{
	char fileList[200];
	char fileList1[200];
	FILE *fr;
	int count = 0;

	sprintf(fileList1,"ls -la /home/ddwxtd/ServerFiles > client_%d", id);
    system(fileList1); //pipe ls -la system call into file

    sprintf(fileList1, "client_%d", id);
	fr = fopen(fileList1, "r");

	while(fgets(fileList, 199,fr) != NULL)
	{
		count++;
	}
	fclose(fr);
	send(connectFd, &count, sizeof(int),0);
	sprintf(fileList1, "client_%d", id);
	fr = fopen(fileList1, "r");
	while(fgets(fileList, 199,fr) != NULL)
	{
		send(connectFd, fileList, 200,0);
	}
	fclose(fr);
	sprintf(fileList1, "client_%d", id);
	remove(fileList1);
}

void DownloadToClient(int connectFd, int id) //Download file to client
{
	char tempLoc[200];
	char fullLoc[200] = "/home/ddwxtd/ServerFiles/";
	char temp[200];
	char fullFullLoc[200];
	FILE *fr;
	int nameSize;
	int sendFileSize;

	recv(connectFd, &nameSize, sizeof(int), 0);
	recv(connectFd, &tempLoc, nameSize, 0);
	sprintf(fullFullLoc,"%s%s",fullLoc,tempLoc);
	strcpy(temp, fullFullLoc);
	WaitTurn(temp);
	LockFile(temp);
	sendFileSize = fsize(fullFullLoc);
	send(connectFd, &sendFileSize, sizeof(int), 0);
	fr = fopen(fullFullLoc,"r");
	char dat[sendFileSize];
	int i = 0;
	while(!feof(fr))
	{
		dat[i]=fgetc(fr);
		i++;
	}
	fclose(fr);
	send(connectFd, dat, i-1, 0);
	UnlockFile(temp);
	printf("Client %d Downloaded %s\n", id, fullFullLoc);
}

void UploadToServer(int connectFd, int id) //Upload to Server
{
	char location[200];
	int fileSentSize;
	int nameSize;

	recv(connectFd, &fileSentSize,sizeof(int), 0);
	recv(connectFd, &nameSize, sizeof(int),0);
	recv(connectFd, &location, nameSize, 0);
	TransferFileToServer(connectFd, fileSentSize, location, id);
}

void ServerProcess(int connectFd, int id) //Main process for server
{
	char cUp[20];
	char cDo[20];
	char cLi[20];
	char cEx[20];
	char cDe[20];
	int commandLength;
	char command[256];


	strcpy(cUp, "UPLOAD"); //Command strings
	strcpy(cDo, "DOWNLOAD");
	strcpy(cLi, "LIST");
	strcpy(cDe, "DELETE");
	strcpy(cEx, "EXIT");
	while(1)
	{
		recv(connectFd, &commandLength, sizeof(int), 0);
		recv(connectFd, command, commandLength, 0);
		if(compStrings(command, cUp, commandLength)==0)
		{
			printf("Client %d Uploading...\n", id);
			UploadToServer(connectFd, id);
		}
		if(compStrings(command, cDo, commandLength)==0)
		{
			printf("Client %d Downloading...\n", id);
			DownloadToClient(connectFd, id);
		}
		if(compStrings(command, cLi, commandLength)==0)
		{
			printf("Client %d Listing...\n", id);
			ListFiles(connectFd, id);
		}
		if(compStrings(command, cDe, commandLength)==0)
		{
			printf("Client %d Deleting...\n", id);
			DeleteFile(connectFd, id);
		}
		if(compStrings(command, cEx, commandLength)==0)
		{
			printf("Client %d disconnected\n", id);
			close(connectFd);
			exit(0);
			break;
		}
	}
}

int main(void)
{
	char sysCom[200];
	int sock;
	int sinSize;
	int connectFd;
	int val = 1;
	int id;
	int i;
	int idArr[MAX_CLIENTS];
	int success;
	pid_t clients;
	struct sockaddr_in serAdd;
	struct sockaddr_in cliAdd;


	for(i = 0; i < MAX_CLIENTS; i++) //Clear id use
	{
		idArr[i] = 0;
	}
	sprintf(sysCom,"rm -rf /home/ddwxtd/ServerFiles"); //remove and create server folder
	system(sysCom);
	sprintf(sysCom,"mkdir /home/ddwxtd/ServerFiles");
	system(sysCom);
	sock = socket(AF_INET, SOCK_STREAM,0);
	setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(int));
	serAdd.sin_family = AF_INET;
	serAdd.sin_port = htons(1948); //Port number
	serAdd.sin_addr.s_addr = INADDR_ANY;
	bzero(&(serAdd.sin_zero),8);
	bind(sock, (struct sockaddr *) &serAdd, sizeof(struct sockaddr));
	listen(sock, 5);
	while(1)
	{
		connectFd = accept(sock, (struct sockaddr *) &cliAdd, &sinSize);
		id = AssignId(idArr);
		if(id < MAX_CLIENTS) //put id number in use
		{
			idArr[id] = 1;
		}
		clients = fork();
		if(clients == 0 && id != MAX_CLIENTS) //check if fork success and id valid
		{
			success = 0;
			close(sock);
			printf("Client %d connected\n", id);
			send(connectFd, &success, sizeof(int), 0);
			ServerProcess(connectFd,id);
		}
		else if(clients == 0 && id == MAX_CLIENTS)
		{
			success = 1;
			send(connectFd, &success, sizeof(int), 0);
			exit(0);
		}
		close(connectFd);

	}
	return 1;
}
