//
// Written by Bernard A Naumann
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <rtai.h>
#include <rtai_lxrt.h>

#define PORT 2000
#define startCash 100
#define startUnits 20
#define seller 0
#define buyer 1

//remove offers that are to old or that have been beaten by 10+ other offers
		//ensures limited amount of offers being sent around


typedef struct offer{
	int offerMadeBy;
	int offerMakerRole;
	int cash;
	int units;
}offer;

typedef struct message{
	char m[10];
	int ip;
	int vote;
	int cash;
	int units;
}message;

typedef struct player{
	int ip;
	int role;
	int cash;
	int units;
}player;

int sockd;
struct sockaddr_in din;
message marray[7];

void determineRoles(int, int, player *);
void determineWinners(int, int);
void timer(void *var);
void handleOffers(void *var);

int main(void)
{
	system("clear");
	pthread_t f1_thread, f2_thread;
	player *playerArray;
	int numPlayers, numSellers, numBuyers;
	int i, tmp, localip, clock;
	int iOptval = 1;
	int iOptlen = sizeof(int);
	struct sockaddr_in sin;
	char* buffer;
	char* temp;

	fflush(stdin);
	printf("Starting a new game!\n");
	printf("How many players are participating?\n");
	fflush(stdout);
	scanf("%d", &numPlayers);


	//set up socket to broadcast message to everyone after number of players is entered
	//create socket
	sockd = socket(AF_INET, SOCK_DGRAM, 0);
	(sockd < 0) ? printf("ERROR: could not open socket\n") : 0;

	//client side
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(PORT);

	din.sin_family = AF_INET;
	din.sin_addr.s_addr = inet_addr("10.3.52.255");		//everyone in lab
	din.sin_port = htons(PORT);

	tmp = setsockopt(sockd, SOL_SOCKET, SO_BROADCAST, (char *)&iOptval, iOptlen);
	(tmp == -1) ? printf("ERROR socket could not set options\n") : 0;

	//bind socket
	tmp = bind(sockd, (struct sockaddr *) &sin, sizeof(sin));
	(tmp == -1) ? printf("ERROR socket could not bind\n") : 0;

	//find own ip
	buffer = malloc(15*sizeof(char));
	gethostname(buffer, 15);

	temp = strtok(buffer, "-");
	temp = strtok(NULL, "-");
	localip = atoi(temp);

	free(buffer);

	numBuyers = numPlayers/2;
	numSellers = numPlayers - numBuyers;

	playerArray = (player *)malloc(numPlayers*sizeof(player));
	for(i = 0; i < numPlayers; i++)
		playerArray[i].role = -1;

	for(i = 0; i < 3; i++){
		marray[i+1].ip = -1;
		marray[i+1].vote = -1;
		marray[i+1].cash = 0;
		marray[i+1].units = 0;

		marray[i+4].ip = -1;
		marray[i+4].vote = -1;
		marray[i+4].cash = 0;
		marray[i+4].units = 0;
	}

	strcpy(marray[0].m, "rolevote");
	marray[0].ip = -1;
	marray[0].vote = -1;
	marray[0].cash = 0;
	marray[0].units = 0;

	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
	determineRoles(numSellers, numBuyers, playerArray);

	//multiple tasks start here
	clock = start_rt_timer(nano2count(100000000));
	pthread_create(&f1_thread, NULL, (void *) &timer, (void *) &clock);		//game timer
	pthread_create(&f2_thread, NULL, (void *) &handleOffers, (void *) &clock);		//update offers


	//end threads and game conclusion
	pthread_join(f1_thread, NULL);
	pthread_join(f2_thread, NULL);

	determineWinners(numSellers, numBuyers);

	free(playerArray);

	close(sockd);

	printf("game is over\n");
	return(0);
}

void handleOffers(void *var)
{
	int *clockt;
	int realclock, i;
	clockt = (int *)var;
	realclock = *clockt;
	message m;

	strcpy(marray[0].m, "begin");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
	printf("The game has begun!\n");

	for(i = 0; i < 3; i++){
		marray[i+1].ip = -1;
		marray[i+1].vote = buyer;
		marray[i+1].units = 0;
		marray[i+1].cash = 0;

		marray[i+4].ip = -1;
		marray[i+4].vote = seller;
		marray[i+4].units = 0;
		marray[i+4].cash = 0;
	}

	RT_TASK *task1 = rt_task_init(nam2num("task1"), 1, 512, 256);
	rt_task_make_periodic(task1, rt_get_time(), 2*realclock);

	while(1){
		recv(sockd, &marray, 7*sizeof(message), 0);

		if(strcmp(marray[0].m, "mkoffer") == 0){
			m = marray[0];
			if(marray[0].vote == buyer){
				if(marray[3].ip != -1){
					strcpy(marray[0].m, "reject");
					marray[0].ip = marray[3].ip;
					marray[0].cash = marray[3].cash;
					marray[0].units = marray[3].units;
					sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
				}
				marray[3] = marray[2];
				marray[2] = marray[1];
				marray[1] = m;
			}
			else{
				if(marray[6].ip != -1){
					strcpy(marray[0].m, "reject");
					marray[0].ip = marray[6].ip;
					marray[0].cash = marray[6].cash;
					marray[0].units = marray[6].units;
					sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
				}
				marray[6] = marray[5];
				marray[5] = marray[4];
				marray[4] = m;
			}
		}
		else if(strcmp(marray[0].m, "acoffer") == 0){
			strcpy(marray[0].m, "yesorno");
			if(marray[marray[0].ip].ip == -1){
				marray[0].vote = 1;}
			else{
				marray[0].vote = 0;
				marray[marray[0].ip].ip = -1;
				marray[marray[0].ip].cash = 0;
				marray[marray[0].ip].units = 0;
			}
			sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
		}
		else if(strcmp(marray[0].m, "endgame") == 0){
			pthread_exit(0);
		}
		rt_task_wait_period();
	}
}

void timer(void *var)		//should probably control scheduled updates to users
{
	int counter = 1;
	int *clockt;
	int realclock;
	clockt = (int *)var;
	realclock = *clockt;

	RT_TASK *task2 = rt_task_init(nam2num("task2"), 1, 512, 256);
	rt_task_make_periodic(task2, rt_get_time(), 10*realclock);

	strcpy(marray[0].m, "refresh");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	while(counter < 301){
		rt_task_wait_period();
		counter++;
		if(counter % 30 == 0){
			strcpy(marray[0].m, "refresh");
			sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
		}
	}

	strcpy(marray[0].m, "endgame");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	pthread_exit(0);
}

void determineRoles(int numSellers, int numBuyers, player *playerArray)
{
	int numPlayers = numSellers + numBuyers;
	int i, vote;
	int ip = 0;
	int sellCount = 0;
	int buyCount = 0;

	for(i = 0; i < numPlayers; i++){
		//receive message from players requesting type

		recv(sockd, &marray, 7*sizeof(message), 0);
		while(strcmp(marray[0].m, "wantrole") != 0)
			recv(sockd, &marray, 7*sizeof(message), 0);

		vote = marray[0].vote;
		ip = marray[0].ip;

		if(vote == 1){		//buyer votes
			if(buyCount < numBuyers){
				playerArray[i].ip = ip;
				playerArray[i].role = buyer;
				playerArray[i].cash = 0;
				playerArray[i].units = startUnits;
				buyCount++;}
			else{
				playerArray[i].ip = ip;
				playerArray[i].role = seller;
				playerArray[i].cash = startCash;
				playerArray[i].units = 0;
				sellCount++;}}
		else{				//seller votes and invalid votes
			if(sellCount < numSellers){
				playerArray[i].ip = ip;
				playerArray[i].role = seller;
				playerArray[i].cash = startCash;
				playerArray[i].units = 0;
				sellCount++;}
			else{
				playerArray[i].ip = ip;
				playerArray[i].role = buyer;
				playerArray[i].cash = 0;
				playerArray[i].units = startUnits;
				buyCount++;}}

		marray[0].ip = ip;
		if(playerArray[i].role == 1){
			marray[0].cash = startCash;
			marray[0].units = 0;
		}
		else{
			marray[0].units = startUnits;
			marray[0].cash = 0;
		}

		marray[0].vote = playerArray[i].role;
		strcpy(marray[0].m, "yourrole");

		//send cash and units as well;
		sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	}
}

void determineWinners(int numSellers, int numBuyers)
{
	int numPlayers = numSellers + numBuyers;
	int i;
	player topSeller;
	player topBuyer;

	topSeller.ip = -1;
	topSeller.role = seller;
	topSeller.cash = 0;
	topSeller.units = 0;

	topBuyer.ip = -1;
	topBuyer.role = buyer;
	topBuyer.cash = 0;
	topBuyer.units = 0;

	marray[0].vote = topBuyer.role;
	marray[0].ip = topBuyer.ip;
	marray[0].cash = topBuyer.cash;
	marray[0].units = topBuyer.units;
	strcpy(marray[0].m, "gameover");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	for(i = 0; i < numPlayers; i++){
		recv(sockd, &marray, 7*sizeof(message), 0);
		while(strcmp(marray[0].m, "whowins") != 0)
			recv(sockd, &marray, 7*sizeof(message), 0);

		if(marray[0].vote == buyer){
			if(marray[0].units > topBuyer.units){
				topBuyer.ip = marray[0].ip;
				topBuyer.cash = marray[0].cash;
				topBuyer.units = marray[0].units;}
			else if(marray[0].units == topBuyer.units){
				if(marray[0].cash > topBuyer.cash){
					topBuyer.ip = marray[0].ip;
					topBuyer.cash = marray[0].cash;
					topBuyer.units = marray[0].units;}}}
		else{
			if(marray[0].cash > topSeller.cash){
				topSeller.ip = marray[0].ip;
				topSeller.cash = marray[0].cash;
				topSeller.units = marray[0].units;}
			else if(marray[0].cash == topSeller.cash){
				if(marray[0].units > topSeller.units){
					topSeller.ip = marray[0].ip;
					topSeller.cash = marray[0].cash;
					topSeller.units = marray[0].units;}}}

		strcpy(marray[0].m, "whonext");
	}

	printf("The winners are:\n");
	printf("     Buyer winner is: User %d with %d units and %d cash!\n", topBuyer.ip, topBuyer.units, topBuyer.cash);
	printf("     Seller winner is: User %d with %d units and %d cash!\n", topSeller.ip, topSeller.units, topSeller.cash);

	marray[0].vote = topBuyer.role;
	marray[0].ip = topBuyer.ip;
	marray[0].cash = topBuyer.cash;
	marray[0].units = topBuyer.units;
	strcpy(marray[0].m, "buyerw");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	marray[0].vote = topSeller.role;
	marray[0].ip = topSeller.ip;
	marray[0].cash = topSeller.cash;
	marray[0].units = topSeller.units;
	strcpy(marray[0].m, "sellerw");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

}

