//
// Written by Bernard A Naumann
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation.
//


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 2000
#define startCash 100
#define startUnits 20
#define seller 0
#define buyer 1

typedef struct offer{
	int offerMadeBy;
	int offerMakerRole;
	int cash;
	int units;
}offer;

typedef struct message{
	char m[10];
	int ip;
	int vote;
	int cash;
	int units;
}message;

typedef struct player{
	int ip;
	int role;
	int cash;
	int units;
}player;

int sockd, hostip, localip;
struct sockaddr_in din;
message marray[7];

void determineRole(void);
void determineWinners(player);
player makeOffer(player);
player acceptOffer(player);
void screenRefresh(player);

int main(void)
{
	system("clear");
	int tmp, role, i;
	int iOptval = 1;
	int iOptlen = sizeof(int);
	struct sockaddr_in sin;
	char* buffer;
	char* temp;
	int todo;
	player user;

	fflush(stdin);
	printf("Starting a new game!\n");

	//set up socket to broadcast message to everyone after number of players is entered
	//create socket
	sockd = socket(AF_INET, SOCK_DGRAM, 0);
	(sockd < 0) ? printf("ERROR: could not open socket\n") : 0;

	//client side
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(PORT);

	din.sin_family = AF_INET;
	din.sin_addr.s_addr = inet_addr("10.3.52.255");		//everyone in lab
	din.sin_port = htons(PORT);

	tmp = setsockopt(sockd, SOL_SOCKET, SO_BROADCAST, (char *)&iOptval, iOptlen);
	(tmp == -1) ? printf("ERROR socket could not set options\n") : 0;

	//bind socket
	tmp = bind(sockd, (struct sockaddr *) &sin, sizeof(sin));
	(tmp == -1) ? printf("ERROR socket could not bind\n") : 0;


	buffer = malloc(15*sizeof(char));
	gethostname(buffer, 15);

	temp = strtok(buffer, "-");
	temp = strtok(NULL, "-");
	localip = atoi(temp);
	printf("LocalIP = %d\n", localip);

	recv(sockd, &marray, 7*sizeof(message), 0);
	while(strcmp(marray[0].m, "rolevote") != 0)
		recv(sockd, &marray, 7*sizeof(message), 0);

	determineRole();
	role = marray[0].vote;
	if(role == 1){
		user.role = role;
		user.cash = marray[0].cash;
		user.units = marray[0].units;
		printf("You are a buyer with %d units and %d cash\n", user.units, user.cash);
	}
	else{
		user.role = role;
		user.units = marray[0].units;
		user.cash = marray[0].cash;
		printf("You are a seller with %d units and %d cash\n", user.units, user.cash);
	}

	marray[0].ip = -1;
	for(i = 0; i < 3; i++){
		marray[i+1].ip = -1;
		marray[i+1].vote = buyer;
		marray[i+1].units = 0;
		marray[i+1].cash = 0;

		marray[i+4].ip = -1;
		marray[i+4].vote = seller;
		marray[i+4].units = 0;
		marray[i+4].cash = 0;
	}

	recv(sockd, &marray, 7*sizeof(message), 0);
	while(strcmp(marray[0].m, "begin") != 0)
		recv(sockd, &marray, 7*sizeof(message), 0);

	while(strcmp(marray[0].m, "gameover") != 0){
		if(strcmp(marray[0].m, "refresh") == 0){
			screenRefresh(user);
			printf("Would you like to make/accept an offer at this time?\n");
			printf("  (Enter 0 for make/1 for accept/2 for no)\n");
			fflush(stdout);
			scanf("%d", &todo);
			printf("your answer: %d\n", todo);
			if(todo == 0){
				user = makeOffer(user);
			}
			else if(todo == 1){
				user = acceptOffer(user);
			}
		}
		else if(strcmp(marray[0].m, "reject") == 0){
			if(marray[0].ip == localip){
				if(user.role == buyer){
					user.cash += marray[0].cash;
				}
				else{
					user.units += marray[0].units;
				}
			}
		}

		recv(sockd, &marray, 7*sizeof(message), 0);
	}

	determineWinners(user);
	printf("\nGame is over, thanks for playing\n\n");

	free(buffer);
	return(0);
}

void determineRole(void)
{
	int vote;
	printf("Vote for what you want to be!\n");
	printf("Vote 1 for buyer or 0 for seller\n");
	scanf("%d", &vote);

	marray[0].vote = vote;
	marray[0].ip = localip;
	strcpy(marray[0].m, "wantrole");

	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	int loopexit = 1;
	do{
		recv(sockd, &marray, 7*sizeof(message), 0);
		if(strcmp(marray[0].m, "yourrole") == 0){
			if(marray[0].ip == localip){
				loopexit = 0;
			}
		}
	}while(loopexit);
}

void determineWinners(player user)
{
	player topBuyer;
	player topSeller;

	marray[0].cash = user.cash;
	marray[0].vote = user.role;
	marray[0].units = user.units;
	marray[0].ip = localip;
	strcpy(marray[0].m, "whowins");

	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));

	recv(sockd, &marray, 7*sizeof(message), 0);
	while(strcmp(marray[0].m, "buyerw") != 0)
			recv(sockd, &marray, 7*sizeof(message), 0);

	topBuyer.cash = marray[0].cash;
	topBuyer.units = marray[0].units;
	topBuyer.ip = marray[0].ip;
	topBuyer.role = marray[0].vote;

	recv(sockd, &marray, 7*sizeof(message), 0);
	while(strcmp(marray[0].m, "sellerw") != 0)
		recv(sockd, &marray, 7*sizeof(message), 0);

	topSeller.cash = marray[0].cash;
	topSeller.units = marray[0].units;
	topSeller.ip = marray[0].ip;
	topSeller.role = marray[0].vote;

	printf("The winners are:\n");
	printf("     Buyer winner is: User %d with %d units and %d cash!\n", topBuyer.ip, topBuyer.units, topBuyer.cash);
	printf("     Seller winner is: User %d with %d units and %d cash!\n", topSeller.ip, topSeller.units, topSeller.cash);
}

player acceptOffer(player user)
{
	int offer;
	message m;

	printf("Which offer would you like to accept?\n");
	scanf("%d", &offer);

	offer = offer-1;

	if(user.role == buyer){
		if(marray[offer + 4].cash > user.cash){
			printf("You do not have enough cash to accept that offer\n");
		}
		else{
			strcpy(marray[0].m, "acoffer");
			marray[0].ip = offer + 4;
			sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
			m = marray[offer+4];

			while(strcmp(marray[0].m, "yesorno") != 0)
				recv(sockd, &marray, 7*sizeof(message), 0);

			if(marray[0].vote == 0){
				printf("Offer accepted\n");
				user.cash = user.cash - m.cash;
				user.units = user.units + m.units;
			}
			else{
				printf("Somebody beat you to the offer, sorry\n");
			}
		}
	}
	else{
		if(marray[offer + 1].units > user.units){
			printf("You do not have enough cash to accept that offer\n");
		}
		else{
			strcpy(marray[0].m, "acoffer");
			marray[0].ip = offer+1;
			sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
			m = marray[offer+1];

			while(strcmp(marray[0].m, "yesorno") != 0)
				recv(sockd, &marray, 7*sizeof(message), 0);

			if(marray[0].vote == 0){
				printf("Offer accepted\n");
				user.cash = user.cash + m.cash;
				user.units = user.units - m.units;
			}
			else{
				printf("Somebody beat you to the offer, sorry\n");
			}
		}
	}


	return(user);
}

player makeOffer(player user)
{
	int units, cash;

	system("clear");
	marray[0].ip = localip;
	marray[0].vote = user.role;

	if(user.role == buyer){
		printf("How many units do you want to buy?\n");
		scanf("%d", &units);
		marray[0].units = units;

		printf("How much money would you spend for that amount of units?\n");
		scanf("%d", &cash);
		while(user.cash < cash){
			printf("You do not have that much money.\n");
			printf("How much money would you spend for that amount of units?\n");
			scanf("%d", &cash);
		}
		marray[0].cash = cash;
		user.cash -= cash;}
	else{
		printf("How many units do you want to sell?\n");
		scanf("%d", &units);
		while(user.units < units){
			printf("You do not have that many units.\n");
			printf("How many units do you want to sell?\n");
			scanf("%d", &units);
		}
		marray[0].units = units;

		printf("How much money do you expect for that amount of units?\n");
		scanf("%d", &cash);
		marray[0].cash = cash;
		user.units -= units;
	}

	strcpy(marray[0].m, "mkoffer");
	sendto(sockd, &marray, 7*sizeof(message), 0, (struct sockaddr *) &din, sizeof(din));
	printf("Offer submitted\n");

	return(user);
}

void screenRefresh(player user)
{
	system("clear");
	int i;

	printf("You have:  %d Units\n", user.units);
	printf("           %d Cash\n\n", user.cash);
	if(user.role == buyer){
		printf("Offers available for you to accept are:\n");
		for(i = 0; i < 3; i++){
			printf("   %d)  %d Units for %d of your cash\n", i+1, marray[i+4].units, marray[i+4].cash);
		}
		printf("\nYour competition is offering:\n");
		for(i = 0; i < 3; i++){
			printf("     %d cash for %d units\n", marray[i+1].cash, marray[i+1].units);
		}
	}
	else{
		printf("Offers available for you to accept are:\n");
		for(i = 0; i < 3; i++){
			printf("   %d)  %d cash for %d of your units\n", i+1, marray[i+1].cash, marray[i+1].units);
		}
		printf("\nYour competition is offering:\n");
		for(i = 0; i < 3; i++){
			printf("     %d Units for %d cash\n", marray[i+4].units, marray[i+4].cash);
		}
	}
}
