#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <rtai.h>
#include <rtai_lxrt.h>

#define RTT_PERIOD 1000000 //1 ms = 1,000,000 ns

typedef struct{
	float gallons;
	float t_pressure;
	float distance;
	float lat_g;
	float vert_g;
	float speed;
	float lifetime;
	float temp;
	float altitude;
} raw;

typedef struct{
	float gallons;
	float distance;
	float temp;
	float speed;
	float mpg;
} fifo_data;

typedef struct{
	RTIME period;
	RT_TASK *rttReceive;
	RT_TASK *rttOperate;
	RT_TASK *rttDisplay;
	FILE *fOut;
	struct sockaddr_in sLab;
	int skt;
	raw rawBuff[10];
	int rbStart;
	int rbEnd;
	fifo_data fdBuff[10];
	int fbStart;
	int fbEnd;
} thread_data;

void *Receive(void *arg){
	thread_data *tData = (thread_data *)arg;
	raw rData;
	float data[9];
	int i;

	tData->rttReceive = rt_task_init(nam2num("Receive"),1,512,256);
	rt_task_make_periodic(tData->rttReceive,rt_get_time(), 100*tData->period);

	while(1){
		data[0] = 0xFFFFFFFF;
		sendto(tData->skt, (void *)&data[0],sizeof(float),0,(struct sockaddr *)&(tData->sLab),sizeof(tData->sLab));
		//rt_busy_sleep(1000000);
		for(i = 0; i < 9; i++){
			recvfrom(tData->skt,(void *)&data[i],sizeof(float),MSG_WAITALL,NULL,NULL);
		}
		//Get data from stream
		rData.altitude = data[0];
		rData.distance = data[1];
		rData.gallons = data[2];
		rData.lat_g = data[3];
		rData.lifetime = data[4];
		rData.speed = data[5];
		rData.t_pressure = data[6];
		rData.temp = data[7];
		rData.vert_g = data[8];
		//Put it in the buffer
		tData->rawBuff[tData->rbEnd++] = rData;
		if(tData->rbEnd >= 10){
			tData->rbEnd = 0;
		}
		rt_task_wait_period();
	}

	pthread_exit(0);
}

void *Operate(void *arg){
	thread_data *tData = (thread_data *)arg;
	raw rData;
	fifo_data fData;

	tData->rttOperate = rt_task_init(nam2num("Operate"),1,512,256);
	rt_task_make_periodic(tData->rttOperate,rt_get_time() + 50*tData->period, 100*tData->period );

	while(1){
		rData = tData->rawBuff[tData->rbStart++];
		if(tData->rbStart >= 10){
			tData->rbStart = 0;
		}
		fData.gallons = rData.gallons;
		fData.distance = rData.distance;
		fData.temp = rData.temp;
		fData.speed = rData.speed;
		fData.mpg = rData.distance/rData.gallons;
		tData->fdBuff[tData->fbEnd++] = fData;
		if(tData->fbEnd >= 10){
			tData->fbEnd = 0;
		}
		rt_task_wait_period();
	}

	pthread_exit(0);
}

void *Display(void *arg){
	thread_data *tData = (thread_data *)arg;
	fifo_data fData;

	tData->rttDisplay = rt_task_init(nam2num("Display"),1,512,256);
	rt_task_make_periodic(tData->rttDisplay,rt_get_time() + 80*tData->period, 100*tData->period );

	while(1){
		fData = tData->fdBuff[tData->fbStart++];
		if(tData->fbStart >= 10){
			tData->fbStart = 0;
		}
		tData->fOut = fopen("telemetry.csv", "a");
		fprintf(tData->fOut,"%f,%f,%f,%f,%f\n", fData.gallons, fData.distance, fData.temp, fData.speed, fData.mpg);
		fclose(tData->fOut);
		rt_task_wait_period();
	}

	pthread_exit(0);
}

int main(){
	thread_data tData;
	pthread_t t1;
	pthread_t t2;
	pthread_t t3;

	int i;
	int skt;
	int myIPi;
	char myIPc[16];

	struct hostent *hinfo;
	struct in_addr bcastIP;
	struct in_addr myIP;

	struct sockaddr_in lab;

	tData.fbEnd = 0;
	tData.fbStart = 0;
	tData.rbEnd = 0;
	tData.rbStart = 0;

	tData.fOut = fopen("telemetry.csv", "w");
	fprintf(tData.fOut, "Fuel_Consumption,Distance,Temperature,Speed,Efficiency(mpg)\n");
	fclose(tData.fOut);

	//Local IP (Change according to which board the program is running on)
	hinfo = gethostbyname("ts7250-05");
	memcpy(&myIP,hinfo->h_addr_list[0],sizeof(struct in_addr));
	strcpy(myIPc,inet_ntoa(myIP));
	strtok(myIPc, ".");
	for(i = 0; i < 3; i++){
		myIPi = atoi(strtok(NULL, "."));
	}

	bcastIP.s_addr = inet_addr("10.3.52.12");

	lab.sin_addr.s_addr = htonl(INADDR_ANY);
	lab.sin_family = AF_INET;
	lab.sin_port = htons(2000);

	skt = socket(AF_INET,SOCK_DGRAM,0);
	bind(skt, (struct sockaddr *)&lab, sizeof(struct sockaddr));
	setsockopt(skt, SOL_SOCKET,SO_BROADCAST,(void *)&i,sizeof(int));
	lab.sin_addr.s_addr = bcastIP.s_addr;

	tData.sLab = lab;
	tData.skt = skt;

	tData.period = start_rt_timer(nano2count(RTT_PERIOD));

	pthread_create(&t1,NULL,Receive,(void *)&tData);
	pthread_create(&t2,NULL,Operate,(void *)&tData);
	pthread_create(&t3,NULL,Display,(void *)&tData);

	printf("Initialization Complete.\n");

	while(1){

	}

	printf("Tasks complete.\n");

	return 0;
}
ind(skt, (struct sockaddr *)&lab, sizeof(struct sockaddr));
	setsockopt(skt, SOL_SOCKET,SO_BROADCAST,(void *)&i,sizeof