#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <semaphore.h>

typedef struct {
	int btn_push;
	char btn_dir;
} message;

char matrix[1920];
int snake[1920];
int start = 271; // row 8 col 16
int snakehead = 0;
int oldsnakehead = 0;
int newsnakehead = 0;
int applepos = 0;
int applecaught = 0;
int moveSpeed = 47;
int numrow = 80;
int numcol = 24;
int apple = 1;
int direction = 1;
int wall = 2;
int snake1 = 3;
RT_TASK *move;
RTIME move_time;

void clearMatrix() {
	for (int i = 0; i < 1920; i++) {
		matrix[i] = ' ';
		printf("%c[1A", 27);
		printf("%c[2K", 27);

	}

}

void updateMatrix() {
	clearMatrix();
	drawBoarder();
	for (int i = 1; i < 1920; i++) {
		if (snake[i] == -1) {
			break;
		}
		matrix[snake[i]] = snake1;
	}
	matrix[snakehead] = snake1;
	matrix[applepos] = apple;
	for (i = 0; i <= numrow * numcol; i++) {
		printf("%c", matrix[i]);
	}

}

void *timer(void *buffer) {

	move_time = start_rt_timer(nano2count(100000));
	move = rt_task_init(nam2num("t1"), 0, 1920, 960);
	rt_task_make_periodic(move, rt_get_time(), nano2count(100000));

	while (1) {

		drawBorder();
		updateMatrix();
		rt_task_wait_period();
		moveSnake();

	}

}

void resetSnake() {
	for (int i = 0; i < 1920; i++) {
		snake[i] = -1;
	}

	clearMatrix();

	matrix[start] = snake1;
	snakehead = start;
	snake[0] = snakehead;
	drawBorder();
	setApple();
	matrix[applepos] = apple;
	direction = 1;

}

void drawBorder() {
	int i, j;

	for (j = 1; j <= numrow; j += numrow - 1) {
		printf("%d;%d", j, 1);
		for (i = 2; i < numcol; i++)
			printf("-");
		printf("+");
	}
	for (i = 2; i < numrow; i++)
		printf("%d;%c\n", i, 1, numcol - 2, ' ');
}

void direct(int i, unsigned long *ptr, message msg) {

	unsigned long t_name;
	int period;
	int offset;
	int btn;
	int push;
	RT_TASK *task;

	period = nano2count(30000000);
	offset = nano2count(10000000);

	if (i == 0) {
		t_name = nam2num("b0");
		task = rt_task_init(t_name, 2, 512, 256);
		rt_task_make_periodic(task, rt_get_time(), period);
	} else if (i == 1) {
		t_name = nam2num("b1");
		task = rt_task_init(t_name, 3, 512, 256);
		rt_task_make_periodic(task, rt_get_time() + (offset * i), period);
	} else if (i == 2) {
		t_name = nam2num("b2");
		task = rt_task_init(t_name, 4, 512, 256);
		rt_task_make_periodic(task, rt_get_time() + (offset * i), period);
	} else if (i == 3) {
		t_name = nam2num("b3");
		task = rt_task_init(t_name, 5, 512, 256);
		rt_task_make_periodic(task, rt_get_time() + (offset * i), period);
	}

	while (1) {

		if (i == 0) {
			btn = *ptr & 0x01;
			btn = btn >> i;
			if (btn == 0x00) {
				push = 1;
			}
			if (push == 1) {
				if (btn == 0x01) {
					push = 0;
					msg.btn_push = 0;
					msg.btn_dir = 'L';
					rt_mbx_send(btn_mbox, &msg, sizeof(message));

				}
			}
		} else if (i == 1) {
			btn = *ptr & 0x02;
			btn = btn >> i;
			if (btn == 0x00) {
				push = 1;
			}
			if (push == 1) {
				if (btn == 0x01) {
					push = 0;
					msg.btn_push = 1;
					msg.btn_dir = 'R';
					rt_mbx_send(btn_mbox, &msg, sizeof(message));

				}
			}
		} else if (i == 2) {
			btn = *ptr & 0x04;
			btn = btn >> i;
			if (btn == 0x00) {
				push = 1;
			}
			if (push == 1) {
				if (btn == 0x01) {
					push = 0;
					msg.btn_push = 2;
					msg.btn_dir = 'U';
					rt_mbx_send(btn_mbox, &msg, sizeof(message));

				}
			}
		} else if (i == 3) {
			btn = *ptr & 0x08;
			btn = btn >> i;
			if (btn == 0x00) {
				push = 1;
			}
			if (push == 1) {
				if (btn == 0x01) {
					push = 0
					msg.btn_push = 3;
					msg.btn_dir = 'D';
					rt_mbx_send(btn_mbox, &msg, sizeof(message));

				}
			}
		}

		rt_task_wait_period();
	}
}
void moveSnake() {
	oldsnakehead = snakehead;
	switch (direction) {
	case 0:
		// left
		if (snakehead == 160) {
			endGame();
		} else if ((snakehead - (snakehead % (numcol - 1)))
				== (((snakehead - 1) - (snakehead - 1) % (numcol - 1)))) {
			snakehead -= 1;
		} else {
			endGame();
		}
		break;
	case 1:
		// right
		if ((snakehead - (snakehead % (numcol - 1))) == (((snakehead + 1)
				- (snakehead + 1)) % (numcol - 1))) {
			snakehead += 1;
		} else {
			endGame();
		}
		break;
	case 2:
		//up
		if ((snakehead - (2 * numrow)) < 0) {
			endGame();
		} else {
			snakehead -= numrow;
		}

		break;
	case 3:
		// down
		if ((snakehead + numrow) > (((numrow - 1) * numcol - 1))) {
			endGame();
		} else {
			snakehead += numrow;
		}
	default:
		break;
	}

	// Check if we have the apple
	if (snakehead == applepos) {
		setApple();
		applecaught = 1;
		score += level * 10;
		if (level < maxLevel)
			if (score % 50 = 0)
				level++;
	}

	for (int i = 1; i < 1920; i++) {
		if (snake[i] == snakehead) {
			endGame();
		}
	}

	newsnakehead = snakehead;
	if (applecaught == 1) {
		for (int j = 1919; j > 0; j--) {
			snake[j] = snake[j - 1];
		}
		snake[0] = newsnakehead;
	}

	if (applecaught == 1) {
		setApple();
		applecaught = 0;
	}

	updateMatrix();
}
}

void updateMatrix() {
clearMatrix();
drawBoarder();
for (int i = 1; i < 1920; i++) {
	if (snake[i] == -1) {
		break;
	}
	matrix[snake[i]] = snake1;
}
matrix[snakehead] = snake1;
matrix[applepos] = apple;
}

void setApple() {
apple = rand() % 1919 + 23;
for (int i = 1; i < 1920; i++) {
	if (snake[i] == applepos) {
		setApple();
	}
	if (matrix[i] == wall) {
		if (matrix[i] == applepos) {
			setApple();
		}
	}
}
}

void endGame() {
for (int i = 0; i < numrow; i++) {
	for (int j = 0; j < numcol; j++) {
		matrix[j + (i * numcol)] = wall;
	}
}
resetSnake();
}

int main(void) {
int period;
int i;
int fd;
unsigned long *ptr;
RT_TASK *btn_time;
pid_t fork_id;
message msg;
char buffer[960];
pthread_t thread;

fd = open("/dev/mem", O_RDWR);
ptr
		= mmap(0, getpagesize(), PROT_READ | PROT_WRITE, MAP_SHARED, fd,
				0x80840000);
ptr += 5;
*ptr |= 0xF8;
ptr -= 4;

period = nano2count(100000);

btn_mbox = rt_typed_named_mbx_init("intbtn", sizeof(message) * 15, FIFO_Q);

drawBoarder()

pthread_create(&thread, NULL, timer, (void*)buffer);

for (i = 0; i <= 3; i++) {
	if ((fork_id = fork()) == 0) {
		direct(i, ptr, msg);
	}
}

btn_time = rt_task_init(nam2num("btn"), 0, 1920, 960);
rt_task_make_periodic(btn_time, rt_get_time(), period);

while (1) {

	rt_mbx_receive(btn_mbox, &msg, sizeof(message));

	if (msg.btn_push == 0) {

direction	=0

}
else if(msg.btn_push == 1) {

	direction =1

}
if(msg.btn_push == 2) {

	direction =2

}
if(msg.btn_push == 3) {

	direction =3

}
moveSnake();

rt_task_make_periodic(btn_time, rt_get_time(), period);
rt_task_wait_period();

}
}
}
