/* 	Name       : 	ProjectServer.c
	Author     : 	Andrew Shannon
	Description: 	Real Time Embedded Project
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <fcntl.h>

#define MSG_SIZE 40

int semaphoreWait(int compIP, int sock, struct sockaddr_in from, socklen_t length);
void semaphorePost(int compIP, int sock, struct sockaddr_in server, socklen_t fromlen);

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

int main(void)
{
	/*----------set up socket connections----------*/
	int sock, length, n;
	int boolval = 1;		// for a socket option
	socklen_t fromlen;
	struct sockaddr_in server;
	struct sockaddr_in from;

	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
	if (sock < 0)
	   error("Opening socket");

	length = sizeof(server);			// length of structure
	bzero(&server,length);			// sets all values to zero. memset() could be used
	server.sin_family = AF_INET;		// symbol constant for Internet domain
	server.sin_addr.s_addr = INADDR_ANY;		// IP address of the machine on which
											// the server is running
	server.sin_port = htons(2000);	// port number is 2000

	// binds the socket to the address of the host and the port number
	if (bind(sock, (struct sockaddr *)&server, length) < 0)
	   error("binding");

	// set broadcast option
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
	{
		printf("error setting socket options\n");
		exit(-1);
	}

	fromlen = sizeof(struct sockaddr_in);	// size of structure
	server.sin_addr.s_addr = inet_addr("10.3.52.255"); //Set to broadcast

	/*----------connect to computers playing----------*/
	int compCount;
	printf("Enter number of CLIENT computers to begin game: ");
	scanf("%d", &compCount);

	/*----------broadcast for computers to connect----------*/
	//Set message as empty string
	char message[MSG_SIZE];
	bzero(message, MSG_SIZE);

	//Save message with ip as string
	sprintf(message, "BEGIN");

	//Broadcast message to all computers
	n = sendto(sock, message, 40, 0, (struct sockaddr *)&server, fromlen);
	if (n  < 0)
		error("sendto");

	/*----------receive IPs on network-----------*/
	int compIP[10];

	int i=0;
	while(i<compCount) {

		//Receive message
		bzero(message, MSG_SIZE);
		if (recvfrom(sock, message, MSG_SIZE, 0, (struct sockaddr *)&from, &length) < 0)
			error("Receive");

		if (message[0] == '@') { //Check if computer IP message

			//Ignore first 3 numbers
			strtok(message, ".");
			strtok(NULL, ".");
			strtok(NULL, ".");

			//Store last number of IP
			compIP[i] = atoi(strtok(NULL, " "));

			printf("Computer #%d is %d of %d\n", compIP[i], i+1, compCount);

			i++; //increment counter
		}
	}

	/*----------Control loop----------*/
	//Declare and initialize pattern
	int pattCount = 3;
	int pattern[30];
	int lastFail = 0;

	printf("Enter first pattern:\n");
	for(i=0;i<pattCount;i++) {
		scanf("%d", &pattern[i]);
	}

	while((compCount > 1) && (pattCount <= 30)) {	//continue until one computer left or max length
		printf("Pattern length: %d\n", pattCount);
		i=0;
		while((i < compCount) && (compCount > 1)) {

			//Next player begin
			semaphorePost(compIP[i], sock, server, fromlen);

			//Set message
			bzero(message, MSG_SIZE);
			if((i == (compCount-1)) && (lastFail == 0))	//send 'I' if new loop
				sprintf(message, "#I ");
			else {
				sprintf(message, "#  ");
				if(lastFail == 1) {	//add random number to pattern if new round & last player failed
					printf("add random\n");
					pattern[pattCount] = (rand()%2+1);
				}

				lastFail = 0;
			}

			int j;
			for(j=0;j<pattCount;j++) {
				message[j+3] =  pattern[j] + 48;	//set pattern to message
			}

			if(compCount==1) {
				bzero(message, MSG_SIZE);
				sprintf(message, "WINNER");
			}

			//Send pattern
			if (sendto(sock, message, 40, 0, (struct sockaddr *)&server, fromlen)  < 0)
				error("Send message error");

			//Wait for player to finish
			semaphoreWait(compIP[i], sock, from, length);

			//Receive new pattern
			bzero(message, MSG_SIZE); //clear message
			if(recvfrom(sock, message, MSG_SIZE, 0, (struct sockaddr *)&from, &length) < 0)
				error("Receive message error");

			if(message[0] == '#') { //If success get new pattern
				if(i == (compCount-1))	//check if last in round
					pattCount++;

				for(j=1;j<=pattCount;j++) {
					pattern[j-1] = message[j] - 48; //int to char
				}

				i++; //Go to next computer
			}
			else if(message[0] == 'F') { //If fail remove computer from loop
				printf("computer #%d removed\n", compIP[i]);
				lastFail=1;
				int k,l=0;
				for(k=0;k<compCount;k++) {
					if(compIP[k] != compIP[i]) {
						compIP[l] = compIP[k];
						l++;
					}
				}

				if(i == (compCount-1))	//check if last in round
					pattCount++;

				compCount--;	//decrement number of computers in loop

			}
		}
	}

	/*---------Winner message----------*/
	printf("Computer #%d is the winner!\n", compIP[0]);

	semaphorePost(compIP[0], sock, server, fromlen);

	bzero(message, MSG_SIZE); //clear message
	sprintf(message, "WINNER!!!\n\n");

	if (sendto(sock, message, 40, 0, (struct sockaddr *)&server, fromlen)  < 0)
		error("Send message error");

	return 0;
 }

//Wait for IP to be received
int semaphoreWait(int compIP, int sock, struct sockaddr_in from, socklen_t length) {

	char message[MSG_SIZE];

	while(1) {
		bzero(message, MSG_SIZE); //clear message

		//Receive message
		if(recvfrom(sock, message, MSG_SIZE, 0, (struct sockaddr *)&from, &length) < 0)
			error("Receive message error");

		//Check if this computer
		if(message[0] == '!') { //check if IP message
			if(message[1] == compIP) //check if this IP
				return 1;
		}
	}
}

//Send IP
void semaphorePost(int compIP, int sock, struct sockaddr_in server, socklen_t fromlen) {

	char message[MSG_SIZE];
	bzero(message, MSG_SIZE); //clear message

	//Send IP
	message[0] = '@';
	message[1] = compIP + 48;

	//Send message
	if (sendto(sock, message, 40, 0, (struct sockaddr *)&server, fromlen)  < 0)
		error("Send message error");

}
