/*
 * Audio Project
 *
 * Name: Russ Butler
 * ID: 12309946
 * Date: 4/13/2012
 */

#ifndef SPI_CONTROLLER_H_
#define SPI_CONTROLLER_H_




#define SPI_BASE_ADDR		0x808A0000
#define SPI_CR0_OFFSET		0x0
#define SPI_CR1_OFFSET		0x4
#define SPI_DR_OFFSET		0x8
#define SPI_PSR_OFFSET		0xC
#define SPI_PCPSR			0x10

//CR0 Register Fields
#define SPI_CR0_SCR			8
#define SPI_CR0_SPH			7
#define SPI_CR0_SPO			6
#define SPI_CR0_FRF			4
#define SPI_CR0_DSS			0

//CR1 Register Fields
#define SPI_CR1_MS			5
#define SPI_CR1_SSE			4

//CPSR
#define SPI_CPSR_CPSDVSR	0

//PSR
#define SPI_PSR_BSY			4
#define SPI_PSR_TNF			1

static unsigned long spi_base_addr = 0;
static volatile unsigned long *spi_cr0 = 0;
static volatile unsigned long *spi_cr1 = 0;
static volatile unsigned long *spi_dr = 0;
static volatile unsigned long *spi_psr = 0;
static volatile unsigned long *spi_pcsr = 0;


int spi_open() {
	spi_base_addr = (unsigned long) __ioremap(SPI_BASE_ADDR,0x1000,1);
	spi_cr0 = (unsigned long *) (spi_base_addr + SPI_CR0_OFFSET);
	spi_cr1 = (unsigned long *) (spi_base_addr + SPI_CR1_OFFSET);
	spi_dr = (unsigned long *) (spi_base_addr + SPI_DR_OFFSET);
	spi_psr = (unsigned long *) (spi_base_addr + SPI_PSR_OFFSET);
	spi_pcsr = (unsigned long *) (spi_base_addr + SPI_PCPSR);

	//set enable bit (SSE in SSPCR1)
	//write configuration
	//clear enable bit (SSE in SSPCR1)
	//set enable bit (SSE in SSPCR1)


	//set enable bit (SSE in SSPCR1)
	*spi_cr1 |= (1 << SPI_CR1_SSE);

	//write configuration - this gives frequency of 4 MHz (by testing)
	*spi_cr0 = (1 << SPI_CR0_SCR) |			//Clock prescaling
				(0 << SPI_CR0_SPH) |		//CPHA = 0
				(0 << SPI_CR0_SPO) |		//CPOL = 0
				(0 << SPI_CR0_FRF) |		//Motorola (SPI) mode
				(7 << SPI_CR0_DSS);			//8 bits per transfer
	*spi_cr1 &= ~(1 << SPI_CR1_MS);			//Master Mode
	*spi_pcsr = (2 << SPI_CPSR_CPSDVSR);	//Divide clock by 2 of 3.7MHz


	//clear enable bit (SSE in SSPCR1)
	*spi_cr1 &= ~(1 << SPI_CR1_SSE);

	//set enable bit (SSE in SSPCR1)
	*spi_cr1 |= (1 << SPI_CR1_SSE);

	return 0;
}

int spi_close() {
	if (spi_base_addr != 0)
		__iounmap((void*) spi_base_addr);
	spi_base_addr = 0;
	return 0;
}

int spi_write_byte(uint8_t byte) {
	static int start = 1;
	if (start <= 2) {
		if (*spi_psr & (1 << SPI_PSR_BSY))
			printk("busy before write\n");
		else
			printk("not busy before write\n");
	}
	*spi_dr = byte;
	if (start <= 2) {
		if (*spi_psr & (1 << SPI_PSR_BSY))
			printk("busy after write\n");
		else
			printk("not busy after write\n");
	}
	start++;
	return 0;
}

int spi_write_array(uint8_t* data, int size) {
	int i;
	for (i = 0; i < size; i++) {

		//wait until transmit buffer is not full
		while (!(*spi_psr & (1 << SPI_PSR_TNF)));

		//write data
		*spi_dr = data[i];
	}

	//wait until the spi is no longer busy
	while (*spi_psr & (1 << SPI_PSR_BSY));

	return 0;
}


#endif /* SPI_CONTROLLER_H_ */
