 /*
 * keypad.c
 *
 *  Created on: Apr 30, 2012
 *      Author: xw795
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <linux/time.h>
#include <rtai_fifos.h>
MODULE_LICENSE("GPL");

RT_TASK rttask;
RTIME period;

unsigned long *ptr;
unsigned long *pbdr, *pbddr;
unsigned long *pfdr, *pfddr;
char input;
char str;

static void rt_process(int t)
{
	while(1)
	{
		if(*pbdr == 0x0F)     // sense the pressure sensor
		{
			str='T';
			rtf_put(0,&str, sizeof(str));
		}
		if(*pbdr == 0x1E)    // password
		{
			input='A';
			rtf_put(0,&input,sizeof(input));
		}
		if(*pbdr == 0x1D)   // password
		{
			input='B';
			rtf_put(0,&input,sizeof(input));
		}
		if(*pbdr == 0x1B)		// password
		{
			input='C';
			rtf_put(0,&input,sizeof(input));
		}

		rt_task_wait_period();

	}
}

int init_module(void)
{
	int retval1,retval2;

	ptr = (unsigned long *) __ioremap(0x80840000, 4096, 0);
	pbdr = ptr + 0x01;   // offsets to port B
	pbddr = ptr + 0x05;
	*pbddr = *pbddr | 0xE0;       // set I/O of port B

	rt_set_periodic_mode();
	period= start_rt_timer(nano2count(1000000));     // start timer
	retval1=rt_task_init(&rttask, rt_process,0,2000,0,0,0);

	if(retval1 !=0)     // check the establishing of real-time task
	{
		printk("Fail to create realtime task\n");
	}

	rt_task_make_periodic(&rttask, rt_get_time()+period, 1000*period);

	retval2=rtf_create(0,100);

	return 0;
}


void cleanup_module(void)    // remove function
{
	rt_task_delete(& rttask);
	stop_rt_timer();
}

