///////////////////////////////////////////////////////////////
/////// This is BankInterest.c
////// Its the bank interest system program, working in the kernel space
////// install it in the same board with the bank center
////////////////////////////////////////////////////////////////
#ifndef MODULE
#define MODULE
#endif
#ifndef __KERNEL__
#define __KERNEL__
#endif
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/time.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_sem.h>
#include <rtai_fifos.h>
#include <ece4220lab4.h>
#include <asm/io.h>

MODULE_LICENSE("GPL");

RTIME period;
static RT_TASK mytask;
static void rt_process(int t);

int init_module(void)
{
	char flag='@';
	rtf_create(1,sizeof(flag)); // create a fifo
	rt_set_periodic_mode();
	period=start_rt_timer(nano2count(1000000000));  // set 1s
	rt_task_init(&mytask, rt_process,0,256,0,0,0);
	//to initial the task and set STACK_SIZE as 256
	rt_task_make_periodic(&mytask, rt_get_time(), 20*period);
	// start the task, period ????
	return 0;
}
static void rt_process(int t)
{
	int n=0;
	int count=0;
	char flag='@';
	while(1)
	{
	printk("sending %d\n", count);
	if((n=rtf_put(1,&flag,sizeof(flag)))<0)
			printk("write fifo error!");  //write data to realtime fifo
	printk("send %d\n", count);
	count+=1;
	rt_task_wait_period();
	}

}

void cleanup_module(void)
{

	rtf_destroy(1);
	stop_rt_timer();
}