/*
 ============================================================================
 Name        : finalprojectclient.c
 Author      : Jacob Starr
 Version     :
 Copyright   :
 Description : My client program for the final project
 ============================================================================
 */

/*
 * In this program, I create a UDP broadcast client that will forever loop
 * the message "DATA\n" to everyone on the network.  If the client receives
 * any data back from any of the servers, it will print the distance and the
 * IP address of the server received from the server to the client.  The client
 * is able to tell approximately where in the room a person is based off of
 * which IP is received and the distance away the object is detected from.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

//message size for the buffer
#define MSG_SIZE 100

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

int main(int argc, char *argv[])
{
	int sock, n;
	unsigned int length;
	struct sockaddr_in anybody, from;
	char buffer[MSG_SIZE];	//stores received messages or messages to be sent.
	int boolval = 1;
	char *ipAddress;
	double distance = 0, tempDistance = 0;

	if (argc != 2)
	{
	   printf("usage: %s port\n", argv[0]);
	   exit(1);
	}

	//creates a connectionless socket
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock < 0)
	   error("socket");

	//changes the permissions of the socket to allow broadcast
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
	{
		printf("error setting socket options\n");
		exit(-1);
	}

	//symbol constant for Internet domain, port field, and the broadcast address
	anybody.sin_family = AF_INET;
	anybody.sin_port = htons(atoi(argv[1]));
	anybody.sin_addr.s_addr = inet_addr("10.3.52.255");

	//structure size
	length = sizeof(struct sockaddr_in);

	do {
		//sets all the bits of buffer back to zero since not every message
		//will be the same size
		bzero(buffer,MSG_SIZE);

		//sends a message to anyone there
		strcpy(buffer, "DATA\n");
		n = sendto(sock, buffer, strlen(buffer), 0, (const struct sockaddr *)&anybody, length);
		if (n < 0)
			error("Sendto");

		//receives the message
		n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
		if (n < 0)
			error("recvfrom");

		//use strtok to retrieve the IP address and the distance from the buffer
		tempDistance = distance;
		ipAddress = strtok(buffer, " ");
		distance = atof(strtok(NULL, " "));

		//since the sensor is only accurate up to 5 meters, only print data in that range
		if ( distance > 0.0 && distance <= 5.0 ) {
			printf("Object is detected %lf meters away from board %s.\n", distance, ipAddress);
		}
	}
	while(1);

	//closes the socket
	close(sock);
	return 0;
}
