/*
 ============================================================================
 Name        : finalprojectkernel.c
 Author      : Jacob Starr
 Version     :
 Copyright   : Mine
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

/*
	So far I have created a hardware interrupt that is supposed to trigger when
	the ECHO pin (DIO_0 & DIO_4) changes states.  In my configuration, the TRIGGER
	pin will be connected to DIO_7.
*/
#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_fifos.h>
#include <linux/time.h>

MODULE_LICENSE("GPL");

typedef struct timeval timestamp_t;
timestamp_t time_stamp;
static RT_TASK mytask;
RTIME period;
unsigned long* RawIntStsB;
unsigned long* VIC2SoftIntClear;
unsigned long* btnDR;
unsigned long* spkDR;
unsigned long* IntStsB;
unsigned long* GPIOBEOI;

//real time task that creates the trigger for the sensor
static void rt_process(int t){
	while(1){
		*btnDR |= (1 << 7);
		rt_task_wait_period();
		*btnDR &= ~(1 << 7);
		rt_task_wait_period();
	}
}


//hardware interrupt handler
static void my_handler(unsigned irq_num, void * cookie){
        //disables the irq handling
        rt_disable_irq(irq_num);

        //trigger set for rising edge, gets timestamp and sends
        //through FIFO 0
        if (*IntStsB & 0x01){
			do_gettimeofday(&time_stamp);
			rtf_put(0, (char*)&time_stamp, sizeof(timestamp_t));
			//the next two commented lines lit up LEDs on the
			//auxiliary board to test the interrupts
			//*btnDR &= ~(1 << 5);
			//*btnDR |= (1 << 6);
        }
        //trigger set for falling edge, gets timestamp and sends
        //through FIFO 1
        else if (*IntStsB & 0x10){
			do_gettimeofday(&time_stamp);
			rtf_put(1, (char*)&time_stamp, sizeof(timestamp_t));
			//the next two commented lines lit up LEDs on the
			//auxiliary board to test the interrupts
			//*btnDR &= ~(1 << 6);
			//*btnDR |= (1 << 5);
        }
        //clears the interrupt
        *GPIOBEOI |= 0x1F;

        //enables the irq handling once again
        rt_enable_irq(irq_num);

}

//the module that initializes everything
int init_module(void) {
	unsigned long *ptr, *GPIOBIntEn, *GPIOBIntType1, *GPIOBIntType2, *GPIOBDB, *btnDDR, *spkDDR;

	//real time function that attaches the irq
	rt_request_irq(59, my_handler, 0, 1); //hardware interrupt

	//maps Port B
	ptr = (unsigned long*)__ioremap(0x80840000, 4096, 0);

	//maps the hardware interrupt register memory
	GPIOBIntEn = (unsigned long*)((char*)ptr + 0xB8);
	//enables the buttons
	*GPIOBIntEn |= 0x1F;
	//disables the LED's
	*GPIOBIntEn &= ~0xE0;
	GPIOBEOI = (unsigned long*)((char*)ptr + 0xB4);
	//clears the interrupt flags
	*GPIOBEOI |= 0x1F;
	GPIOBIntType2 = (unsigned long*)((char*)ptr + 0xB0);
	//sets the interrupt for the falling edge
	*GPIOBIntType2 &= ~0x10;
	//sets the interrupt for the rising edge
	*GPIOBIntType2 |= 0x01;
	GPIOBIntType1 = (unsigned long*)((char*)ptr + 0xAC);
	//sets the interrupt for the edge
	*GPIOBIntType1 |= 0x1F;
	IntStsB = (unsigned long*)((char*)ptr + 0xBC);
	RawIntStsB = (unsigned long*)((char*)ptr + 0xC0);
	GPIOBDB = (unsigned long*)((char*)ptr + 0xC4);

	//maps the memory for Port B
	btnDR  = (unsigned long*)((char*)ptr + 0x04);
	btnDDR = (unsigned long*)((char*)ptr + 0x14);

	//sets the LED's data direction register's output to 1 and 0 for input buttons
	*btnDDR |= 0xE0;
	*btnDDR &= ~0x1F;

	//maps the speaker register memory
	spkDR  = (unsigned long*)((char*)ptr + 0x30);
	spkDDR = (unsigned long*)((char*)ptr + 0x34);
	*spkDDR |= 0x2;

	//enables the irqs
	rt_enable_irq(59);

	rt_set_periodic_mode();

	//100ms to pull the trigger (at least 10 us) (50ms high, 50ms low)
	period = start_rt_timer(nano2count(50000000));

	*btnDR &= ~0xE0;

	//initializes the real time task and makes it periodic
	rt_task_init(&mytask, rt_process, 0, 256, 0, 0, 0);
	rt_task_make_periodic(&mytask, rt_get_time(), period);

	//creates the real time fifos
	rtf_create(0, sizeof(time_stamp));
	rtf_create(1, sizeof(time_stamp));

	return 0;
}

//deletes the real time task, stops the timer, destroys the fifos,
//releases the interrupts, and turns off the speakers
void cleanup_module(void) {
	rt_task_delete(&mytask);
	stop_rt_timer();
	rtf_destroy(0);
	rtf_destroy(1);
	rt_disable_irq(59);
	rt_release_irq(59);

	*btnDR &= ~0xE0;
	*spkDR &= ~0x02;
}
