/*
 ============================================================================
 Name        : finalprojectserver.c
 Author      : Jacob Starr
 Version     :
 Copyright   : Mine
 Description : My server program for the final project
 ============================================================================
 */

/*
	In this server program, I do not care about whether or not a server is a
	master or slave configuration.  I will be reading in information from the
	real-time FIFO and do calculations based off of the data that
	I receive.  Once I receive the data (if there is any valid data), I will
	broadcast the IP address of that board along with the distance calculated
	based off of my data to the client program.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>

#define MSG_SIZE 100      //message size

//prints an error if there is an error detected
void error(const char *msg)
{
	perror(msg);
	exit(0);
}

//pthread that performs the calculations
void* pipeData();


// globals
int sock;
int portnum;
char masterIP[16], myIP[16];
typedef struct timeval timestamp_t;
char buffer[MSG_SIZE];  //to store received messages or messages to be sent.

int main(int argc, char *argv[]) {
	//variable declarations
	int length, boolval = 1;		//for a socket option
	struct sockaddr_in server;
	char host[64];

	//randomize the vote seed
	srand(time(NULL));

	//removes the module from the board if installed and install
	//the module when the programs starts up
	system("rmmod finalprojectkernel");
	system("insmod /home/jas985/workspace/finalprojectkernel/Release/src/finalprojectkernel.o");

	//error check command line
	if (argc < 2) {
		printf("usage: %s port\n", argv[0]);
		exit(0);
	}

	//creates connectionless socket
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock < 0) {
		error("Opening socket");
	}

	//sets up the socket
	length = sizeof(server);                 //length of structure
	bzero(&server,length);                 	 //sets all values to zero
	server.sin_family = AF_INET;             //symbol constant for Internet domain
	server.sin_addr.s_addr = INADDR_ANY;     //IP address of the machine on which
											 //the server is running
	server.sin_port = htons(atoi(argv[1]));  //port number
	portnum = atoi(argv[1]);

	//gets the IP address of the server
	gethostname(host, 64);
	struct hostent *p = gethostbyname(host);
	strcpy(myIP, inet_ntoa(*((struct in_addr *)p->h_addr)));
	printf("My IP address is %s.\n\n", myIP);

	//binds the socket to the address of the host and the port number
	if (bind(sock, (struct sockaddr *)&server, length) < 0)
		error("binding");

	//change socket permissions to allow broadcast
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0) {
		printf("error setting socket options\n");
		exit(-1);
	}

	//creates the pthread
	pthread_t tid;
	pthread_create(&tid, NULL, pipeData, NULL);

	return 0;
 }


//this function reads in timestamps and performs calculations based off
//of the speed of sound to calculate the distance of an object from the
//ultrasonic distance sensor
void* pipeData(){
	char buffer[MSG_SIZE];
	int n;
	//variable declarations that set up the pipe and broadcast
	int fd_fifo_old = open("/dev/rtf/0", O_RDWR);
	int fd_fifo_new = open("/dev/rtf/1", O_RDWR);
	timestamp_t oldtime, newtime;

	socklen_t fromlen = sizeof(struct sockaddr_in);
	struct sockaddr_in broadcast_addr;

	broadcast_addr.sin_family = AF_INET;
	broadcast_addr.sin_port = htons(portnum);
	broadcast_addr.sin_addr.s_addr = inet_addr("10.3.52.255");      //for broadcasting

	while(1){
		//cleans up the buffer since the messages aren't always the same length
		bzero(buffer,MSG_SIZE);

		//receive from a client
		n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&broadcast_addr, &fromlen);
		if (n < 0) {
			error("recvfrom");
		}

		//reads in from the fifo
		read(fd_fifo_old, &oldtime, sizeof(timestamp_t));
		read(fd_fifo_new, &newtime, sizeof(timestamp_t));

		//the message "DATA\n" is sent from the client
		if (!strcmp(buffer, "DATA\n")) {
			//calculations to get the difference in time and the distance based off the speed of sound
			float time = ((newtime.tv_sec - oldtime.tv_sec) * 1000000 + (newtime.tv_usec - oldtime.tv_usec))/1000000.0;
			float distance = (time * 341)/2;

			//checks to make sure that the data is doing the calculations correctly
			//this line could be removed
			printf("The data is oldtime: %u.%u seconds, newtime: %u.%u seconds, difference: %f\n", oldtime.tv_sec, oldtime.tv_usec, newtime.tv_sec, newtime.tv_usec, time);

			//stores the IP address of the server and the distance to the buffer
			sprintf(buffer, "%s %.6f", myIP, distance);

			//sends the IP address and the distance to the client program
			if (sendto(sock, buffer, strlen(buffer), 0, (struct sockaddr *)&broadcast_addr, fromlen) < 0)
				error("sendto");
		}
		else {
			printf("Invalid message received: %s\n\n", buffer);
		}
		//}
	}

	pthread_exit(0);
}
