/*
 ============================================================================
 Name        : User
 Author      : Abdullah Albelaiys
 Description : Arrows Game User
 ============================================================================
 */
// call libraries
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rtai.h>
#include <unistd.h>
#include <rtai_lxrt.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <semaphore.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>

#define ROUND    100


int main (void) {

	// declare variables
    unsigned long button;
    int fd, rounds = 0;
    unsigned long *ptr;
    unsigned long *pfdr;
    unsigned long *pfddr;
    unsigned long *pbdr;
    unsigned long *pbddr;
    int numrounds = 0;

	int arrow;
	int count = 0;

    fd = open("/dev/mem",O_RDWR | O_SYNC ); //opens up special file /dev/mem
    ptr = mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x80840000); // mapping
    pfdr = (unsigned long *) ((char *) ptr + 0x04);//offsets to port B = 0x80840004
    pfddr = (unsigned long *) ((char *)pfdr + 0x10); //offsets to DDR for port B
    pbdr = ptr + 0x01; //pbdr = 0x80840004
    pbddr = ptr + 0x05; //pbdr = 0x80840014
    *pbddr &= 0xFFFFFFFE; //input
    *pbddr |= 0xE0; //output
    *pbdr &= 0xFFFFFF1F; //turns off all lights
    button = *pfdr;

    printf("Welcome!!\n Use the buttons on the auxilary board to match the arrows appearing on screen\n");
    printf("Left    button corresponds to LEFT <--\n");
    printf("Middle  button corresponds to UP ^\n");
    printf("Right   button corresponds to RIGHT -->\n");
    printf(" About to start! just type in the number of rounds you with to play\n");
    scanf("%d", &rounds);
	while (numrounds < rounds) {

		srand(time(NULL));
		arrow = rand()% 3 + 1; // to generate a random number from 1 to 3
		if (arrow == 1) { // if the random number is one, the print UP arrow
			printf("^\n");
			usleep(1000000);
			if (((button & 0X01) == 0x00)) {// Left button
				*pbdr |= 0x20; // just to make sure the button is pressed
                msync(ptr, getpagesize(), MS_ASYNC);
                sleep(1); //wait
                *pbdr = *pbdr & 0xFFFFFF1F;
				printf("You Got a point!\n");
				count ++;
				}
			else {
				printf("Lost it!\n");
					count --;
					}
			numrounds++;
		}

		else if ( arrow == 2) { // if the random number is 2, the print right arrow
			printf("-->\n");
			usleep(1000000);
			if (((button & 0X04) == 0x00)) {// middle button
				*pbdr |= 0x40; // just to make sure the button is pressed
                msync(ptr, getpagesize(), MS_ASYNC);
                sleep(1); //wait
                *pbdr = *pbdr & 0xFFFFFF1F;
				printf("You Got a point!\n");
				count ++;
				}
			else {
				printf("Lost it!\n");
					count --;
					}
			numrounds++;
		}
		else if (arrow == 3){
			printf("<--\n");
			usleep(1000000);
			if (((button & 0X10) == 0x00)) {// right button
				*pbdr |= 0x80; // just to make sure the button is pressed
                msync(ptr, getpagesize(), MS_ASYNC);
                sleep(1); //wait
                *pbdr = *pbdr & 0xFFFFFF1F;
				printf("You Got a point!\n");
				count ++;
				}
			else {
				printf("Lost it!\n");
					count --;
					}
			numrounds++;
		}
	}
	printf("Number of points you earned is: %d\n", count);
	return 0;
}

