/******************************************************************************
 *
 *  gnuplot.c
 *
 *  Author     : Dallas Fletchall
 *  Date       : Apr 29, 2014 12:10:42 PM
 *  Description: gnuplot.c, implements all necessary gnuplot communications
 *               and setup
 *
 *****************************************************************************/
/**************************************
 * Includes
 *************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "gnuplot.h"
#include "logic_analyzer_client.h"

/**************************************
 * Local Definitions
 *************************************/
static char *dataFile;
static char *channelNames[NUM_CHANNELS];
static FILE *gnuPlotPipe;

/**************************************
 * Functions
 *************************************/
void gnuplotSetup( char const * const filename ){

	int i;

	// Copy the filename
	dataFile = (char *)malloc( strlen( filename ) * sizeof( char ) );
	strcpy( dataFile, filename );

	// Setup the default gnuplot characteristics applicable to Logic Analyzer
	gnuPlotPipe = popen( "gnuplot -noraise", "w" );
	fprintf( gnuPlotPipe, "unset ytics\n" );
	fprintf( gnuPlotPipe, "set yrange[-.5:4.5]\n");
	fprintf( gnuPlotPipe, "set xlabel 'Time(s)'\n" );
	fprintf( gnuPlotPipe, "set ylabel 'Level'\n" );
	fprintf( gnuPlotPipe, "set key rmargin\n" );
	fprintf( gnuPlotPipe, "set term wxt title 'Logic Analyzer'\n " );

	// Setup the channel names
	for( i = 0; i < NUM_CHANNELS; i++ ){
		channelNames[i] = (char *)malloc( 10 * sizeof( char ) );
		sprintf( channelNames[i], "Channel %d", i + 1 );
	}

	// Plot the initial data
	gnuplotPlot();

} // end gnuplotSetup( char * )

void gnuplotPlot( void ){

	fprintf( gnuPlotPipe, "plot '%s' using 1:2 title '%s' with lines," \
			              "'%s' using 1:3 title '%s' with lines,"      \
			              "'%s' using 1:4 title '%s' with lines,"      \
			              "'%s' using 1:5 title '%s' with lines;\n",
			              dataFile, channelNames[0],
			              dataFile, channelNames[1],
			              dataFile, channelNames[2],
			              dataFile, channelNames[3]
		   );
	fflush( gnuPlotPipe );

}

void gnuplotSetChannelName( int num, char const * const name ){

	// Release memory for the previous name
	free( channelNames[num - 1] );

	// Get space for the new name
	channelNames[num - 1] = (char *)malloc( strlen( name ) * sizeof( char ) );
	strcpy( channelNames[num - 1], name );

	// Replot
	gnuplotPlot();

} // end gnuplotSetChannelName( int, char * )

void gnuplotClose( void ){

	int i;

	// Free the channel names
	for( i = 0; i < NUM_CHANNELS; i++ ){
		free( channelNames[i] );
	}

	// Free the dataFile name
	free( dataFile );

	// Close the gnuplotpipe
	fclose( gnuPlotPipe );
}
