/******************************************************************************
 *
 *  logic_analyzer_client.h
 *
 *  Author     : Dallas Fletchall
 *  Date       : Apr 29, 2014 12:46:45 PM
 *  Description: logic_analyzer_client.h
 *
 *****************************************************************************/
#ifndef LOGIC_ANALYZER_CLIENT_H_
#define LOGIC_ANALYZER_CLIENT_H_

#include <netinet/in.h>

#define NUM_CHANNELS 4
#define TITLE        "Logic Analyzer"

#define BIT( X ) ( 1 << ( X ) )

typedef struct sockaddr_in Sockaddr_in;
typedef struct hostent     Hostent;
typedef struct timeval     Timeval;

void printMainMenu( void );

void changeLevel( int socket_fd );
void readSignals( int socket_fd );
void formatFileForGnuPlot( int fd, double time );
double timeval2double( Timeval time );
double extractData( uint32_t reg, uint32_t hComparator, uint32_t lComparator );
void flushStdin( void );

#endif /* LOGIC_ANALYZER_CLIENT_H_ */
