/******************************************************************************
 *
 *  menu.c
 *
 *  Author     : Dallas Fletchall
 *  Date       : Apr 29, 2014 11:29:32 AM
 *  Description: menu.c, handles the main menu selection and changing the
 *               gnuplot channel labels menu
 *
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "menu.h"
#include "gnuplot.h"
#include "logic_analyzer_client.h"

#define CLEAR

MainMenuOption mainMenu( void ){

	int            input;
	MainMenuOption selection = INVALID_MAIN_MENU_OPTION;

#ifdef CLEAR
	if( -1 == system( "clear" ) ){ perror( "system( \"clear\")" ); }
#endif

	while( INVALID_MAIN_MENU_OPTION == selection ){
		printf( "%s\n\n", TITLE );
		printf( "\t1. Read Signals\n" );
		printf( "\t2. Label Signals\n" );
		printf( "\t3. Set Logic Signal Levels\n" );
		printf( "\t4. Exit Logic Analyzer\n\n" );
		printf( "Selection: " );

		// Read user input, and validate
		if( ( 1 == scanf( "%d", &input )        ) &&
			( MAX_MAIN_MENU_OPTION > input     ) &&
			( INVALID_MAIN_MENU_OPTION < input )
		  )
		{
			selection = input;
		}else{
#ifdef CLEAR
			if( -1 == system( "clear" ) ){ perror( "system( \"clear\" )" ); }
#endif
			printf( "Invalid Selection!\n\n" );
		}

	}

	return selection;

} // end mainMenu()

void changeLabel( void ){

	int channelNumber = 0;
	char channelName[CHANNEL_LABEL_MAX];

	// Clear the channelName
	memset( channelName, 0, CHANNEL_LABEL_MAX );


	while( 0 == channelNumber ){

		// Get the channel that needs to be changed
		printf( "Enter the Channel Number: " );

		// Validate channel number
		if( ( 1 == scanf( "%d", &channelNumber ) ) &&
		    ( NUM_CHANNELS + 1 > channelNumber       ) &&
		    ( 0 < channelNumber                 )
		  )
		{
			// Get the new channel name
			printf( "Enter the name for channel %d:", channelNumber );
			if( 1 != scanf( "%s", channelName ) ){
				printf( "Invalid Name" );
				break;
			}

			// Valid Channel Name
			gnuplotSetChannelName( channelNumber, channelName );

		}else{

			channelNumber = 0;
//			if( -1 == system( "clear" ) ){ perror( "system( \"clear\")" ); }
			printf( "Valid channels are 1 - %d\n", NUM_CHANNELS );
			flushStdin();

		}

	}

}

