/******************************************************************************
 *
 *  pin_assignments.h
 *
 *  Author     : Dallas Fletchall
 *  Date       : May 9, 2014 3:44:21 PM
 *  Description: pin_assignments.h, defines the pin assignments that are to
 *               be used by the raspberry pi.  This file is linked to both
 *               projects, therefore a change in the server changes the same
 *               file in the client
 *
 *****************************************************************************/
#ifndef PIN_ASSIGNMENTS_H_
#define PIN_ASSIGNMENTS_H_

// Pin assignments for the input probes
#define P1_LOW         8
#define P1_HIGH       11
#define P2_LOW         9
#define P2_HIGH       10
#define P3_LOW        22
#define P3_HIGH       23
#define P4_LOW        24
#define P4_HIGH       25

// Pin assignments for SPI serial connection with DAC's
#define SPI_SDI        2
#define SPI_SCK        3
#define LOW_DAC_CS_N   4
#define HIGH_DAC_CS_N 17


#endif /* PIN_ASSIGNMENTS_H_ */
