/******************************************************************************
 *
 *  mcp4901.c
 *
 *  Author     : Dallas Fletchall
 *  Date       : Apr 30, 2014 11:51:24 PM
 *  Description: mcp4901.c, implements all functionality to communicate with
 *               DACs. Dependent on rpi.h for macros to set pin direction.
 *               Work needs to be done to remove logic analyzer specific
 *               implementation from this file.
 *
 *****************************************************************************/
#include "mcp4901.h"
#include "rpi.h"
#include "logic_analyzer_server.h"

void mcp4901Setup( Mcp4901 *dac,
		           uint8_t aSdi,
		 	       uint8_t aSck,
		 	       uint8_t aCs_n,
		 	       double  aVref
		 	     )
{
	dac->sdi    = aSdi;
	dac->sck    = aSck;
	dac->cs_n   = aCs_n;
	dac->vref   = aVref;

	// Set the pins as outputs
	OUT_GPIO( dac->sdi );
	OUT_GPIO( dac->sck );
	OUT_GPIO( dac->cs_n );
	GPIO_SET = 1 << dac->cs_n;

} // end mcp4901Setup( Mcp4901 *, uint8_t, uint8_t, uint8_t, uint8_t, double )

int mcp4901SetVout( Mcp4901 *dac, double aVoltage ){

	int i = 0;

	if( dac == NULL || aVoltage > dac->vref || aVoltage < 0 ){
		return -1;
	}

	// Convert the voltage to a 16 bitword to be transmitted
	uint8_t tempVoltage = (uint8_t)( ( aVoltage * 255 ) / dac->vref );

	/* Data format for Mcp4901 CCCC DDDDDDDD XXXX, where C = configuration
	 * bit, D = data bit, X = don't care                                   */
	uint16_t tx_word = 7;
	tx_word = tx_word << 8;
	tx_word |= tempVoltage;
	tx_word = tx_word << 4;

	// Bits get sent on rising edge, so verify sck before process
	GPIO_CLR = 1 << dac->sck;

	// Select the chip
	GPIO_CLR = 1 << dac->cs_n;

	for( i = 15; i >= 0; i-- ){

		if( BIT( i ) & tx_word ){
			GPIO_SET = 1 << dac->sdi;
		}else{
			GPIO_CLR = 1 << dac->sdi;
		}

		// Data is set, so clk
		GPIO_SET = 1 << dac->sck;
		GPIO_CLR = 1 << dac->sck;

	}

	// Signal that the process is over
	GPIO_SET = 1 << dac->cs_n;

	return 1;

} // end setVout( Mcp4901 *,
