/******************************************************************************
 *
 *  mcp4901.h
 *
 *  Author     : Dallas Fletchall
 *  Date       : Apr 30, 2014 11:51:42 PM
 *  Description: mcp4901.h, defines all necessary components for the MCP4901
 *               digital-to-analog converter. Implementation handled in
 *               mcp4901.c
 *
 *****************************************************************************/
#ifndef MCP4901_H_
#define MCP4901_H_

#include <stdio.h>
#include <stdint.h>

typedef struct{

	uint8_t sdi;
	uint8_t sck;
	uint8_t cs_n;
	double  vref;

}Mcp4901;

void mcp4901Setup( Mcp4901 *dac,
		           uint8_t aSdi,
		 	       uint8_t aSck,
		 	       uint8_t aCs_n,
		 	       double  aVref
		 	     );

int mcp4901SetVout( Mcp4901 *dac, double aVoltage );


#endif /* MCP4901_H_ */
