/******************************************************************************
 *
 *  rpi.h
 *
 *  Author     : Pieter-Jan www.pieter-jan.com/node/15
 *  Date       : Apr 30, 2014 11:48:43 PM
 *  Description: rpi.h, Based off of implementation of Pieter-Jan.
 *               Entire implementation not necessary, only some portions
 *               Modifications made by Dallas Fletchall
 *
 *****************************************************************************/
#ifndef RPI_H_
#define RPI_H_

#include <stdio.h>

#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <unistd.h>

#define BCM2708_PERI_BASE   0x20000000
#define GPIO_BASE           (BCM2708_PERI_BASE + 0x200000 ) // GPIO Controller

#define BLOCK_SIZE          ( 4 * 1024 )

// IO Access
struct bcm2835_peripheral{
    unsigned long          addr_p;
    int                    mem_fd;
    void                  *map;
    volatile unsigned int *addr;
};


extern struct bcm2835_peripheral gpio; // They have to be found somewhere, but cant be in the header

#define INP_GPIO(g) (*(gpio.addr + ((g)/10)) &= ~(7<<(((g)%10)*3)))
#define OUT_GPIO(g) (*(gpio.addr + ((g)/10)) |= (1<<(((g)%10)*3)))
#define SET_GPIO_ALT(g,a) (*(gpio.addr + ((g)/10)) |= (((a)<=3?(a) + 4: (a) == 4?3:2) << (((g)%10)*3)))

#define GPIO_SET   (*(gpio.addr + 7))
#define GPIO_CLR   (*(gpio.addr + 10 ))

#define GPIO_READ(g) *(gpio.addr + 13) &= (1<<(g))

int map_peripheral( struct bcm2835_peripheral *p );

void unmap_peripheral( struct bcm2835_peripheral *p );


#endif /* RPI_H_ */
