/*
 ============================================================================
 Name        : SongProRetro.c
 Author      : Alex Harper
 Version     :
 Copyright   : Song Pro Retro
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <string.h>
#include "noteConversion.h"
#include <math.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define PI 3.14159265
#define comSize 15050

FILE *fpsong;
pthread_t songBoot, songRun, toneRun, comCommand, comOut, toneWriteThread;
song *songTemp;
char title[150];
unsigned long *PFDR, *PFDDR, *PBDR, *PBDDR;
unsigned char *start;
RTIME period;

struct sockaddr_in anybody, from;
struct hostent *hp;
char comBufferCommand[comSize];
char comBufferFrame[comSize];
long valBuffer;
char boardIP[15];
char *boardID;
int len, sockID, n;
char host[64];
int boolval;

Frame *writeFrame;

//global flags
volatile int songFlag, startFlag, endFlag;

void cls(void){
	int printf(char*,...);
	printf("%c[2J",27);
}

void songClear(song *songa){
    tone *current;
    int j, k;
    int i = songa->length;
    while(1){
        k = 0;
        current = songa->start;
        if(i > 0){
            for(j = 0; j < i; j++){
                current = current->next;
            }
            free(current);
            i--;
        }
        if(i == 0){
            free(songa);
            break;
        }
    }
    return;
}

void *comThreadCommand(void *ptr){
while(1){
	bzero(&comBufferCommand, comSize);
	//printf("Before received Data.  \n");
	//recvfrom(sockID, comBufferCommand, comSize, 0, (struct sockaddr *)&anybody, &len);
	anybody.sin_addr.s_addr = inet_addr("10.3.52.255");
	strcpy(comBufferCommand, "HEY!");
	n = sendto(sockID, comBufferCommand, sizeof(comBufferCommand), 0, (struct sockaddr *)&anybody, len);
	printf("%d\n", n);
	recvfrom(sockID, comBufferCommand, comSize, 0, (struct sockaddr *)&from, &len);
	//printf("%s", comBufferCommand);
	if(strcmp(comBufferCommand, "&LIST") == 0){
		sprintf(comBufferCommand, "#~%s", boardID);
		n = sendto(sockID, comBufferCommand, sizeof(comBufferCommand), 0, (struct sockaddr *)&anybody, len);
		if(n == -1){
			printf("Error Number: %d\n", n);
		}
		//printf("%s", comBufferCommand);
	}
	else if(strcmp(comBufferCommand, "&START") == 0){
		//printf("Got here!");
		//fflush(stdout);
		startFlag = 0;
	}
	else if(strcmp(comBufferCommand, "&END") == 0){
		endFlag = 0;
		exit(0);
	}
	//sleep(1);
	//startFlag = 0;
}
pthread_exit(0);
}

void *comThreadOut(void *ptr){
	SubFrame *currFrame;
	currFrame = (SubFrame*)ptr;
	int i;
	int j = 0;
	//wait for signal to start generating socket messages to send to the server
	while(startFlag != 0){
	    i = 0;
	}
	RT_TASK* communeOut = rt_task_init(nam2num("comm"), 0, 512, 256);
	rt_task_make_periodic(communeOut, (rt_get_time() + 1000 * period), (5000 * period));
	while(endFlag != 0){
		bzero(&comBufferFrame, comSize);
		sprintf(comBufferFrame, "@~%d~%s", j, boardID);
		for(i = 0; i < 1000; i++){
			//printf("COM Thread Buff ID: %d\n", currFrame->buffID);
					//fflush(stdout);
			//generate the message containing samples chained together
			sprintf(comBufferFrame, "%s~%d", comBufferFrame, currFrame->value);
			currFrame = currFrame->next;
			rt_sleep(2 * period);
		}
		n = sendto(sockID, comBufferFrame, sizeof(comBufferFrame), 0, (struct sockaddr *)&anybody, len);
		printf("%s\n", comBufferFrame);
		j++;
		rt_task_wait_period();
	}
pthread_exit(0);
}

void *toneWrite(void *ptr){
	SubFrame *currFrame;
	currFrame = (SubFrame*)ptr;
	int i;
	//wait for song start signal to begin sampling sound from song
	while(startFlag != 0){
		i = 0;
	}
	RT_TASK* toneWr = rt_task_init(nam2num("toneWr"), 0, 512, 256);
	rt_task_make_periodic(toneWr, rt_get_time(), (5 * period));
	//sample audio and pass it to the sample buffer
	while(endFlag != 0){
		//printf("WRITE Thread Buff ID: %d\n", currFrame->buffID);
		//fflush(stdout);
			currFrame->value = valBuffer;
			currFrame = currFrame->next;
		rt_task_wait_period();
	}
pthread_exit(0);
}

void *toneExe(void *ptr){
    tone *tonea;
	tonea = (tone*)ptr;
    int i;
    RT_TASK* rttasktone = rt_task_init(nam2num("tone"), 0, 512, 256);
    rt_task_make_periodic(rttasktone, rt_get_time(), (tonea->frequency / 2000)*period);
    i = 0;

    //generate tone at specified frequency
    while(*tonea->songFlag != 1 && songFlag == 0){
    	valBuffer = tonea->volume;
        rt_task_wait_period();
        valBuffer = 0x00;
        rt_task_wait_period();
     }
    pthread_exit(0);
}

void *songExe(void *ptr){
    tone *toneTemp;
    song *songa;
    long duration;
	songa = (song*)ptr;
    toneTemp = songa->start;
    int i;
    int j = 0;
    //wait for signal to start song
    while(startFlag != 0){
        i = 0;
    }
    RT_TASK* rttaskSong = rt_task_init(nam2num("song"), 1, 512, 256);
    rt_task_make_periodic(rttaskSong, rt_get_time(), 1000000*period);
    while(toneTemp != NULL && songFlag == 0){
    	j++;
        songa->songFlag = 0;
        duration = toneTemp->realduration;
        //start a tone generation thread
        pthread_create(&toneRun, NULL, (void *) &toneExe, (void *)toneTemp);
        toneTemp = toneTemp->next;
        //let tone generation thread run for specified duration, then signal it to stop
        rt_sleep(nano2count((unsigned)duration));
        songa->songFlag = 1;
        //pthread_kill(toneRun, 0);
        pthread_join(toneRun, NULL);
    }
    exit(0);
    songClear(songa);
    pthread_exit(0);
}

void *songInit(void *ptr){
    char temp[14];
    char tempDur[2];
    char *cpoint;
    int songHour, songMin, songSec;
    double songBreak;
    int i;
    float songRatio;
    song *songa;
	songa = (song*)ptr;
    songa->fpsong = fopen(songa->directory, "r");
    if(songa->fpsong == NULL){
        printf("Could not load file!\n");
        pthread_exit(0);
    }

    //obtain song info from file header
    fgets(songa->title, sizeof(songa->title), songa->fpsong);
    fscanf(songa->fpsong, "%d", &songa->tempo);
    strcpy(title, songa->title);
    printf("\n%s", songa->title);
    printf("Tempo: %d\n", songa->tempo);

    tone *currenta = malloc(sizeof(tone));
    songa->start = currenta;

    //burn first unused line
    fgets(temp, sizeof(temp), songa->fpsong);
    songa->length = 0;
    songa->total = 0;
    //pull info from .sng file and store in linked list
    while(1){

        //obtain info and parse into each datum
        while(1){
            fgets(temp, sizeof(temp), songa->fpsong);
            if(temp[0] != '\n' && temp[0] != '/'){
                break;
            }
        }
        currenta->base = temp[0];
        cpoint = &temp[2];
        currenta->octave = atoi(cpoint);
        currenta->sign = temp[4];
        cpoint = &temp[6];
        currenta->volume = 25 * atoi(cpoint);
        printf("%d\n", currenta->volume);
        tempDur[0] = temp[8];
        tempDur[1] = temp[9];
        currenta->duration = atoi(tempDur);
        songa->total += (1/((float)currenta->duration));
        currenta->next = NULL;
        songa->length++;
        if(feof(songa->fpsong)){
            break;
        }
        tone *temp = malloc(sizeof(tone));
        currenta->next = temp;
        currenta = temp;
    }
    fclose(songa->fpsong);
    currenta = songa->start;

    //convert written notes into frequencies
    noteconvert(songa);

    //determine the length of the song
    songa->total = songa->total * 4;
    songBreak = (60 / (double)songa->tempo) * (double)songa->total;
    printf("\n%lf\n",songBreak);
    songSec = songBreak;
    while(1){
    	if(songSec < 60)
    		break;
    	else{
    		songSec = songSec - 60;
    	}
    }
    songMin = songBreak / 60;
    songHour = songBreak / 3600;
    printf("Time: %d:%d:%d\n", songHour, songMin, songSec);
    fflush(stdout);

    //initialize the command thread and song execution thread
    pthread_create(&comCommand, NULL, (void *) &comThreadCommand, NULL);
    pthread_create(&songRun, NULL, (void *) &songExe, (void *)songTemp);
    pthread_exit(0);
}

int main(int argc, char *argv[])
{
	startFlag = 1;
	endFlag = 1;

	//obtain the port to use
	if(argc < 2){
		printf("Not a real port");
		return 0;
	}
	cls();
    char directory[150];
    int i, j;
	char IPTemp[15];

	SubFrame *temp;
    SubFrame *FrameStart;

    //initialize circular comBuffer
    for(i = 0; i < 4000; i++){
    	if(i == 0){
    		temp = malloc(sizeof(SubFrame));
			FrameStart = temp;
    	}
    	temp->buffID = i;
    	//printf("ID: %d", temp->buffID);
    	//fflush(stdout);
    	if(i < 3999){
    		temp->next = malloc(sizeof(SubFrame));
    		temp = temp->next;
    	}
    	else if(i == 3999){
    		temp->next = FrameStart;
    	}
    }
    printf("Finished buffer setup\n");

    //initialize the socket
    boolval = 1;
    sockID = socket(AF_INET, SOCK_DGRAM, 0);

    //get IP address
	len = sizeof(struct sockaddr_in);
	gethostname(host, 64);
	hp = gethostbyname(host);
	strcpy(boardIP, inet_ntoa(*((struct in_addr *)hp->h_addr)));
	printf("\nIP address: %s\n", boardIP);
	fflush(stdout);

	anybody.sin_family = AF_INET;
	anybody.sin_port = htons(atoi(argv[1]));
	//anybody.sin_addr.s_addr = htonl(INADDR_ANY);
	memcpy((void *)&anybody.sin_addr, hp->h_addr_list[0], hp->h_length);

	//bind(sockID, (struct sockaddr *)&anybody, len);
	if(setsockopt(sockID, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0){
		printf("Error occured when setting socket to broadcast!\n");
		exit(-1);
	}

	//obtain the board number from IP address
	strcpy(IPTemp, boardIP);
		boardID = strtok(IPTemp, ".");
		boardID = strtok(NULL, ".");
		boardID = strtok(NULL, ".");
		boardID = strtok(NULL, ".");

    //initialize Register memory page
    fflush(stdout);
    int fd = open("/dev/mem", O_RDWR | O_SYNC);
    start = (unsigned char*)mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x80840000);
    PBDR = (unsigned long*)((unsigned char*)start + 0x04);
    PBDDR = (unsigned long*)((unsigned char*)start + 0x14);
    *PBDDR |= 0xFF;

    //set the period
    period = start_rt_timer(nano2count(100000));

    //generate tone definitions
    defInit();

    //select a song
    while(1){
        song *songa;
        printf("Enter a song path (or 'q' to quit): ");
        fflush(stdout);
        scanf("%s", directory);
        songFlag = 1;
        usleep(10000);
        pthread_kill(songBoot, 0);
        pthread_kill(songRun, 0);
        pthread_kill(toneRun, 0);
        if(directory[0] == 'q' && directory[1] == '\0'){
            return 0;
        }
        else{
            songFlag = 0;
            songa = malloc(sizeof(song));
            for(i = 0; i < 150; i++){
                songa->directory[i] = directory[i];
            }
            songTemp = songa;
            cls();
            pthread_create(&songBoot, NULL, (void *) &songInit, (void *)songa);
            pthread_create(&toneWriteThread, NULL, (void *) &toneWrite, (void *)FrameStart);
            pthread_create(&comOut, NULL, (void *) &comThreadOut, (void *)FrameStart);
            usleep(500000);
        }
    }
    return 0;
}

