/*
 ============================================================================
 Name        : SongProRetro.c
 Author      : Alex Harper
 Version     :
 Copyright   : Song Pro Retro
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <string.h>
#include "noteConversion.h"
#include <math.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#define PI 3.14159265

FILE *fpsong;
pthread_t songBoot, songRun, toneRun;
song *songTemp;
volatile int songFlag;
unsigned long *PFDR, *PFDDR, *PBDR, *PBDDR;
unsigned char *start;
RTIME period;

void cls(void){
	int printf(char*,...);
	printf("%c[2J",27);
}
void songClear(song *songa){
	//clean up the memory used by the song structure
    tone *current;
    int j, k;
    int i = songa->length;
    while(1){
        k = 0;
        current = songa->start;
        if(i > 0){
            for(j = 0; j < i; j++){
                current = current->next;
            }
            free(current);
            i--;
        }
        if(i == 0){
            free(songa);
            break;
        }
    }
    return;
}

void *toneExe(void *ptr){
	//generate the played on the speaker
    tone *tonea;
	tonea = (tone*)ptr;
    int i;
    RT_TASK* rttasktone = rt_task_init(nam2num("tone"), 1, 512, 256);
    rt_task_make_periodic(rttasktone, rt_get_time(), (tonea->frequency / 500)*period);
    i = 0;
    while(*tonea->songFlag != 1 && songFlag == 0){
    	*PBDR |= tonea->volume;
        rt_task_wait_period();
        *PBDR &= 0x00;
        rt_task_wait_period();
     }
    *PBDR &= 0x00;
    pthread_exit(0);
}

void *songExe(void *ptr){
    tone *toneTemp;
    song *songa;
    long duration;
	songa = (song*)ptr;
    toneTemp = songa->start;

    //loads a tone, and runs it in the toneExe thread, until the duration completes
    while(toneTemp != NULL && songFlag == 0){
        songa->songFlag = 0;
        duration = toneTemp->realduration;
        pthread_create(&toneRun, NULL, (void *) &toneExe, (void *)toneTemp);
        toneTemp = toneTemp->next;
        usleep((unsigned)duration / 1000);
        songa->songFlag = 1;
        usleep(1000);
        pthread_kill(toneRun, 0);
        pthread_join(toneRun, NULL);
    }
    *PBDR &= 0x00;
    songClear(songa);
    pthread_exit(0);
}

void *songInit(void *ptr){
    char temp[14];
    char tempDur[2];
    char *cpoint;
    int songHour, songMin, songSec;
    double songBreak;
    float songRatio;
    song *songa;
	songa = (song*)ptr;
    songa->fpsong = fopen(songa->directory, "r");
    if(songa->fpsong == NULL){
        printf("Could not load file!\n");
        pthread_exit(0);
    }

    //obtain song info from file header
    fgets(songa->title, sizeof(songa->title), songa->fpsong);
    fscanf(songa->fpsong, "%d", &songa->tempo);
    printf("\n%s", songa->title);
    printf("Tempo: %d\n", songa->tempo);

    tone *currenta = malloc(sizeof(tone));
    songa->start = currenta;

    //burn first unused line
    fgets(temp, sizeof(temp), songa->fpsong);
    songa->length = 0;
    songa->total = 0;
    //pull info from .sng file and store in linked list
    while(1){
        //obtain info and parse into each datum
        while(1){
            fgets(temp, sizeof(temp), songa->fpsong);
            if(temp[0] != '\n' && temp[0] != '/'){
                break;
            }
        }
        currenta->base = temp[0];
        cpoint = &temp[2];
        currenta->octave = atoi(cpoint);
        currenta->sign = temp[4];
        cpoint = &temp[6];
        currenta->volume = 25 * atoi(cpoint);
        tempDur[0] = temp[8];
        tempDur[1] = temp[9];
        currenta->duration = atoi(tempDur);
        songa->total += (1/((float)currenta->duration));
        currenta->next = NULL;
        songa->length++;
        if(feof(songa->fpsong)){
            break;
        }
        tone *temp = malloc(sizeof(tone));
        currenta->next = temp;
        currenta = temp;
    }
    fclose(songa->fpsong);
    currenta = songa->start;
    noteconvert(songa);

    //calculate the runtime for the song, and print it to the screen
    songa->total = songa->total * 4;
    songBreak = (60 / (double)songa->tempo) * (double)songa->total;
    songSec = songBreak;
    while(1){
    	if(songSec < 60)
    		break;
    	else{
    		songSec = songSec - 60;
    	}
    }
    songMin = songBreak / 60;
    songHour = songBreak / 3600;
    printf("Time: %d:%d:%d\n", songHour, songMin, songSec);
    fflush(stdout);
    pthread_create(&songRun, NULL, (void *) &songExe, (void *)songTemp);
    pthread_exit(0);
}

int main(void)
{
	cls();
    char directory[150];
    int i;

    //initialize port F
    int fd = open("/dev/mem", O_RDWR | O_SYNC);
    start = (unsigned char*)mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x80840000);
    PFDR = (unsigned long*)((unsigned char*)start + 0x30);
    PFDDR = (unsigned long*)((unsigned char*)start + 0x34);
    PBDR = (unsigned long*)((unsigned char*)start + 0x04);
    PBDDR = (unsigned long*)((unsigned char*)start + 0x14);
    *PBDDR |= 0xFF;
    *PFDDR |= 0x02;
    period = start_rt_timer(nano2count(100000));
    defInit();
    //select a song
    while(1){
        song *songa;
        printf("Enter a song path (or 'q' to quit): ");
        fflush(stdout);
        scanf("%s", directory);
        songFlag = 1;
        usleep(10000);
        pthread_kill(songBoot, 0);
        pthread_kill(songRun, 0);
        pthread_kill(toneRun, 0);
        if(directory[0] == 'q' && directory[1] == '\0'){
            return 0;
        }
        else{
            songFlag = 0;
            songa = malloc(sizeof(song));
            for(i = 0; i < 150; i++){
                songa->directory[i] = directory[i];
            }
            songTemp = songa;
            cls();
            pthread_create(&songBoot, NULL, (void *) &songInit, (void *)songa);
            usleep(500000);
        }
    }
    return 0;
}

