/*
 ============================================================================
 Name        : SongProRetroServer.c
 Author      : Alex Harper
 Version     :
 Copyright   : SongProRetroServer
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <string.h>
#include "noteConversion.h"
#include <math.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define comSize 15050
pthread_t player, com;
RTIME period;

int sockID, n;
socklen_t len;
int flag;
char buff[comSize];
char boardIP[15];
char IPTemp[15];
char host[64];
char *boardID, *valIn;
int frameNum;
int startFlag;
int listFlag;
int numClients;

//socket variables
socklen_t fromLen;
struct sockaddr_in server;
struct sockaddr_in address;

//Pin Port variables
unsigned long *PBDR, *PBDDR;
unsigned char *start;

void *comIn(void *ptr){
	SubFrame *currFrame;
	currFrame = (SubFrame*)ptr;
	SubFrame *temp = currFrame;
	frameNum = 0;

	int oldFrame;
	int i;
	n = recvfrom(sockID, buff, comSize, 0, (struct sockaddr *)&address, &fromLen);

	if(numClients == 0){
		printf("No Clients Available!!!\n");
		fflush(stdout);
		exit(0);
	}


	printf("Starting in:\n");
	fflush(stdout);
	printf("...3\n");
	fflush(stdout);
	sleep(1);
	printf("...2\n");
	fflush(stdout);
	sleep(1);
	printf("...1!\n");
	fflush(stdout);
	sleep(1);
	bzero(&buff, comSize);
	strcpy(buff, "&START");
	address.sin_addr.s_addr = inet_addr("10.3.52.255");
	n = sendto(sockID, buff, comSize, 0, (struct sockaddr *)&address, fromLen);
	if(n == -1){
		printf("Error Number: %d\n", n);
	}

	printf("Starting task!\n");
	fflush(stdout);
	RT_TASK* communeIn = rt_task_init(nam2num("comm"), 0, 512, 256);
	rt_task_make_periodic(communeIn, rt_get_time(), (2000 * period));
	while(1){
		while(1){
			bzero(&buff, comSize);
			n = recvfrom(sockID, buff, comSize, 0, (struct sockaddr *)&address, &fromLen);
			if(buff[0] == '@')
				break;
		}
		valIn = strtok(buff, "~");
		frameNum = atoi(strtok(NULL, "~"));
		if(frameNum >= oldFrame){
			if(frameNum > oldFrame){
				oldFrame = frameNum;
			}
			if(frameNum == oldFrame){
				currFrame = temp;
			}
			valIn = strtok(NULL, "~");
			temp = currFrame;
			for(i = 0; i < 500; i++){
				currFrame->value = (atoi(strtok(NULL, "~")) / numClients);
				currFrame = currFrame->next;
				rt_sleep(2 * period);
			}
		}
		rt_task_wait_period();
	}
	pthread_exit(0);
}

void *playerOut(void *ptr){
	SubFrame *currFrame;
	currFrame = (SubFrame*)ptr;
	printf("Before Player Task!\n");
	RT_TASK* playOut = rt_task_init(nam2num("player"), 0, 512, 256);
	rt_task_make_periodic(playOut, (rt_get_time() + (1000 * period)), (5 * period));
	while(1){
		if(frameNum > 0){
		*PBDR = currFrame->value;
		currFrame = currFrame->next;
		}
		rt_task_wait_period();
	}
	pthread_exit(0);
}

int main(int argc, char *argv[]) {
	//enter a port
	if(argc < 2){
		printf("Not a real port");
		return 0;
	}
	//initialize values of variables
	int i, j;
	flag = 1;
	startFlag = 0;
	listFlag = 1;
	char trigger = 'x';

	//initialize the socket
	sockID = socket(AF_INET, SOCK_DGRAM, 0);
	len = sizeof(struct sockaddr_in);

	//clear the buffer
	bzero(&server, len);

	//setup the port information
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = htonl(INADDR_ANY);
	server.sin_port = htons(atoi(argv[1]));

	//bind the socket
	bind(sockID, (struct sockaddr *)&server, len);
	setsockopt(sockID, SOL_SOCKET, SO_BROADCAST, &flag, sizeof(flag));
	fromLen = sizeof(struct sockaddr_in);

	//determine the IP address of the system
	gethostname(host, 64);
	struct hostent *p = gethostbyname(host);
	strcpy(boardIP, inet_ntoa(*((struct in_addr *)p->h_addr)));
	printf("\nIP address: %s\n", boardIP);
	fflush(stdout);

	//obtain board number
	strcpy(IPTemp, boardIP);
	boardID = strtok(IPTemp, ".");
	boardID = strtok(NULL, ".");
	boardID = strtok(NULL, ".");
	boardID = strtok(NULL, ".");

	SubFrame *temp;
	SubFrame *FrameStart;
	for(i = 0; i < 4000; i++){
	    if(i == 0){
	    	temp = malloc(sizeof(SubFrame));
			FrameStart = temp;
	    }
	    temp->buffID = i;
	    if(i < 3999){
	    	temp->next = malloc(sizeof(SubFrame));
	    	temp = temp->next;
	    }
	    else if(i == 3999){
	    	temp->next = FrameStart;
	    }
	}


			//setup the pin port registers
		    int fd = open("/dev/mem", O_RDWR | O_SYNC);
		    start = (unsigned char*)mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x80840000);
		    PBDR = (unsigned long*)((unsigned char*)start + 0x04);
		    PBDDR = (unsigned long*)((unsigned char*)start + 0x14);
		    *PBDDR |= 0xFF;

			period = start_rt_timer(nano2count(100000));

			printf("How many clients: ");
			scanf("%d", &numClients);

			pthread_create(&com, NULL, (void *) &comIn, (void *)FrameStart);
			printf("Initialized com thread\n");
			fflush(stdout);
			pthread_create(&player, NULL, (void *) &playerOut, (void *)FrameStart);
			printf("Initialized player thread\n");
			fflush(stdout);

	//main loop
	while(1){
		printf("Enter q to exit: ");
		scanf("%c", &trigger);
		if(trigger == 'q')
			break;
	}
	return EXIT_SUCCESS;
}

