/*
 * noteConversion.h
 *
 *  Created on: Apr 22, 2014
 *      Author: alhhbf
 */

#ifndef Song_Pro_Retro_noteConversion_h
#define Song_Pro_Retro_noteConversion_h
struct tonedef{
    char base;
    int octave;
    char sign;
    int volume;
    long frequency;
    int duration;
    long realduration;
    int *songFlag;
    struct tonedef *next;
};
typedef struct tonedef tone;

struct songdef{
    int tempo;
    char title[150];
    struct tonedef *start;
    struct notedef *def;
    int length;
    FILE *fpsong;
    char directory[150];
    int songFlag;
    double total;
};
typedef struct songdef song;

struct notedef{
    char base;
    int octave;
    char sign;
    long frequency;
    struct notedef *next;
};
typedef struct notedef definition;

struct buffSub{
	int buffID;
    int value;
    struct buffSub *next;
};
typedef struct buffSub SubFrame;

struct buffFrame{
	int buffer[100];
	int buffID;
    struct buffSub *start;
    struct buffFrame *next;
};
typedef struct buffFrame Frame;

char fcheck(FILE *file) {
    char c;
    c = fgetc(file);
    ungetc(c, file);
    return c;
}

definition *def;

void defInit(void){
    definition *defTemp = malloc(sizeof(definition));
    definition *defCurr;
    defCurr = defTemp;
    FILE *defFile = fopen("definitions.txt", "r");
    if( defFile == NULL ){
    	perror("fopen");
    }
    //while(EOF != fscanf(defFile, "%c%d%c%ld", &defCurr->base, &defCurr->octave, &defCurr->sign, &defCurr->frequency)){

    while(1){
    	if(feof(defFile)){
    		break;
    	}
		  fscanf(defFile, "%c ", &defCurr->base);
		  fscanf(defFile, "%d ", &defCurr->octave);
		  fscanf(defFile, "%c ", &defCurr->sign);
		  fscanf(defFile, "%ld ", &defCurr->frequency);
        definition *temp = malloc(sizeof(definition));
        defCurr->next = temp;
        defCurr = defCurr->next;
    }
    //printf("got here!");
    //fflush(stdout);
    fclose(defFile);
    defCurr = defTemp;
    /*while(defCurr != NULL){
        printf("\nbase: %c\noctave: %d\nsign: %c\nfrequency: %ld\n", defCurr->base, defCurr->octave, defCurr->sign, defCurr->frequency);
        defCurr = defCurr->next;
    }*/
    def = defTemp;
    return;
}

void noteconvert(struct songdef *start){
    struct tonedef *current;
    definition *currDef;
    currDef = def;
    current = start->start;
    int i = 0;
    while(current != NULL){
        //printf("%c\n", current->base);
        //fflush(stdout);
        i++;
        if(currDef->base == current->base && currDef->octave == current->octave && currDef->sign == current->sign){
        	current->frequency = currDef->frequency;
            //current->songFlag = malloc(sizeof(int));
            current->songFlag = &start->songFlag;
            //printf("%d\n", *current->songFlag);
            //current->frequency = 1000000000 * (1 / ((double)current->frequency));
            current->frequency = 8000000 * (1 / ((double)current->frequency / 1000));
            //current->frequency = current->frequency * 1000;
            current->realduration = 1000000000 * ((60 * 4) / ((double)current->duration * (double)start->tempo));
            current = current->next;
            currDef = def;
        }
        else{
            currDef = currDef->next;
            if(currDef == NULL){
                printf("\ntone not defined!\n");
                break;
            }
        }
    }
    return;
}

#endif

