/*
 * Project.c
 *
 *  Created on: May 12, 2015
 *      Author: ads6g7
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <time.h>

#define SIZE 40				//defines the max message size
#define LOCALIP localIP		//defines the local IP address, just a variable
#define MAXLENGTH 12		//defines the max length of the game arrray
#define PORTNUM 5050		//defines the port number, makes it easier to change if in one location

//function that will take in a message, output the message and error then exit the program.
//Parameters:
//		const char *msg	-> message that is to be printed out
//Returns:
//		Void
void error(const char *msg)
{
    perror(msg);
    exit(0);
}

//debug function that is used to read in a message and variable to print out for debugging purposes
//Parameters:
//		const char *msg		 -> this is the message that will always be printed out
//		const char *variable -> this won't be printed if NULL, will be printed otherwise
//Returns:
//		Void
void debug(const char *msg, const char *variable){
//	//if the variable is set to NULL then only print out the message
//	if(variable==NULL){
//		printf("DEBUG :: %s\n", msg);
//	}
//	//if the variable is not set to NULL then print out the message followed by the variable
//	else{
//		printf("DEBUG :: %s %s\n",msg,variable);
//	}
}

//trimwhitespace is a function that will read in a sting and eliminate any spaces that are found.
//This was useful when trying to decifer some of the read in messages that didn't have any spaces.
//Parameters:
//		char *str	-> the string that needs blank spaces eliminated
//Returns:
//		char*		-> returns the newly created spaceles string
char *trimwhitespace(char *str)
{
  char *end;

  // Trim leading space
  while(isspace(*str)) str++;

  if(*str == 0)  // All spaces?
    return str;

  // Trim trailing space
  end = str + strlen(str) - 1;
  while(end > str && isspace(*end)) end--;

  // Write new null terminator
  *(end+1) = 0;

  return str;
}

//This function is meant to print out the pattern to the opponent by flashing each letter,
//waiting a while and then backspacing and prints out an X to mask the pattern as it goes.
//Parameters:
//		char *array -> the array that is to be printed out
//		int length  -> the length of the array that needs printing
//Returns:
//		Void
void printSays(char *array, int length){
	//NEEDS WORK: I've tried to do this a few different ways and even looked up several ways to do this,
	//		      many have said to use the printf("\033[2D") method which would back track the cursor
	//			  two positions then write over that. The second way is to just backspace over the letter
	//			  and then rewrite the mask to terminal. When I try doing either method, it doesn't print out
	//			  the pattern and will instead rapidly switch to the X. Couldn't get this fully working yet
	int x,y;
	for(x=0;x<length; x++){
		printf("%c ",array[x]);
		for(y=0;y<100000000;y++){ 		}
		//printf("\033[%dD",1);
		printf("\b\b");
		for(y=0;y<100000;y++){ 		}
		printf("X ");
	}
}

//CheckAnswer tokenizes the opponents input and players input, then compares the two strings,
//if at any point the two don't match up then return 0. If they do match, then return 1.
//Parameters:
//		char *OppInput 		-> the opponents pattern
//		char *PlayerInput   -> the players input pattern
//		int length			-> the length of both patterns
//Returns:
//		integer				-> this integer returns 1 if correct answer, 0 if wrong answer
int CheckAnswer(char *OppInput, char *PlayerInput,int length){
	int x;
	char *O, *P;
	strtok(OppInput, " ");
	for(x=0;x<length;x++){
		O = strtok(OppInput," ");
		P = strtok(PlayerInput, " ");

		debug("DEBUG :: O = ",O);
		debug("DEBUG :: P = ",P);
		if(P != O){
			debug("DEBUG :: P and O don't match", NULL);
			return 0;
		}
	}
	return 1;
}

//function that just prints out the instructions when prompted to
//Parameters:
//		None
//Returns:
//		Void
void printInstructions(){
	printf("\n\n\n***********Welcome to Adam Says***********\n\n\n");
	printf("This is a simple memory game that will test your memory skills and push them to \ntheir limits.\n\n");

	printf("Once a game has been started you will use the following keys in order to play \n(CASE SENSITIVE): A, W, S, D.  ");
	printf("At the start of the game, you will only be \nallowed to enter 3 of the allowed letters and then ");
	printf("if your opponent gets them \nright, you can enter 4 allowed letters.  If your opponent gets those right,\n");
	printf("then it will switch to the opponent inputting allowed letters as well as \nincrementing to 5 letters\n");

	printf("\nThe pattern will continue this way switching back and forth after every even \nround (i.e. after 4, 6, 8, 10, etc.)");
	printf(" until you or your opponent enters a \ncommand wrong.\n\n");

	printf("If a wrong pattern is not input after using 12 letters, the game will reset \nthe pattern counter back to 3 ");
	printf("and then add another valid letter, which \nwill only be seen once you've reached this point\n\nGood Luck!!\n");
}


int main(int argc, char *argv[]){
	time_t t;						//sets up a time_t structure to use for random generator
	srand((unsigned) time(&t));		//sets up random generator based upon current time of day
	int sock, sendReceive;			//integer values used to determine if some functions were successful
	int flag = 1;					//flag used in setting up sockopt
	socklen_t fromlen;				//used to store the length of the socket
	struct sockaddr_in server;		//structure used for sending data to the server
	struct sockaddr_in addr;		//structure used for receiving data from the client
	struct ifreq ifr;				//used to dynamiclly get the IP address
	char localIP[10];				//used to stored the local IP address
	u_char hostname[50];			//stores the hostname
	int MasterFlag = 0;				//used as a boolean value to determine if I am the master or not
	int game = 1;					//used as a boolean value to determine if the game needs to run or not
	int turn = 3;					//used to keep track of the number of letters in the pattern (length of pattern)
	int verify;						//used as a boolean value to verify if something was right or not
	char *cbuffer = malloc(sizeof(char)*SIZE);			//buffer pointer that will store any character data
	char *gameArray = malloc(sizeof(char)*MAXLENGTH);	//this pointer is used to store the game pattern
	char *garbage = malloc(sizeof(char*)*SIZE);			//another buffer but takes in non useful data


	//creates the socket for connectionless communication
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	//checks if the socket was created
	if(sock < 0){
		error("Error with opening socket");
	}

	//gets the length of the sockaddr_in structure for use later
	fromlen = sizeof(struct sockaddr_in);

	//sets all bits of the server sockaddr_in variable to zero
	bzero(&server, sizeof(server));
	//symbol constant for Internet domain
	server.sin_family = AF_INET;
	//this allows reading from any server that is broadcasting
	server.sin_addr.s_addr = INADDR_ANY;
	//sets the port by converting it to a network byte order
	server.sin_port = htons(PORTNUM);

	//binds the socket together with the client and checks that it was bound correctly
	if(bind(sock,(struct sockaddr *)&server, sizeof(server)) < 0){
		error("Error with binding\n");
	}
	//sets up the socket option to be broadcast
	if(setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &flag, sizeof(flag)) < 0){
		error("Error with setting up  socket options\n");
	}

	//used to dynamically get the local IP address
	ifr.ifr_addr.sa_family = AF_INET;
	snprintf(ifr.ifr_name, IFNAMSIZ, "eth0");
	ioctl(sock, SIOCGIFADDR, &ifr);
	sprintf(localIP, "%s", inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr));

	//gets the host IP address and checks that it worked
	if(gethostname(hostname, sizeof(hostname))!=0){
		error("gethostname fail\n");
	}

	//prints out the instructions for the user
	printInstructions();

	//sets the cbuffer values to zero
	bzero(cbuffer, SIZE);
	while(1){
		//receives the message that was broadcasted
		sendReceive = recvfrom(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, &fromlen);
		if(sendReceive < 0){
			error("Error with recvfrom\n");
		}else{
			debug("MESSAGE WAS -> ", cbuffer);
			break;
		}
	}


	int val = 1;	//integer value that acts as a boolean value for the following loop
	//loop that waits till the user has entered valid data
	while(val){
		printf("Do you still want to play (Y or N)? ");
		char *answer = malloc(sizeof(char*)*SIZE);
		fgets(answer,sizeof(answer),stdin);
		//if the user entered n or N then exit the program
		if(answer[0] == 'N' || answer[0] == 'n'){
			printf("I'm sorry you feel that way, goodbye.\n\n");
			return 0;
		//if the user entered y or Y then prompt them to send a signal back to the client to start
		}else if(answer[0] == 'Y' || answer[0] == 'y'){
			printf("Type '$' and hit enter when ready to play\n");
			fgets(garbage, 3, stdin);
			garbage = trimwhitespace(garbage);
			debug("garbage = ", garbage);

			//if the user entered '$' then send the message "$ localIP"
			if(strncmp(garbage, "$", 1)==0){
				bzero(cbuffer, SIZE);
				sprintf(cbuffer, "$ %s", localIP);
				cbuffer[SIZE - 1] = '\0';
				addr.sin_addr.s_addr = inet_addr("10.3.52.255");

				debug("issue here : cbuffer = ", cbuffer);
				//sends out a message that was setup previously by sprintf
				sendReceive = sendto(sock, cbuffer, SIZE, 0,(struct sockaddr*)&addr, fromlen);
				if(sendReceive >= 0){
					debug("Sent successful ", cbuffer);
					val= 0;
					break;
				}else{
					error("Invalid commands using sendndto\n");
				}
			}
		//if the user did not enter valid date then have them retry
		}else{
			printf("Not a valid input! Try again!\n");
		}
	}

	//start up the game, this loop runs until game is over
	while(game){
		//sets the cbuffer bits to zero everytime, essentially clearing it
		bzero(cbuffer, SIZE);

		//receives the message that was broadcasted, prints error message and exits if invalid message
		sendReceive = recvfrom(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, &fromlen);
		if(sendReceive < 0){
			error("Error with recvfrom\n");
		}


		//prints out on the terminal what was received
		debug("Received the message: ", cbuffer);

		//if the user is the master then do the following
		if(MasterFlag){
			//if the
			if(turn != 0){
				//prompt the user to enter a pattern then read the pattern into gameArray
				printf("Enter %d characters now: ",turn);
				fgets(gameArray,SIZE,stdin);
				debug("You entered: ", gameArray);

				//setup the string to be sent where string should be "@ gameArray"
				bzero(cbuffer,SIZE);
				strcat(cbuffer, "@");
				sprintf(cbuffer, " %s", gameArray);
				cbuffer[SIZE-1] = '\0';

				//This sends cbuffer out to all boards on port PORTNUM
				addr.sin_addr.s_addr = inet_addr("10.3.52.255");
				sendReceive = sendto(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, fromlen);
				if(sendReceive < 0){
					error("Error with sendto1\n");
				}else{
					debug("Sent successfully: ", cbuffer);
				}

			}
			//if the turn is divisible by 2 then switch up the master
			else if(turn%2==0){
				MasterFlag = 0;
				printf("Switching up the master...\n");

				//sets up cbuffer to send out "!!SWITCH!!" which is the signal to switch master
				bzero(cbuffer,SIZE);
				sprintf(cbuffer, " %s", "!!SWITCH!!");
				cbuffer[SIZE-1] = '\0';

				//This sends cbuffer to all on port PORTNUM
				addr.sin_addr.s_addr = inet_addr("10.3.52.255");
				sendReceive = sendto(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, fromlen);
				if(sendReceive < 0){
					error("Error with sendto1\n");
				}else{
					debug("Sent successfully: ", cbuffer);
				}

			}else{
				if(cbuffer[0] == '#'){
					verify = CheckAnswer(cbuffer, gameArray, turn);
					if(verify == 1){
						printf("Your opponent responded correctly...Try again\n");
						printf("Enter %d characters now: ",turn);
						fgets(gameArray,SIZE,stdin);

						debug("You entered: ", gameArray);

						//setup cbuffer to be sent out with "@ gameArray"
						bzero(cbuffer,SIZE);
						strcat(cbuffer, "@");
						sprintf(cbuffer, " %s", gameArray);
						cbuffer[SIZE-1] = '\0';
						//This sends cbuffer after the input has been made**********
						addr.sin_addr.s_addr = inet_addr("10.3.52.255");
						sendReceive = sendto(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, fromlen);
						if(sendReceive < 0){
							error("Error with sendto1\n");
						}else{
							debug("Sent successfully: ", cbuffer);
						}

					}else if(verify==0){
						printf("CONGRATULATIONS!!!\nYOU WON!!!\n\n");
						printf("Returning to Menu\n\n");
						game = 0;
						break;
					}
				}else{
					debug("Error with '#' statement. cbuffer = ", cbuffer);
				}
			}

		//if users is not the master then look at what message is being read in
		}else if(!MasterFlag){
			//if message is recieved that begins with '@', do the following
			if(cbuffer[0] == '@'){
				//print out the pattern letter by letter while masking previous letters
				printSays(cbuffer, turn);
				//printSays doesn't exactly work, usually this print statement is a debug statent
				printf("opponent entered -> %s", cbuffer);

				//prompt the user for their response
				printf("\nResponse: ");
				fgets(gameArray, SIZE, stdin);

				debug("you entered -> ", gameArray);

				//set up your response in cbuffer
				bzero(cbuffer,SIZE);
				strcat(cbuffer, "#");
				sprintf(cbuffer, " %s", gameArray);
				cbuffer[SIZE-1] = '\0';

				//This sends cbuffer to all on port PORTNUM
				addr.sin_addr.s_addr = inet_addr("10.3.52.255");
				sendReceive = sendto(sock, cbuffer, SIZE, 0, (struct sockaddr *)&addr, fromlen);
				if(sendReceive < 0){
					error("Error with sendto1\n");
				}else{
					debug("Sent successfully: ", cbuffer);
				}

			//if cbuffer is equal to "!!SWITCH!!" then reset master flag high(true)
			}else if(strncmp(cbuffer,"!!SWITCH!!", 10)==0){
				MasterFlag = 1;
			}
		}
		//increment the turn(length of the pattern)
		turn++;
	}
	return 0;
}
