/*
 * Raspberry.c
 *
 *  Created on: May 12, 2015
 *      Author: ads6g7
 * Description: This is going to be the client UDP program that will be ran on the Raspberry Pi.
 * 				This program will also initiate the game, waiting for the opponent to respond before
 * 				starting the game when in multiplayer mode.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <time.h>

#define SIZE 50				//defines the max message size
#define MAXLENGTH 12		//defines the max length of the game array
#define LOCALIP localIP		//defines the local IP address, just a variable
#define PORTNUM 5050		//defines the port number, easier to find than searching if needed to be changed
const char valInput[] = {'A','S','D','W', 'Q','E'};	//constant character array of the valid data
char voidBuff[SIZE];		//just a character array used as a buffer

//function that will take in a message, output the message and error then exit the program.
//Parameters:
//		const char *msg	-> message that is to be printed out
//Returns:
//		Void
void error(const char *msg){
    perror(msg);
    exit(0);
}
//debug function that is used to read in a message and variable to print out for debugging purposes
//Parameters:
//		const char *msg		 -> this is the message that will always be printed out
//		const char *variable -> this won't be printed if NULL, will be printed otherwise
//Returns:
//		Void
void debug(const char *msg, const char *variable){
	//if the variable is set to NULL then only print out the message
	if(variable==NULL){
		printf("DEBUG :: %s\n", msg);
	}
	//if the variable is not set to NULL then print out the message followed by the variable
	else{
		printf("DEBUG :: %s %s\n",msg,variable);
	}
}

//function prototypes that are defined after main:
//checkAnswer is used to check if two strings match up or not
int CheckAnswer(char *OppInput, char *PlayerInput,int length);
//validateInput is used to verify that they have entered the correct letters for the game
int validateInput(char *input, int length, int game);
//printInstructions is just used to easily print out the game's instructions
void printInstructions();
//trimWhiteSpace is a function that will eliminate any spaces in a string
char *trimWhiteSpace(char *str);
//simulateInput is used to create the "Computer's" input when playing one player
char *simulateInput(int len, int game);
//computerPlay is used to guess the user's input
int computerPlay(char *userInput, int length, int game);
//printSays is used to print out the array to the opponent, should flash the data then mask it
void printSays(char *array, int length);


int main(int argc, char *argv[]){
	//defining variables:
	time_t t;						//sets up a time_t structure to use for random generator
	srand((unsigned) time(&t));		//sets up random generator based upon current time of day
	int sock, sendReceive;			//integer values used to determine if some functions were successful
	int flag = 1;					//flag used in setting up sockopt
	socklen_t fromlen;				//used to store the length of the socket
	struct sockaddr_in server;		//structure used for the sending data to the server
	struct sockaddr_in from;		//structure used for recieving the data from the server
	char buffer[SIZE];				//just a buffer that will store any character data
	struct ifreq ifr;				//used to dynamically get the IP address
	char localIP[10];				//stores the local IP address to this character array
	int MasterFlag;					//used as a boolean value to determine if I am the master or not
	int gameOn = 0;					//used as a boolean value to determine if the game needs to run or not
	char *buff = malloc(sizeof(char)*SIZE);		//buffer pointer that will store any character data
	char *debugger = malloc(sizeof(char)*SIZE);	//debugging pointer that is used for debugging strings
	int option1= -1, game=1;		//more variables used to run the game, option1 is the menu choice and game is the game boolean
	char *gameArray = malloc(sizeof(char)*MAXLENGTH);	//this pointer is used to locate the

	//creates the socket for connectionless communication
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	//checks if the socket was created
	if(sock < 0){
		error("ERROR :: Error with opening socket");
	}
	//gets the length of the sockaddr_in structure
	fromlen = sizeof(struct sockaddr_in);
	//sets all values to zeor. memset() could also be used
	bzero(&server, sizeof(server));
	//symbol constant for Internet domain
	server.sin_family = AF_INET;
	//this allows reading from any server that is broadcasting
	server.sin_addr.s_addr = INADDR_ANY;

	//sets up the socket permissions to broadcast and checks for errors simultaneously
	if(setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &flag, sizeof(flag)) < 0){
		error("DEBUG :: Error with setting up  socket options\n");
	}

	//this chunk of code was used to get the IP address dynamically
	ifr.ifr_addr.sa_family = AF_INET;
	snprintf(ifr.ifr_name, IFNAMSIZ, "eth0");
	ioctl(sock, SIOCGIFADDR, &ifr);
	sprintf(localIP, "%s", inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr));

	//sets the server to the correct port number and then sets the address to the nfs1 LAN allowing communication to all boards
	server.sin_port = htons(PORTNUM);
	server.sin_addr.s_addr = inet_addr("10.3.52.255");

	//prints out the instructions using printInstructions function
	printInstructions();

	//runs the game until the user selects 4 or is kicked out of the loop
	while(option1 != 4){
		//shows user options for the game
		printf("How would you like to play the game:\n");
		printf("\t1)Play computer\n");
		printf("\t2)Play Opponent\n");
		printf("\t3)See Instructions again\n");
		printf("\t4)Exit\n");
		printf("Select: ");
		//reads in the user option
		scanf("%d",&option1);
		//gets the null characters after the user option and discards them
		fgets(buff, 2,stdin);

		//switch statement that will control the user selected options.
		switch(option1){
			//case for when the user wants to play against a computer simulation
			case 1:
				///NEEDS WORK: the following is having issues with comparing the users data to the simulated
				///			   data if they are not the master. There are also some other misc issues that
				///			   can occur at different times. Didn't have enough time to fully debug this.

				//lets the user know that the game is starting
				printf("Initializing game against computer...\n");
				printf("The computer will initially be the master. Good Luck!\n");

				int length, num;	//these define the length set by the user and the num is just a dummy variable
				MasterFlag = 0;		//sets master flag to low at start
				int gameSize = 3;	//starts the game size at 3, meaning there are only the first 3 valid characters allowed

				//prompts the user for the length they want to initiate at, or starts at 3(DEFAULT)
				//will continue to loop until they have entered valid information
				while(1){
					printf("What count (of letters) would you like to start with?(Default=3, MAX=7): ");
					char *input = malloc(sizeof(char)*3);
					fgets(input, SIZE, stdin);
					input = trimWhiteSpace(input);
					if(atoi(input) == 0){
						length = 3;
						break;
					}
					else if(atoi(input) >7){
						printf("That's and invalid input. Try again.\n");
					}
					else{
						length = atoi(input);
						break;
					}
				}
				//clarifies for the user what letters are allowed currently
				printf("Valid letters are:");
				for(num=0;num<gameSize;num++){
					printf(" %c", valInput[num]);
				}

				//starts up the game, first checks if you are the master or not and then goes from there.
				//loops until the gameSize is set to 0
				while(gameSize!=0){
					//if the users is the master then they are the first to implement data
					if(MasterFlag){
						//prompts the user for their pattern
						printf("\nInput %d letters(i.e. A D S)\nmake sure to include spaces: ", length);
						//the double length and addition 1 accounts for the spaces and null terminator
						fgets(gameArray,(length+length+1),stdin);
						//checks if the user entered valid letters only
						int valid = validateInput(gameArray, strlen(gameArray), gameSize);
						//checks if they have entered valid letters and the length is appropriate
						if(strlen(gameArray) == length+(length-1) && valid == 1){
							//this will simulate how a computer would guess at the pattern
							int outcome = computerPlay(gameArray, length, gameSize);
							//debugging statement, wont do anything when the inards of debug are commented out
							sprintf(gameArray, "%d", outcome);
							debug("Outcome is -> ",gameArray);
							//if the outcome 1 then the computer matched your pattern
							if(outcome == 1){
								length++;
								printf("Computer matched letters.\n");

							//if the outcome is 0 then the computer guessed wrong
							}else if(outcome == 0){
								printf("You won!!!\nThe computer did not match your code!\n");
								gameSize = 0;

							//if none of the above then there was an error with the computer play function
							}else{
								error("ERROR :: Problem with outcome of computer play\n");
							}

							//checks if the user has made it to the max allowed pattern
							//if they have, then restart length at 3 and add a new valid letter
							if(length==13){
								printf("Congratulations, you've made it to the next round!\n");
								gameSize++;
								length = 3;
								printf("Valid letters are now:");
								for(num=0;num<gameSize;num++){
									printf(" %c", valInput[num]);
								}

							//checks if the length is divisible by two, if it is then switch masters
							}else if((length%2) == 0){
								MasterFlag = 0;
								printf("Switching up Master");
							}

						//if the pattern was not appropriate length or invalid data, output message saying so
						}else{
							printf("Sorry, there was a problem reading your input.\n");
							printf("Please make sure you're using only valid letters and using spaces to separate them.\n");
						}

					//if the user is not the master
					}else{
						printf("\n");
						//gets simulated data from the function simulateInput
						gameArray = simulateInput(length, gameSize);
						//flashes pattern on the screen then masks is
						printSays(gameArray, length);
						//was used to check the pattern when debugging
						debug("gameArray is: ", gameArray);

						//loop that checks if the user has submitted a valid input or not
						while(1){
							printf("Repeat the code: ");
							fgets(buff, length+length+4, stdin);

							//debugging stuff that only prints out when needed
							strcpy(debugger,buff);
							debug("buff string = ",debugger);
							sprintf(debugger, "%d", strlen(buff));
							debug("length of buff = ",debugger);
							sprintf(debugger, "%d", strlen(gameArray));
							debug("length of gA = ",debugger);

							//checks if the user input anything or if they didnt input a long enough pattern
							if(buff == NULL || strlen(buff) != (length+length)){
								printf("Invalid input, try again.\n");
							}
							else{
								//checks the results against the computers pattern using CheckAnswer function
								int results = CheckAnswer(gameArray, buff, length);

								//checks if they were equal to eachother
								if(results == 1){
									printf("Correct!\n");
									//checks if the length is divisible by 2 and switches master if it is
									if((length%2) == 0){
										MasterFlag = 1;
										printf("Switching up Master");
									}
									length++;
									printf("Increasing the length to %d",length);
									break;
								//if they arent equal to each other then let the user know
								}else if(results == 0){
									printf("Wrong!\n");
									printf("Looks like the computer beat you. Better luck next time\n");
									gameSize = 0;
									break;
								}
							}
						}

					}
				}
				break;

			//case for when the user wants to play against other users across a LAN
			case 2:
				///NEEDS WORK: This does not work properly.  The functionality is written different than
				///			   single player game. Some of the logic is wrong since I couldn't properly work
				///			   with as a client. I thought I had all the proper code after looking at the examples
				///			   provided, but turns out I was missing a few things such as the correct way of
				///			   setting up the client and how it would receive messages.  Currently it will
				///			   continue to run, but the functionality isn't working properly.  With more time
				///			   I would have been able to implement this functionality as well.
				printf("In order to play against opponent, first must have a valid opponent.");
				printf("  Once an opponent has been found, you can begin the game.\n");

				printf("Announce your challenge, Enter a name: ");
				char *playerName = malloc(sizeof(char)*SIZE);
				fgets(playerName, SIZE, stdin);

				bzero(buffer, SIZE);

				sprintf(buffer, "%s wants to play you in Adam Says", playerName);
				buffer[SIZE - 1] = '\0';
				debug("buffer about to send -> ", buffer);

				sendReceive = sendto(sock, buffer, SIZE, 0,(const struct sockaddr*)&server, fromlen);
				if(sendReceive < 0){
					error("Error with sendto1\n");
				}else{
					debug("Sent successfully: ", buffer);
				}

				printf("Initializing game against opponent...\n");
				printf("Waiting for opponent to enter game...\n");
				while(game){
					bzero(buffer, SIZE);

					sendReceive = recvfrom(sock, buffer, SIZE, 0, (struct sockaddr *)&from, &fromlen);
					if(sendReceive < 0 ){
						error("ERROR :: sendReceive error\n");
					}else{
						debug("success - > ", buffer);
					}

					debug("received -> ", buffer);
					if(buffer[0]=='$'){
						gameOn = 1;
						debug("Set gameOn to high", NULL);
					}
					if(gameOn == 1){
						debug("Inside gameOn", NULL);
						strtok(buffer, " ");
						char *OppIP = strtok(NULL, " ");

						printf("Opponent found at IP: %s\n", OppIP);
						printf("Prepare to start the game...\n");
						//sets the buffer bits to zero everytime, essentially clearing it
						bzero(buffer, SIZE);

						//Since this player initiates the game, they are the master at beginning
						MasterFlag = 1;
						int turn = 3;
						int verify = 2;
						while(game){
							//sets the buffer bits to zero everytime
							bzero(buffer, SIZE);

							if(MasterFlag){
								if(turn != 3){										///NEEDS WORK
									printf("Enter %d letters now: \n@",turn);
									fgets(gameArray,turn,stdin);
									debug("You entered: ", gameArray);

									bzero(buffer,SIZE);
									strcat(buffer, "@");
									sprintf(buffer, " %s", gameArray);
									buffer[SIZE-1] = '\0';
									//This sends buffer after the input has been made**********
									sendReceive = sendto(sock, buffer, SIZE, 0, (struct sockaddr *)&server, fromlen);
									if(sendReceive < 0){
										error("Error with sendto1\n");
									}else{
										printf("Sent successfully: %s\n", buffer);
									}

								}else if(turn%2==0){		///NEEDS WORK************
									MasterFlag = 0;
									printf("Switching up the master...\n");

									bzero(buffer,SIZE);
									sprintf(buffer, " %s", "!!SWITCH!!");
									buffer[SIZE-1] = '\0';
									//This sends buffer after the input has been made**********
									sendReceive = sendto(sock, buffer, SIZE, 0, (struct sockaddr *)&server, fromlen);
									if(sendReceive < 0){
										error("Error with sendto\n");
									}else{
										debug("Sent successfully: ", buffer);
									}

								}else{												///CHECK*******
									if(buffer[0] == '#'){
										verify = CheckAnswer(buffer, gameArray, turn);
										if(verify == 1){
											printf("Your opponent responded correctly...Try again\n");
											printf("Enter %d letters now: \n@ ",turn);
											fgets(gameArray,turn,stdin);
											debug("You entered: ", gameArray);

											bzero(buffer,SIZE);
											strcat(buffer, "@");
											sprintf(buffer, " %s", gameArray);
											buffer[SIZE-1] = '\0';
											//This sends buffer after the input has been made**********
											sendReceive = sendto(sock, buffer, SIZE, 0, (struct sockaddr *)&server, fromlen);
											if(sendReceive < 0){
												printf("Error with sendto1\n");
												return 1;
											}else{
												printf("Sent successfully: %s\n", buffer);
											}

										}else if(verify==0){
											printf("CONGRATULATIONS!!!\nYOU WON!!!\n\n");
											printf("Returning to Menu\n\n");
											game = 0;
											gameOn = 0;
											break;
										}
									}else{
										debug("Error with '#' statement. buffer = ", buffer);
									}
								}


							}else{													///CHECK*******
								if(buffer[0] == '@'){
									//flashInput(buffer, turn);				////*****************
									debug("opponent entered -> ", buffer);
									printf("Repeat patter: \n# ");
									fgets(gameArray, turn, stdin);
									debug("you entered -> ", gameArray);

									bzero(buffer,SIZE);
									strcat(buffer, "#");
									sprintf(buffer, " %s", gameArray);
									buffer[SIZE-1] = '\0';
									//This sends buffer after the input has been made**********
									sendReceive = sendto(sock, buffer, SIZE, 0, (struct sockaddr *)&server, fromlen);
									if(sendReceive < 0){
										error("Error with sendto1\n");
									}else{
										debug("Sent successfully: ", buffer);
									}

								}else if(strncmp(buffer,"!!SWITCH!!", 10)==0){
									MasterFlag = 1;
								}
							}

							turn++;
						}
					}
				}
				break;

			//case for if the user wants to read the instructions again
			case 3:
				///DONE
				printInstructions();
				break;

			//case for when the user is finished playing after getting to the menu
			case 4:
				///DONE
				printf("Exiting the game....");
				game = 0;
				gameOn = 0;
				printf("\nThanks for playing!\n");
				return 3;

			//default case if none of the above has been entered.
			default:
				///DONE
				printf("Invalid input, please enter a value between 1 and 3.\n");
				break;
		}

		//prompts the user asking if they want to coninue playing
		printf("Continue playing(Y or N)? ");
		fgets(buff, 2, stdin);
		//checks if they input n or N, if they did then exit the game
		if(buff[0] == 'N' || buff[0] == 'n'){
			printf("Exiting the game....\n");
			printf("Thanks for playing!\n");
			return 0;
		}
	}

	//frees up the memory that was allocated for the pointers
	free(gameArray);
	free(buff);
	free(debugger);

	return 0;
}

//function that just prints out the instructions when prompted to
//Parameters:
//		None
//Returns:
//		Void
void printInstructions(){
	printf("\n\n\n***********Welcome to Adam Says***********\n\n\n");
	printf("This is a simple memory game that will test your memory skills and push them to \ntheir limits.\n\n");

	printf("Once a game has been started you will use the following keys in order to play \n(CASE SENSITIVE): A, W, S, D.  ");
	printf("At the start of the game, you will only be \nallowed to enter 3 of the allowed letters and then ");
	printf("if your opponent gets them \nright, you can enter 4 allowed letters.  If your opponent gets those right,\n");
	printf("then it will switch to the opponent inputting allowed letters as well as \nincrementing to 5 letters\n");

	printf("\nThe pattern will continue this way switching back and forth after every even \nround (i.e. after 4, 6, 8, 10, etc.)");
	printf(" until you or your opponent enters a \ncommand wrong.\n\n");

	printf("If a wrong pattern is not input after using 12 letters, the game will reset \nthe pattern counter back to 3 ");
	printf("and then add another valid letter, which \nwill only be seen once you've reached this point\n\nGood Luck!!\n");
}

//This function is meant to print out the pattern to the opponent by flashing each letter,
//waiting a while and then backspacing and prints out an X to mask the pattern as it goes.
//Parameters:
//		char *array -> the array that is to be printed out
//		int length  -> the length of the array that needs printing
//Returns:
//		Void
void printSays(char *array, int length){
	//NEEDS WORK: I've tried to do this a few different ways and even looked up several ways to do this,
	//		      many have said to use the printf("\033[2D") method which would back track the cursor
	//			  two positions then write over that. The second way is to just backspace over the letter
	//			  and then rewrite the mask to terminal. When I try doing either method, it doesn't print out
	//			  the pattern and will instead rapidly switch to the X. Couldn't get this fully working yet
	int x,y;
	for(x=0;x<length; x++){
		printf("%c ",array[x]);
		for(y=0;y<1000000;y++){ 		}
		//printf("\033[%dD",1);
		printf("\b\b");
		//for(y=0;y<100000;y++){ 		}
		printf("X ");
	}
}

//This function is used to clean up any string from having spaces in it
//Parameters:
//		char *str -> the string that needs spaces cleared
//Returns:
//		char*		-> returns the newly created spaceles string
char *trimWhiteSpace(char *str){
  char *end;

  // Trim leading space
  while(isspace(*str)) str++;

  if(*str == 0)  // All spaces?
    return str;

  // Trim trailing space
  end = str + strlen(str) - 1;
  while(end > str && isspace(*end)) end--;

  // Write new null terminator
  *(end+1) = 0;

  return str;
}

//CheckAnswer tokenizes the opponents input and players input, then compares the two strings,
//if at any point the two don't match up then return 0. If they do match, then return 1.
//Parameters:
//		char *OppInput 		-> the opponents pattern
//		char *PlayerInput   -> the players input pattern
//		int length			-> the length of both patterns
//Returns:
//		integer				-> this integer returns 1 if correct answer, 0 if wrong answer
int CheckAnswer(char *OppInput, char *PlayerInput,int length){
	int x;
	char *O = malloc(sizeof(char)*SIZE);
	char *P = malloc(sizeof(char)*SIZE);

	O = trimWhiteSpace(OppInput);
	P = trimWhiteSpace(PlayerInput);
	debug("DEBUG :: O = ",O);
	debug("DEBUG :: P = ",P);

	if(strcmp(O, P) == 0)
		return 1;
	else
		return 0;
}

//validateInput is used to verify that the user has input valid letters into the pattern.
//returns 0 if an invalid letter was used, returns 1 if all were valid.
//Parameters:
//		char *input -> the pattern that is to be checked
//		int length  -> the length of the array that needs checking
//		int game	-> defines how many valid letters are currently allowed in the game, reference valInput array
int validateInput(char *input, int length, int game){
	int x,y;
	for(x=0;x<length;x++){
		for(y=0;y<game;y++){
			if(input[x] != valInput[y])
				return 0;
		}
	}
	return 1;
}

//simulateInput is used to create a randomly generated pattern based on random probabilities
//that are created within the function.  Once the pattern is created, it is then returned.
//Parameters:
//		int len 	  -> the length of the pattern that is needed
//		int gameSize  -> the valid letters currently allowed, referencing the valInput array
char *simulateInput(int len, int gameSize){
	int prob[gameSize], r,x,y,z;
	char result[len];
	char *sendInput = malloc(sizeof(char)*13);
	char *debugger = malloc(sizeof(char)*20);

	//loop that will set up the random probabilities for each in use letter
	for(y=0;y<gameSize;y++){
		r = (rand()%gameSize)+1;
		sprintf(debugger, "%c is %d",valInput[y],r);
		debug("\n",NULL);
		debug("Probability of ",debugger);
		prob[y] = r;
	}
	z=0;
	y = 0;
	//loop that will go through and check the highest probability in the prob array,
	//once the highest is found, it will use that letter then subtract from that
	//probability until another letter has a higher probability.
	while(z < len){
		for(x=0;x<gameSize;x++){
			//debugger stuff
			sprintf(debugger,"%d",prob[x]);
			debug("x = ",debugger);
			sprintf(debugger,"%d",prob[y]);
			debug("yB = ",debugger);
			//checks for highest probability
			if((prob[x] > prob[y])){
				y = x;
			}

		}
		//sets result then subtracts from that probabality
		result[z] = valInput[y];
		prob[y]--;
		//debugger stuff
		sprintf(debugger,"%d",prob[y]);
		debug("yA = ",debugger);
		sprintf(debugger, "%c ",result[z]);
		debug("result[z] = ", debugger);
		//concatenates the result to the sendInput
		strcat(sendInput, " ");
		strcat(sendInput, debugger);

		//increments the result aray
		z++;
	}
	//returns the final product
	return sendInput;

}

//computerPlay simulates how the computer would go about responding to the user's pattern.
//the probability of the computer matching the pattern is assumed to be 70% chance to allow
//a reasonably fair game so it's not a never ending game.
//Parameters:
//		char *userInput -> the users pattern that was created
//		int length  	-> the length of the pattern
//		int game 		-> refers to the valid letters of the current game, references valInput array
int computerPlay(char *userInput, int length, int game){
	//int comp[length],y;
	int x,r;
	int prob[] = {0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0};	//70% probability (10 chances of right out of 13)
	int count1 =0, count0=0; //count1 stores number of correct guesses, and count 0 stores number of wrong
	char *debugger = malloc(sizeof(char)*11);

	for(x=0;x<length;x++){
		//gets a random integer to reference prob array
		r = rand()%12;
		//debugging stuff
		sprintf(debugger, "%d",r);
		debug("random = ", debugger);
		sprintf(debugger, "%d", prob[r]);
		debug("prob = ", debugger);

		//if it hits a 1 in the prob array, add to count1
		if(prob[r] == 1){
			debug("adding to count1", NULL);
			count1++;

		//if it hits a 0 in the prob array, add to count0
		}else{
			debug("adding to count0", NULL);
			count0++;
		}
	}
	//debugging stuff
	sprintf(debugger, "1-%d vs 0-%d", count1, count0);
	debug("compare ::", debugger);

	//checks if the computer had more correct than wrong,
	//returns 1 if they had more correct.
	//returns 0 if they har more wrong.
	if(count1 > count0)
		return 1;
	else if(count1 < count0)
		return 0;

	//returns -1 if there was an error
	return -1;

	/*
	 * This was the first algorithm I came up with, but it was not as effective since it
	 * only used random numbers and not a probability aspect.  Since it's a computer, the
	 * computer should be able to recognize
	for(x=0;x<length;x++){
		for(y=0;y<game;y++){
			r = (rand()%game);
			sprintf(debugger, "%d",r);
			debug("random = ", debugger);
			sprintf(debugger,"%c", valInput[r]);
			debug("valInput = ", debugger);
			if(userInput[x] == valInput[r]){
				debug("inside comparison!", NULL);
				comp[x] = 1;
				break;
			}
		}
		if(comp[x] == 1){
			debug("adding to count1", NULL);
			count1++;
		}else{
			debug("adding to count0", NULL);
			count0++;
		}
	}
	sprintf(debugger, "1-%d vs 0-%d", count1, count0);
	debug("compare ::", debugger);
	if(count1 > count0)
		return 1;
	else if(count1 < count0)
		return 0;
	else{
		int tie = rand()%2;
		sprintf(debugger, "%d", tie);
		debug("TIEBREAKER->", debugger);
		return tie;
	}
	*/
}
