import RPi.GPIO as GPIO
import os
import glob
import time

os.system('modprobe w1-gpio')
os.system('modprobe w1-therm')

base_dir = '/sys/bus/w1/devices/'
device_folder = glob.glob(base_dir + '28*')[0]
device_file = device_folder + '/w1_slave'

GPIO.cleanup()
GPIO.setmode(GPIO.BCM)

fan1Pins = [22,26,27] #array of pins for fan 1 & 2
fan2Pins = [23,24,25]

for a in fan1Pins: #Setup pins for Fan 1 & 2 as output and turn them off
	GPIO.setup(a, GPIO.OUT)
	GPIO.output(a, False)

for a in fan2Pins:
	GPIO.setup(a, GPIO.OUT)
	GPIO.output(a, False)

seasonFlag = 0

def read_temp_raw(): #reads file for temperature sensor
	f = open(device_file, 'r')
	lines = f.readlines()
	f.close()
	return lines

def read_temp(): #Gets temperature in Celcius and returns it to the program
	lines = read_temp_raw()
	while lines[0].strip()[-3:] != 'YES':
		time.sleep(0,2)
		lines = read_temp_raw()
	equals_pos = lines[1].find('t=')
	if equals_pos != -1:
		temp_string = lines[1][equals_pos+2:]
		temp_c = float(temp_string) / 1000.0
		temp_f = temp_c * 9.0 / 5.0 +32.0
		print(temp_f)
		return temp_c

def fan_Calculation_Summer(t1,t2,t3):#t1-sensor, t2-input, t3-base temp 
	if t1 == t2:
		r = t1-t3
		d = r/3
		if d >= 3:
			for a in fan1Pins:
				GPIO.output(a, True)
			for a in fan2Pins:
				GPIO.output(a,True)
			print('fan 1 & 2 high')
		elif d >= 2:
			GPIO.output(22, True)
			GPIO.output(26, True)
			GPIO.output(27, False)
			GPIO.output(23, True)
			GPIO.output(24, True)
			GPIO.output(25, False)
			print('fan 1 & 2 med')
		elif d >=1:
			GPIO.output(22, True)
			GPIO.output(26, False)
			GPIO.output(27, False)
			GPIO.output(23, True)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 & 2 low')
		else:
			for a in fan1Pins:
				GPIO.output(a, False)
			for a in fan2Pins:
				GPIO.output(a, False) 
			print('fan 1 & 2 off')
	elif t1<t2:
		r = t2-t3
		d = r/3
		if d >= 3:
			for a in fan1Pins:
				GPIO.output(a, True)
			print('fan 1 high')
			if (t1-t3)/3 >=3:
                                GPIO.output(23, True)
                                GPIO.output(24, True)
                                GPIO.output(25, False)
				print('fan 2 med')
                        elif (t1-t3)/3 >=2:
                                GPIO.output(23, True)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 low')

                        else:
                                GPIO.output(23, False)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 off')

		elif d >=2:
			GPIO.output(22, True)
			GPIO.output(27, True)
			GPIO.output(26, False)
			print('fan 1 med')

			if (t1-t3)/3 >=1:
                                GPIO.output(23, True)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 low')

                        else:
                                GPIO.output(23, False)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 off')

		elif d >=1:
			GPIO.output(22, True)
			GPIO.output(27, False)
			GPIO.output(26, False)
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 low')
			print('fan 2 off')

		else:
			GPIO.output(22, False)
			GPIO.output(27, False)
			GPIO.output(26, False)
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 & 2 off')

	elif t1>t2:
		r = t1-t3
		d = r/3
		if d >= 3:
			for a in fan2Pins:
				GPIO.output(a, True)
				print('fan 2 high')

			if (t2-t3)/3 >=3:
                                GPIO.output(22, True)
                                GPIO.output(27, True)
                                GPIO.output(26, False)
				print('fan 1 med')

                        elif (t2-t3)/3 >=2:
                                GPIO.output(22, True)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 low')

                        else:
                                GPIO.output(22, False)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 off')

		elif d >=2:
			GPIO.output(23, True)
			GPIO.output(24, True)
			GPIO.output(25, False)
			print('fan 2 med')

			if (t3-t2)/3 >=1:
                                GPIO.output(22, True)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 low')

                        else:
                                GPIO.output(22, False)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 off')

		elif d >=1:
			GPIO.output(23, True)
			GPIO.output(24, False)
			GPIO.output(25, False)
			GPIO.output(22, False)
                        GPIO.output(27, False)
                        GPIO.output(26, False)
			print('fan 2 low')
			print('fan 1 off')

		else:
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			GPIO.output(22, False)
                        GPIO.output(27, False)
                        GPIO.output(26, False)
			print('fan 1 & 2 off')

	else:
		for a in fan1Pins:
			GPIO.output(a, False)
		for a in fan2Pins:
			GPIO.output(a, False)
		print('fan 1 & 2 off')
	return r

def fan_Calculation_Winter(t1,t2,t3):#t1-sensor, t2-input, t3-base temp 
	if t1 == t2:
		r = t3-t1
		d = r/3
		if d >= 3:
			for a in fan1Pins:
				GPIO.output(a, True)
			for a in fan2Pins:
				GPIO.output(a,True)
			print('fan 1 & 2 high')
		elif d >= 2:
			GPIO.output(22, True)
			GPIO.output(26, True)
			GPIO.output(27, False)
			GPIO.output(23, True)
			GPIO.output(24, True)
			GPIO.output(25, False)
			print('fan 1 & 2 med')
		elif d >=1:
			GPIO.output(22, True)
			GPIO.output(26, False)
			GPIO.output(27, False)
			GPIO.output(23, True)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 & 2 low')
		else:
			for a in fan1Pins:
				GPIO.output(a, False)
			for a in fan2Pins:
				GPIO.output(a, False) 
			print('fan 1 & 2 off')
	elif t1>t2:
		r = t3-t2
		d = r/3
		if d >= 3:
			for a in fan1Pins:
				GPIO.output(a, True)
				print('fan 1 high')

			if (t3-t1)/3 >=3:
                                GPIO.output(23, True)
                                GPIO.output(24, True)
                                GPIO.output(25, False)
				print('fan 2 med')

                        elif (t3-t1)/3 >=2:
                                GPIO.output(23, True)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 low')

                        else:
                                GPIO.output(23, False)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 off')

		elif d >=2:
			GPIO.output(22, True)
			GPIO.output(27, True)
			GPIO.output(26, False)
			print('fan 1 med')

			if (t3-t2)/3 >=1:
                                GPIO.output(23, True)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 low')

                        else:
                                GPIO.output(23, False)
                                GPIO.output(24, False)
                                GPIO.output(25, False)
				print('fan 2 off')

		elif d >=1:
			GPIO.output(22, True)
			GPIO.output(27, False)
			GPIO.output(26, False)
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 low')
			print('fan 2 off')

		else:
			GPIO.output(22, False)
			GPIO.output(27, False)
			GPIO.output(26, False)
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			print('fan 1 & 2 off')

	elif t2>t1:
		r = t3-t1
		d = r/3
		if d >= 3:
			for a in fan2Pins:
				GPIO.output(a, True)
				print('fan 2 high')

			if (t3-t2)/3 >=3:
                                GPIO.output(22, True)
                                GPIO.output(27, True)
                                GPIO.output(26, False)
				print('fan 1 med')

                        elif (t3-t2)/3 >=2:
                                GPIO.output(22, True)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 low')

                        else:
                                GPIO.output(22, False)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 off')

		elif d >=2:
			GPIO.output(23, True)
			GPIO.output(24, True)
			GPIO.output(25, False)
			print('fan 2 med')

			if (t3-t2)/3 >=1:
                                GPIO.output(22, True)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 low')

                        else:
                                GPIO.output(22, False)
                                GPIO.output(27, False)
                                GPIO.output(26, False)
				print('fan 1 off')

		elif d >=1:
			GPIO.output(23, True)
			GPIO.output(24, False)
			GPIO.output(25, False)
			GPIO.output(22, False)
                        GPIO.output(27, False)
                        GPIO.output(26, False)
			print('fan 2 low')
			print('fan 1 off')

		else:
			GPIO.output(23, False)
			GPIO.output(24, False)
			GPIO.output(25, False)
			GPIO.output(22, False)
                        GPIO.output(27, False)
                        GPIO.output(26, False)
			print('fan 1 & 2 off')
	else:
		for a in fan1Pins:
			GPIO.output(a, False)
		for a in fan2Pins:
			GPIO.output(a, False)
		print('fan 1 & 2 off')
	return r

def fan_on(): #turns fan system on
	for a in fan1Pins:
		GPIO.output(a,True)
	print('fan 1 high')

	for a in fan2Pins:
		GPIO.output(a,True)
	print('fan 2 high')

	return a

while True:
	c_temp = read_temp()
	temp_f1 = c_temp * 9.0 / 5.0 + 32.0
	print(temp_f1)
	print('Please enter a second temperature.') #user input second temp
	temp_f2 = float(input())
	print('Please enter the base temperature.') #user input ideal temp
	base_t = float(input())
	print('Enter the season for fans: 0)Summer, 1)Winter, 2)Fans On, 3)Fans Off') #user input season
	seasonFlag = int(input())
	time.sleep(2)
	if seasonFlag == 0:
		fan_Calculation_Summer(temp_f1, temp_f2, base_t) #Calculates for room to be cooler
	elif seasonFlag == 1:
		fan_Calculation_Winter (temp_f1, temp_f2, base_t) #Calculates for room to be warmer
	elif seasonFlag == 2:
		fan_on() #turns fans on for the whole system
	elif seasonFlag ==3: #turns fans off for the whole system
		for a in fan1Pins:
			GPIO.output(a, False)
		for a in fan2Pins:
			GPIO.output(a, False)
		print('fan 1 & 2 off')

	time.sleep(3)
