/*declare variables*/
const int sensorPin = A0;
const int sensorPin1 = A2;
const int InPin1 = 7;
const int OutPin1 = 4;
int outside = 0, inside = 0;


void setup() {
  // Start the serial transmission and set which pins will be input and output
  // the ADC pins require no specification
  Serial.begin(9600);
  pinMode(InPin1, OUTPUT);
  pinMode(OutPin1, INPUT);
}

void loop() {
  //read in the analog data from both of the infrared sensors
  outside = analogRead(sensorPin);
  inside = analogRead(sensorPin1);
  
  //print the information read from the sensors to the serial monitor for debugging purposes
  Serial.print("sensor in: ");
  Serial.println(outside);
  Serial.print("sensor out: ");
  Serial.println(inside);
  
  //if the outside sennsor is tripped execute the following
  if(outside >= 500){
    //wait for five seconds and then read the inside sensor
   delay(5000);
   inside = analogRead(sensorPin1);
   
   //if the inside sensor is tripped execute the following
   if(inside >= 500){
     //print that someone is entering the room 
      Serial.println("GOING IN");
      
      //write digital high to signal to the raspberry pi
      digitalWrite(InPin1, HIGH);
      
      //wait a half a second to allow the Pi to pick up the change in signal state
      delay(500);
      
      //set the pin back to low
      digitalWrite(InPin1, LOW);
   } 
  }
  //if the inside pin has been tripped execute the following
  if(inside >= 500){
    //wait five seconds and read the outside pin 
   delay(5000);
   outside = analogRead(sensorPin);
   
   //if the outside pin has been tripped perform the following
   if(outside >= 500){
     //print that someone is leaving the room
    Serial.println("GOING OUT");

    //write a high signal tot he pi to show that someone is going out of the room
    digitalWrite(OutPin1, HIGH);

    //wait half a second to allow for time to pick up the change in state
    delay(500);

    //set the pin low again
    digitalWrite(OutPin1, LOW);
   } 
  }
  //wait one second between data sample collection
  delay(1000);
}
