/*
 ============================================================================
 Name        : ece4220Project.c
 Author      : bwjmbb
 Version     :
 Copyright   : 
 Description : Hello World in C, Ansi-style
 ============================================================================
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "serial_ece4220.h"
#include <fcntl.h>
#include <time.h>
#include <math.h>
#include <pthread.h>

// Define the maximum message size that can
// be recieved via serial
#define MSG_SIZE 30
#define NAME_SIZE 25
#define PASS_SIZE 12

typedef struct{
	char *name;
	double passTime;
	double distance;
	double initVelocity;
	double maxHeight;
	double acceleration;
	int angle;
	char passRoute[5][PASS_SIZE];
}Data;

// Function prototypes
double randFloat(double, double);
void print_data(Data);
void print_route(int,Data);
void check_create(int);

// Main
int main(int argc,char *argv[]) {

	// Define variables
	int portId = 0, numBytes = 0, angle = 0,totalPasses = 0, counter = 0, checkPipeWrite = 0;
	double distance = 0.00, initVelocity = 0.00, passTime = 0.00, maxHeight = 0.00,
			Vox = 0.00, Voy = 0.00,Vx = 0.00, Vy = 0.00, accel = 0.00;

	char name[NAME_SIZE] = "";
	char timer = 'x';
	pthread_t thread;

	//Open file
	int file = open("/dev/rtf/20",O_WRONLY);

	srand(time(NULL));

	// Open up port from the local machine
	portId = serial_open(0,5,5);

	// Ready to start reading
	printf("Enter the name of the Quarterback you want to record passes for:");
	fflush(stdout);
	scanf("%s",name);

	printf("Insert the number of passes you would like to record:");
	fflush(stdout);
	scanf("%d",&totalPasses);

	Data person[totalPasses];

	// Loop to read in multiple times from serial
	while(counter < totalPasses){

		// Initial Variables
		int indexP = 0;
		char timeRec[MSG_SIZE] = "";

		memset(timeRec, '\0', sizeof(timeRec));

		// Read while the condition is true to get whole serial value
		do{
			numBytes = read(portId,&timeRec[indexP],sizeof(char));
			indexP += numBytes;

		}while(timeRec[indexP-1] != '\n' && numBytes > 0);

		// Check to make sure the read function worked
		if (numBytes < 0) {
			printf("Error reading\n");
			fflush(stdout);
			exit(0);
		}
		else if (numBytes == 0) {
			printf("Read nothing\n");
			fflush(stdout);
			exit(0);
		}

		// Convert char array passTime to double to check
		// and perform operations on
		passTime = (double)atoi(timeRec);

		// Use time to randomly generate a distance and angle
		if(passTime >= 0 && passTime < 750){
			distance = randFloat(2.00,7.00);
			angle = (rand() % 3) + 12;
		}
		else if(passTime >= 750 && passTime < 1500){
			distance = randFloat(7.00,15.00);
			angle = (rand() % 6) + 15;
		}
		else if(passTime >= 1500 && passTime < 2250){
			distance = randFloat(15.00,25.00);
			angle = (rand() % 7) + 21;
		}
		else if(passTime >= 2250 && passTime < 3000){
			distance = randFloat(25.00,35.00);
			angle = (rand() % 7) + 28;
		}
		else if(passTime >= 3000 && passTime < 3750){
			distance = randFloat(35.00,45.00);
			angle = (rand() % 7) + 37;
		}
		else if(passTime >= 3750 && passTime < 4250){
			distance = randFloat(45.00,55.00);
			angle = (rand() % 7) + 44;
		}
		else if(passTime >= 4250 && passTime < 5000){
			distance = randFloat(55.00,65.00);
			angle = (rand() % 7) + 51;
		}
		else if(passTime >= 5000 && passTime < 5750){
			distance = randFloat(65.00,80.00);
			angle = (rand() % 7) + 58;
		}
		else if(passTime > 5750){
			distance = randFloat(65.00,80.00);
			angle = (rand() % 7) + 65;
		}

		// Convert to seconds to calculate velocity
		passTime = passTime/1000;

		// Calculate velocity (f/s)
		initVelocity = distance/passTime;

		// Calculate
		Vox = initVelocity*cos(angle);
		Voy = initVelocity*sin(angle);

		Vx = Vox;
		Vy = Voy - 9.8*passTime;

		accel = sqrt(pow(Vx,2.00) + pow(Vy,2.00));

		/*
		 * Using Eq. h = (Vf^2 - Vi^2) / 2g
		 * h = max height, Vf = final velocity, Vi = initial velocity
		 * g = gravity (negative)
		 */
		maxHeight = (0.00-pow(initVelocity,2.00)) / (2 * -9.8);

		// Set all the values calculated into a structure array
		person[counter].acceleration = accel;
		person[counter].distance = distance;
		person[counter].initVelocity = initVelocity;
		person[counter].maxHeight = maxHeight;
		person[counter].name = name;
		person[counter].passTime = passTime;
		person[counter].angle = angle;

		print_data(person[counter]);

		// Determine pass route
		if(distance < 5){
			strcpy(person[counter].passRoute[0],"Flat");
			strcpy(person[counter].passRoute[1],"RB Screen");
			strcpy(person[counter].passRoute[2],"WR Screen");
			print_route(3,person[counter]);
		}
		else if(distance >= 5 && distance < 10){
			strcpy(person[counter].passRoute[0],"5 Yard Dig");
			strcpy(person[counter].passRoute[1],"5 Yard Out");
			strcpy(person[counter].passRoute[2],"Hitch");
			strcpy(person[counter].passRoute[3],"Slant");
			print_route(4,person[counter]);
		}
		else if(distance >= 10 && distance < 15){
			strcpy(person[counter].passRoute[0],"Comeback");
			strcpy(person[counter].passRoute[1],"Curl");
			strcpy(person[counter].passRoute[2],"Fade");
			strcpy(person[counter].passRoute[3],"Out");
			strcpy(person[counter].passRoute[4],"Post");
			print_route(5,person[counter]);
		}
		else if(distance >= 15 && distance < 25){
			strcpy(person[counter].passRoute[0],"Corner");
			strcpy(person[counter].passRoute[1],"Dig");
			strcpy(person[counter].passRoute[2],"Fade");
			strcpy(person[counter].passRoute[3],"Post");
			print_route(4,person[counter]);
		}
		else if(distance >= 25){
			strcpy(person[counter].passRoute[0],"Fade");
			strcpy(person[counter].passRoute[1],"Post");
			print_route(2,person[counter]);
		}
		++counter;
	}
	// Exit
	return 0;
}

// Function to generate a random float value
double randFloat( double low, double high ) {
    return ((double)rand()*(high - low)) / (double)RAND_MAX + low;
}

// Function to print data
void print_data(Data person){
	printf("Name: %s\n",person.name);
	printf("Time of Pass: %.2f seconds\n",person.passTime);
	printf("Distance of: %.2f yards\n",person.distance);
	printf("Angle of Velocity: %d\n",person.angle);
	printf("Initial Velocity: %.2f yards per second\n",person.initVelocity);
	printf("Acceleration: %.2f yards per second\n",person.acceleration);
	printf("Possible Passes Thrown: ");
}

// Function to print passRoute data
void print_route(int size, Data person){
	int i = 0;

	for(i = 0; i < size; i++){
		if(i != size -1){
			printf(" %s,", person.passRoute[i]);
		}
		else{
			printf(" %s\n\n", person.passRoute[i]);
			fflush(stdout);
		}
	}
}
