/*
 ============================================================================
 Name        : serial4220.c
 Author      : BWJ
 Version     :
 Copyright   : Brenyn Jungmann's Project
 Description : ECE4220 Project
 ============================================================================
 */

#include <stdio.h>      // standard input / output functions
#include <stdlib.h>
#include <string.h>     // string function definitions
#include <unistd.h>     // UNIX standard function definitions
#include <fcntl.h>      // File control definitions
#include <errno.h>      // Error number definitions
#include <termios.h>    // POSIX terminal control definitions
#include "serial_ece4220.h"

#define MSG_SIZE 30

int main(void)
{
	// Variable definitions
	struct termios tty;
	struct termios tty_old;
	int n = 0, m = 0;

	// Open serial port from arduino
	int USB = open("/dev/ttyACM0",O_RDWR| O_NOCTTY);

	// Open serial port to the TS-7250 board
	int a = serial_open(0,5,5);

	// Check to make sure file opened correctly
	if(USB < 0){
		printf("File USB did not open correctly.\n");
		exit(0);
	}

	memset (&tty, 0, sizeof tty);

	// Error Handling
	if ( tcgetattr ( USB, &tty ) != 0 ) {
		printf("Error1\n");
	}

	// Save old tty parameters
	tty_old = tty;

	// Set Baud Rate
	cfsetospeed (&tty, (speed_t)B9600);
	cfsetispeed (&tty, (speed_t)B9600);

	// Setting other Port Stuff
	tty.c_cflag     &=  ~PARENB;            // Make 8n1
	tty.c_cflag     &=  ~CSTOPB;
	tty.c_cflag     &=  ~CSIZE;
	tty.c_cflag     |=  CS8;

	tty.c_cflag     &=  ~CRTSCTS;           // No flow control
	tty.c_cc[VMIN]   =  1;                  // Read doesn't block
	tty.c_cc[VTIME]  =  5;                  // 0.5 seconds read timeout
	tty.c_cflag     |=  CREAD | CLOCAL;     // Turn on READ & ignore ctrl lines

	// Make raw
	cfmakeraw(&tty);

	// Flush Port, then applies attributes
	tcflush( USB, TCIFLUSH );
	if ( tcsetattr ( USB, TCSANOW, &tty ) != 0) {
		printf("Error2\n");
	}

	// Loop to read from arduino multiple times
	while(1){
		//Initialize Variables
		int spot = 0;
		char response[MSG_SIZE] = "";

		memset(response, '\0', MSG_SIZE);

		// Serial Port is ready
		printf("The serial port is ready to read and send data...\n");

		// Read data from the arduino via serial to local machine
		// Once I have data from arduino forward to the TS-7250 board
		// Do this for every character received from the arduino
		do {
		   n = read(USB, &response[spot], sizeof(char));
		   m = write(a,&response[spot], sizeof(char));
		   spot += n;
		} while(response[spot-1] != '\n' && n > 0);

		// Error check the read from the arduino
		if (n < 0) {
			printf("Error reading\n");
			fflush(stdout);
		}
		else if (n == 0) {
			printf("Read nothing\n");
			fflush(stdout);
		}
		else {
			printf("PassTime (in ms) = %s",response);
			fflush(stdout);
		}

		// Error check the write to TS-7250 via serial
		if (m < 0) {
			printf("Error writing\n");
		}
		else if (m == 0) {
			printf("Wrote nothing\n");
		}
		else {
			printf("SentData to TS-7250\n");
		}

	}
	// Exit
	return 0;
}
